/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.ingame;

import java.util.ArrayList;
import journeymap.client.JourneymapClient;
import journeymap.client.log.JMLogger;
import journeymap.client.render.JMRenderTypes;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.ingame.WaypointRenderer;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.Journeymap;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import org.joml.Quaternionfc;

public class WaypointBeaconRenderer
extends WaypointRenderer {
    @Override
    public void render(class_332 graphics) {
        this.waypointProperties = JourneymapClient.getInstance().getWaypointProperties();
        String playerDim = this.minecraft.field_1724.method_5770().method_27983().method_29177().toString();
        class_4597.class_4598 buffers = this.minecraft.method_22940().method_23000();
        try {
            ArrayList<ClientWaypointImpl> waypoints = new ArrayList<ClientWaypointImpl>(WaypointStore.getInstance().getAll());
            this.deleteQueue = new ArrayList();
            for (ClientWaypointImpl waypoint : waypoints) {
                if (!this.canDrawWaypoint(waypoint, playerDim) || this.waypointProperties.shaderBeacon.get().booleanValue() && !this.waypointProperties.showRotatingBeam.get().booleanValue() && !this.waypointProperties.showStaticBeam.get().booleanValue()) continue;
                try {
                    this.renderWaypoint(waypoint, graphics, DrawStep.Pass.PreObject, (class_4597)buffers);
                }
                catch (Exception t) {
                    Journeymap.getLogger().error("Waypoint beacon failed to render for " + waypoint.getName() + ": ", (Throwable)t);
                }
            }
        }
        catch (Throwable t) {
            JMLogger.throwLogOnce("Error rendering all waypoints. Thread:" + Thread.currentThread().getName(), t);
        }
        this.deleteQueue.forEach(wp -> WaypointStore.getInstance().remove((ClientWaypointImpl)wp, true));
        this.deleteQueue.clear();
        buffers.method_22993();
    }

    @Override
    protected void render(class_332 graphics, DrawStep.Pass pass, class_4597 buffers, ClientWaypointImpl waypoint, float partialTicks, long gameTime, float[] rgba, float fadeAlpha, double shiftX, double shiftY, double shiftZ, class_243 playerVec, class_243 waypointVec, double viewDistance, double actualDistance, double scale) {
        boolean showStaticInnerBeam = this.waypointProperties.showStaticBeam.get();
        boolean showRotatingOuterBeam = this.waypointProperties.showRotatingBeam.get();
        if (!showStaticInnerBeam && !showRotatingOuterBeam) {
            return;
        }
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22904(shiftX, -180.0, shiftZ);
        this.renderBeamSegment(graphics, buffers, partialTicks, gameTime, 1, 360, rgba, 0.2f, 0.25f, showStaticInnerBeam, showRotatingOuterBeam);
        graphics.method_51448().method_22909();
    }

    public void renderBeamSegment(class_332 graphics, class_4597 buffer, float partialTicks, long gameTime, int yOffset, int height, float[] colors, float beamRadius, float glowRadius, boolean showStaticInnerBeam, boolean showRotatingOuterBeam) {
        float texScale = 1.0f;
        int heightOffset = yOffset + height;
        float rotation = (float)Math.floorMod(gameTime, 40L) + partialTicks;
        float texOffset = -((float)(-gameTime) * 0.2f - (float)class_3532.method_15375((float)((float)(-gameTime) * 0.1f))) * 0.6f;
        float red = colors[0];
        float blue = colors[1];
        float green = colors[2];
        float alpha = colors[3];
        class_4588 beamBuffer = buffer.getBuffer(class_1921.method_23592((class_2960)JMRenderTypes.WAYPOINT_DEFAULT_BEAM, (boolean)true));
        graphics.method_51448().method_22903();
        if (!showStaticInnerBeam) {
            graphics.method_51448().method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(rotation * 2.25f - 45.0f));
        }
        float V2 = -1.0f + texOffset;
        float innerV1 = (float)height * texScale * (0.5f / beamRadius) + V2;
        WaypointBeaconRenderer.renderPart(graphics, beamBuffer, red, blue, green, alpha, yOffset, heightOffset, 0.0f, beamRadius, beamRadius, 0.0f, -beamRadius, 0.0f, 0.0f, -beamRadius, 0.0f, 1.0f, innerV1, V2);
        graphics.method_51448().method_22909();
        float outerV1 = (float)height * texScale + V2;
        graphics.method_51448().method_22903();
        if (showRotatingOuterBeam) {
            graphics.method_51448().method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(rotation * 2.25f - 45.0f));
        }
        WaypointBeaconRenderer.renderPart(graphics, beamBuffer, red, blue, green, alpha, yOffset, heightOffset, -glowRadius, -glowRadius, glowRadius, -glowRadius, -glowRadius, glowRadius, glowRadius, glowRadius, 0.0f, 1.0f, outerV1, V2);
        graphics.method_51448().method_22909();
    }

    private static void renderPart(class_332 graphics, class_4588 buffer, float red, float green, float blue, float alpha, int yMin, int yMax, float p1, float p2, float p3, float p4, float p5, float p6, float p7, float p8, float u1, float u2, float v1, float v2) {
        WaypointBeaconRenderer.addQuad(graphics, buffer, red, green, blue, alpha, yMin, yMax, p1, p2, p3, p4, u1, u2, v1, v2);
        WaypointBeaconRenderer.addQuad(graphics, buffer, red, green, blue, alpha, yMin, yMax, p7, p8, p5, p6, u1, u2, v1, v2);
        WaypointBeaconRenderer.addQuad(graphics, buffer, red, green, blue, alpha, yMin, yMax, p3, p4, p7, p8, u1, u2, v1, v2);
        WaypointBeaconRenderer.addQuad(graphics, buffer, red, green, blue, alpha, yMin, yMax, p5, p6, p1, p2, u1, u2, v1, v2);
    }

    private static void addQuad(class_332 graphics, class_4588 bufferIn, float red, float green, float blue, float alpha, int yMin, int yMax, float x1, float z1, float x2, float z2, float u1, float u2, float v1, float v2) {
        DrawUtil.addVertexUV(graphics.method_51448(), bufferIn, red, green, blue, alpha, yMax, x1, z1, u2, v1);
        DrawUtil.addVertexUV(graphics.method_51448(), bufferIn, red, green, blue, alpha, yMin, x1, z1, u2, v2);
        DrawUtil.addVertexUV(graphics.method_51448(), bufferIn, red, green, blue, alpha, yMin, x2, z2, u1, v2);
        DrawUtil.addVertexUV(graphics.method_51448(), bufferIn, red, green, blue, alpha, yMax, x2, z2, u1, v1);
    }
}

