/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import journeymap.api.plugins.PokemonOptionsPlugin;
import journeymap.api.v2.client.display.Context;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.model.entity.EntityDTO;
import journeymap.client.properties.InGameMapProperties;
import journeymap.client.render.draw.DrawEntityStep;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.map.Renderer;
import journeymap.client.ui.minimap.EntityDisplay;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.util.ReflectionHelper;
import net.minecraft.class_1043;
import net.minecraft.class_1297;
import net.minecraft.class_1496;
import net.minecraft.class_1657;

public class RadarDrawStepFactory {
    public List<DrawStep> prepareSteps(List<EntityDTO> entityDTOs, Renderer renderer, InGameMapProperties mapProperties) {
        boolean showAnimals = mapProperties.showAnimals.get();
        boolean showAmbient = mapProperties.showAmbientCreatures.get();
        boolean showPets = mapProperties.showPets.get();
        boolean showVillagers = mapProperties.showVillagers.get();
        EntityDisplay mobDisplay = (EntityDisplay)((Object)mapProperties.mobDisplay.get());
        EntityDisplay playerDisplay = (EntityDisplay)((Object)mapProperties.playerDisplay.get());
        boolean showMobHeading = mapProperties.showMobHeading.get();
        boolean showPlayerHeading = mapProperties.showPlayerHeading.get();
        boolean showTeamNames = mapProperties.showTeamNames.get();
        boolean showPlayerNames = mapProperties.showPlayerNames.get();
        float mobDisplayDrawScale = mapProperties.mobDisplayScale.get().floatValue();
        float playerDisplayDrawScale = mapProperties.playerDisplayScale.get().floatValue();
        ArrayList<DrawStep> drawStepList = new ArrayList<DrawStep>();
        try {
            for (EntityDTO dto : entityDTOs) {
                try {
                    class_1496 horse;
                    boolean isPet;
                    class_1043 entityIcon = null;
                    class_1043 locatorImg = null;
                    class_1043 locatorBGImg = null;
                    class_1297 entityLiving = (class_1297)dto.entityRef.get();
                    boolean isPlayer = entityLiving instanceof class_1657;
                    if (entityLiving == null || renderer.getPixel(dto.posX, dto.posZ) == null && (!isPlayer || (renderer.getContext() != Context.UI.Minimap || !JourneymapClient.getInstance().getActiveMiniMapProperties().showOffScreenPlayers.get().booleanValue()) && (renderer.getContext() != Context.UI.Fullscreen || !JourneymapClient.getInstance().getFullMapProperties().showOffScreenPlayers.get().booleanValue()))) continue;
                    boolean bl = isPet = dto.owner != null && !Strings.isNullOrEmpty((String)dto.owner) || entityLiving instanceof class_1496 && (horse = (class_1496)entityLiving).method_6727();
                    if (!showPets && isPet || !showAmbient && dto.ambientCreature && !isPlayer && (!isPet || !showPets)) continue;
                    boolean isPokemon = this.isPokemon(entityLiving);
                    if (showAnimals || isPokemon || !dto.passiveAnimal || isPlayer ? isPokemon && !PokemonOptionsPlugin.getInstance().showPokemon() : !isPet || !showPets) continue;
                    if (!showVillagers && (dto.profession != null || dto.npc)) continue;
                    DrawEntityStep drawStep = DataCache.INSTANCE.getDrawEntityStep(entityLiving);
                    if (isPlayer) {
                        locatorImg = EntityDisplay.getLocatorTexture(playerDisplay, showPlayerHeading);
                        locatorBGImg = EntityDisplay.getLocatorBGTexture(playerDisplay, showPlayerHeading);
                        class_1657 entity = (class_1657)entityLiving;
                        entityIcon = EntityDisplay.getEntityTexture(playerDisplay, entity.method_7334());
                        boolean outlined = playerDisplay.isOutlined();
                        drawStep.update(playerDisplay, locatorImg, locatorBGImg, entityIcon, dto.color, dto.labelColor, showPlayerHeading, showTeamNames, showPlayerNames, outlined, playerDisplayDrawScale);
                        drawStepList.add(drawStep);
                        continue;
                    }
                    EntityDisplay actualDisplay = mobDisplay;
                    if (!EntityDisplay.hasEntityIcon(actualDisplay, dto)) {
                        actualDisplay = mobDisplay.getDot();
                    }
                    locatorImg = EntityDisplay.getLocatorTexture(actualDisplay, showMobHeading);
                    locatorBGImg = EntityDisplay.getLocatorBGTexture(actualDisplay, showMobHeading);
                    entityIcon = EntityDisplay.getEntityTexture(actualDisplay, dto);
                    drawStep.update(actualDisplay, locatorImg, locatorBGImg, entityIcon, dto.color, dto.labelColor, showMobHeading, false, false, false, mobDisplayDrawScale);
                    drawStepList.add(drawStep);
                }
                catch (Exception e) {
                    Journeymap.getLogger().error("Exception during prepareSteps: " + LogFormatter.toString(e));
                }
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Throwable during prepareSteps: " + LogFormatter.toString(t));
        }
        return drawStepList;
    }

    private boolean isPokemon(class_1297 entity) {
        return PokemonOptionsPlugin.hasPokemonMod() && ReflectionHelper.isInstanceOf(entity, "com.cobblemon.mod.common.entity.pokemon.PokemonEntity", "com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon");
    }
}

