/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.OptionalDouble;
import journeymap.api.client.impl.ClientAPI;
import journeymap.api.v2.client.display.Context;
import journeymap.client.JourneymapClient;
import journeymap.client.render.Pipelines;
import journeymap.client.render.RegionTileShaders;
import journeymap.client.render.RenderWrapper;
import journeymap.client.texture.RegionTexture;
import net.minecraft.class_10868;
import net.minecraft.class_1921;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4668;
import net.minecraft.class_9801;
import net.minecraft.class_9851;

public class JMRenderTypes
extends class_1921 {
    public static final class_2960 WAYPOINT_DEFAULT_BEAM = class_2960.method_60654((String)"textures/entity/beacon_beam.png");
    static final Object2ObjectOpenHashMap<class_2960, class_1921> GRID_LINES_RENDER_TYPE_MAP = new Object2ObjectOpenHashMap();
    static final Int2ObjectOpenHashMap<Int2ObjectOpenHashMap<class_1921>> REGION_TILE_RENDER_TYPE_MAP = new Int2ObjectOpenHashMap();
    static final Int2ObjectOpenHashMap<class_1921> ICON_RENDER_TYPE_MAP = new Int2ObjectOpenHashMap();
    static final Int2ObjectOpenHashMap<class_1921> ICON_CLAMP_RENDER_TYPE_MAP = new Int2ObjectOpenHashMap();
    static final Int2ObjectOpenHashMap<class_1921> ICON_NOBLUR_RENDER_TYPE_MAP = new Int2ObjectOpenHashMap();
    static final Int2ObjectOpenHashMap<class_1921> ICON_UNMASKED_RENDER_TYPE_MAP = new Int2ObjectOpenHashMap();
    static final Int2ObjectOpenHashMap<class_1921> POLYGON_WITH_TEXTURE_RENDER_TYPE_MAP = new Int2ObjectOpenHashMap();
    protected static final class_4668.class_4684 GRID_LINES_TRANSPARENCY = new class_4668.class_4684("grid_lines_transparency", () -> {
        RenderWrapper.enableBlend();
        RenderWrapper.blendFuncSeparate(770, 771, 1, 771);
        RenderWrapper.texParameter(3553, 10241, 9728);
        RenderWrapper.texParameter(3553, 10240, 9728);
        RenderWrapper.texParameter(3553, 10242, 10497);
        RenderWrapper.texParameter(3553, 10243, 10497);
    }, () -> {
        RenderWrapper.disableBlend();
        RenderWrapper.defaultBlendFunc();
    });
    protected static final class_4668.class_4684 MINIMAP_MASK_TRANSPARENCY = new class_4668.class_4684("minimap_mask_texturing", () -> RenderSystem.getDevice().createCommandEncoder().clearDepthTexture(class_310.method_1551().method_1522().method_30278(), 0.0), () -> RenderWrapper.depthFunc(515));
    protected static final class_4668.class_4675 ICON_TRANSPARENCY = new class_4668.class_4675("icon_transparency", () -> {
        RenderWrapper.enableBlend();
        RenderWrapper.blendFuncSeparate(770, 771, 1, 0);
    }, () -> {
        RenderWrapper.disableBlend();
        RenderWrapper.defaultBlendFunc();
    });
    protected static final class_4668.class_4675 POLYGON_TRANSPARENCY = new class_4668.class_4675("polygon_transparency", () -> {
        RenderWrapper.enableBlend();
        RenderWrapper.blendFuncSeparate(770, 771, 1, 0);
        RenderWrapper.texParameter(3553, 10241, 9728);
        RenderWrapper.texParameter(3553, 10240, 9728);
        RenderWrapper.texParameter(3553, 10242, 10497);
        RenderWrapper.texParameter(3553, 10243, 10497);
    }, () -> {
        RenderWrapper.disableBlend();
        RenderWrapper.defaultBlendFunc();
    });
    public static final class_1921 MINIMAP_RECTANGLE_MASK_RENDER_TYPE = JMRenderTypes.method_24049((String)"minimap_rectangle_mask", (int)256, (boolean)false, (boolean)false, (RenderPipeline)Pipelines.MINIMAP_RECTANGLE_MASK_RENDER_PIPELINE, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577(field_21378).method_23609(new class_4668.class_4677(OptionalDouble.empty())).method_23607(field_21352).method_23608(field_21384).method_23614(MINIMAP_MASK_TRANSPARENCY).method_23617(false));
    public static final class_1921 BEAM_RENDER_TYPE = JMRenderTypes.method_24049((String)"waypoint_beam", (int)256, (boolean)false, (boolean)false, (RenderPipeline)Pipelines.WAYPOINT_BEAM_RENDER_PIPELINE, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new class_4668.class_4683(WAYPOINT_DEFAULT_BEAM, class_9851.field_52394, false)).method_23609(new class_4668.class_4677(OptionalDouble.empty())).method_23607(field_21352).method_23608(field_21383).method_23617(false));
    public static final class_1921 RECTANGLE_RENDER_TYPE = JMRenderTypes.method_24049((String)"rectangle", (int)256, (boolean)false, (boolean)false, (RenderPipeline)Pipelines.RECTANGLE_RENDER_PIPELINE, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577(field_21378).method_23609(new class_4668.class_4677(OptionalDouble.empty())).method_23607(field_21352).method_23608(field_21384).method_23617(false));
    public static final class_1921 GRID_LINES_RENDER_TYPE = JMRenderTypes.method_24049((String)"grid_lines", (int)256, (boolean)false, (boolean)true, (RenderPipeline)Pipelines.GRID_LINES_RENDER_PIPELINE, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577(field_21378).method_23609(new class_4668.class_4677(OptionalDouble.of(1.0))).method_23607(field_21352).method_23608(field_21384).method_23617(false));
    public static final class_1921 POLYGON_WITHOUT_TEXTURE_RENDER_TYPE = JMRenderTypes.method_24049((String)"polygon", (int)256, (boolean)false, (boolean)false, (RenderPipeline)Pipelines.POLYGON_POS_PIPELINE, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577(field_21378).method_23609(new class_4668.class_4677(OptionalDouble.empty())).method_23607(field_21352).method_23608(field_21384).method_23617(false));
    public static final class_1921 POLYGON_STROKE_RENDER_TYPE = JMRenderTypes.method_24049((String)"polygon_stroke", (int)256, (boolean)false, (boolean)false, (RenderPipeline)Pipelines.POLYGON_STROKE_PIPELINE, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577(field_21378).method_23609(new class_4668.class_4677(OptionalDouble.empty())).method_23607(field_21352).method_23608(field_21384).method_23617(false));

    public static void registerMapShader(String key, RenderPipeline shader) {
        REGION_TILE_RENDER_TYPE_MAP.clear();
    }

    public static void registerPosTexColorShader() {
        POLYGON_WITH_TEXTURE_RENDER_TYPE_MAP.clear();
        ICON_UNMASKED_RENDER_TYPE_MAP.clear();
        ICON_NOBLUR_RENDER_TYPE_MAP.clear();
        ICON_RENDER_TYPE_MAP.clear();
        ICON_CLAMP_RENDER_TYPE_MAP.clear();
        REGION_TILE_RENDER_TYPE_MAP.clear();
        GRID_LINES_RENDER_TYPE_MAP.clear();
    }

    public JMRenderTypes(String name, int bufferSize, boolean useDelegate, boolean needsSorting, Runnable pre, Runnable post) {
        super(name, bufferSize, useDelegate, needsSorting, pre, post);
    }

    public void method_60895(class_9801 meshData) {
    }

    public class_276 method_68494() {
        return null;
    }

    public RenderPipeline method_68495() {
        return null;
    }

    public VertexFormat method_23031() {
        return null;
    }

    public VertexFormat.class_5596 method_23033() {
        return null;
    }

    public static void clearRegionRenderTypes(int id) {
        if (id != -1) {
            Int2ObjectOpenHashMap map = (Int2ObjectOpenHashMap)REGION_TILE_RENDER_TYPE_MAP.get(id);
            if (map != null) {
                map.clear();
            }
            REGION_TILE_RENDER_TYPE_MAP.remove(id);
        }
    }

    public static class_1921 getGridLines(class_2960 resourceLocation) {
        class_1921 type = (class_1921)GRID_LINES_RENDER_TYPE_MAP.get((Object)resourceLocation);
        if (type == null) {
            type = JMRenderTypes.method_24049((String)("grid_lines" + resourceLocation.method_36181()), (int)256, (boolean)false, (boolean)true, (RenderPipeline)Pipelines.GRID_LINES_RENDER_TYPE_PIPELINE, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new class_4668.class_4683(resourceLocation, class_9851.field_52395, false)).method_23609(new class_4668.class_4677(OptionalDouble.empty())).method_23607(field_21352).method_23608(field_21384).method_23617(false));
            GRID_LINES_RENDER_TYPE_MAP.put((Object)resourceLocation, (Object)type);
        }
        return type;
    }

    public static class_1921 getRegionTile(RegionTexture texture, int shaderIndex) {
        class_1921 type;
        int id = ((class_10868)texture.method_68004()).method_68427();
        Int2ObjectOpenHashMap map = (Int2ObjectOpenHashMap)REGION_TILE_RENDER_TYPE_MAP.get(id);
        if (map == null) {
            map = new Int2ObjectOpenHashMap();
            REGION_TILE_RENDER_TYPE_MAP.put(id, (Object)map);
        }
        if ((type = (class_1921)map.get(shaderIndex)) == null) {
            String shader = RegionTileShaders.from(shaderIndex);
            RenderPipeline shaderState = Pipelines.REGION_SHADERS_MAP.get((Object)shader) == null ? Pipelines.REGION_DEFAULT_RENDER_PIPELINE : (RenderPipeline)Pipelines.REGION_SHADERS_MAP.get((Object)shader);
            type = JMRenderTypes.method_24049((String)("region_tile" + id), (int)256, (boolean)false, (boolean)false, (RenderPipeline)shaderState, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new RegionTileStateShard(texture.method_68004())).method_23609(new class_4668.class_4677(OptionalDouble.empty())).method_23607(field_21352).method_23608(field_21384).method_23617(false));
            map.put(id, (Object)type);
        }
        return type;
    }

    public static class_1921 getMinimapCircleMask(GpuTexture texture) {
        return JMRenderTypes.method_24049((String)"minimap_circle_mask", (int)256, (boolean)false, (boolean)false, (RenderPipeline)Pipelines.MINIMAP_CIRCLE_MASK_PIPELINE, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577(new class_4668.class_5939(() -> {
            RenderWrapper.bindTexture(((class_10868)texture).method_68427());
            RenderWrapper.setShaderTexture(0, texture);
        }, () -> {})).method_23609(new class_4668.class_4677(OptionalDouble.empty())).method_23607(field_21352).method_23608(field_21384).method_23614(MINIMAP_MASK_TRANSPARENCY).method_23617(false));
    }

    public static class_1921 getIcon(GpuTexture texture) {
        int id = ((class_10868)texture).method_68427();
        class_1921 type = (class_1921)ICON_RENDER_TYPE_MAP.get(id);
        if (type == null) {
            type = JMRenderTypes.method_24049((String)("icon" + id), (int)256, (boolean)false, (boolean)false, (RenderPipeline)Pipelines.ICON_RENDER_PIPELINE, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new IconStateShard(texture)).method_23609(new class_4668.class_4677(OptionalDouble.empty())).method_23607(field_21352).method_23608(field_21384).method_23617(false));
            ICON_RENDER_TYPE_MAP.put(id, (Object)type);
        }
        return type;
    }

    public static class_1921 getIconClamp(GpuTexture texture) {
        int id = ((class_10868)texture).method_68427();
        class_1921 type = (class_1921)ICON_CLAMP_RENDER_TYPE_MAP.get(id);
        if (type == null) {
            type = JMRenderTypes.method_24049((String)("icon" + id), (int)256, (boolean)false, (boolean)false, (RenderPipeline)Pipelines.ICON_RENDER_PIPELINE, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new IconStateShard(texture, true, false)).method_23609(new class_4668.class_4677(OptionalDouble.empty())).method_23607(field_21352).method_23608(field_21384).method_23617(false));
            ICON_CLAMP_RENDER_TYPE_MAP.put(id, (Object)type);
        }
        return type;
    }

    public static class_1921 getIconNoBlur(GpuTexture texture) {
        int id = ((class_10868)texture).method_68427();
        class_1921 type = (class_1921)ICON_NOBLUR_RENDER_TYPE_MAP.get(id);
        if (type == null) {
            type = JMRenderTypes.method_24049((String)("icon" + id), (int)256, (boolean)false, (boolean)false, (RenderPipeline)Pipelines.ICON_RENDER_PIPELINE, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new IconStateShard(texture, false)).method_23609(new class_4668.class_4677(OptionalDouble.empty())).method_23607(field_21352).method_23608(field_21384).method_23617(false));
            ICON_NOBLUR_RENDER_TYPE_MAP.put(id, (Object)type);
        }
        return type;
    }

    public static class_1921 getIconUnmasked(GpuTexture texture) {
        int id = ((class_10868)texture).method_68427();
        class_1921 type = (class_1921)ICON_UNMASKED_RENDER_TYPE_MAP.get(id);
        if (type == null) {
            type = JMRenderTypes.method_24049((String)("icon_unmasked" + id), (int)256, (boolean)false, (boolean)false, (RenderPipeline)Pipelines.ICON_UNMASKED_RENDER_PIPELINE, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new IconStateShard(texture)).method_23609(new class_4668.class_4677(OptionalDouble.empty())).method_23607(field_21352).method_23608(field_21384).method_23617(false));
            ICON_UNMASKED_RENDER_TYPE_MAP.put(id, (Object)type);
        }
        return type;
    }

    public static class_1921 getPolygonWithTexture(GpuTexture texture) {
        int id = ((class_10868)texture).method_68427();
        class_1921 type = (class_1921)POLYGON_WITH_TEXTURE_RENDER_TYPE_MAP.get(id);
        if (type == null) {
            type = JMRenderTypes.method_24049((String)("polygon" + id), (int)256, (boolean)false, (boolean)false, (RenderPipeline)Pipelines.POLYGON_WITH_TEXTURE_RENDER_PIPELINE, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577(new class_4668.class_5939(() -> {
                RenderWrapper.bindTexture(id);
                RenderWrapper.setShaderTexture(0, texture);
            }, () -> {})).method_23609(new class_4668.class_4677(OptionalDouble.empty())).method_23607(field_21352).method_23608(field_21384).method_23617(false));
            POLYGON_WITH_TEXTURE_RENDER_TYPE_MAP.put(id, (Object)type);
        }
        return type;
    }

    protected static class RegionTileStateShard
    extends class_4668.class_5939 {
        private final int textureId;

        public RegionTileStateShard(GpuTexture texture) {
            super(() -> {
                RenderWrapper.bindTexture(((class_10868)texture).method_68427());
                boolean blur = false;
                if (ClientAPI.INSTANCE.getLastUIState().ui == Context.UI.Fullscreen) {
                    blur = JourneymapClient.getInstance().getFullMapProperties().zoomLevel.get() < 512;
                } else if (ClientAPI.INSTANCE.getLastUIState().ui == Context.UI.Minimap) {
                    blur = JourneymapClient.getInstance().getActiveMiniMapProperties().zoomLevel.get() < 512;
                }
                int mipmapLevels = JourneymapClient.getInstance().getCoreProperties().mipmapLevels.get();
                int mag = mipmapLevels == 0 && blur ? 9729 : 9984;
                int min = mipmapLevels == 0 && blur ? 9729 : 9728;
                RenderWrapper.bindTexture(((class_10868)texture).method_68427());
                RenderWrapper.texParameter(3553, 10241, mag);
                RenderWrapper.texParameter(3553, 10240, min);
                RenderWrapper.texParameter(3553, 10242, 33071);
                RenderWrapper.texParameter(3553, 10243, 33071);
                RenderWrapper.texParameter(3553, 33085, mipmapLevels);
                RenderWrapper.texParameter(3553, 33082, 0);
                RenderWrapper.texParameter(3553, 33083, mipmapLevels);
                RenderWrapper.texParameter(3553, 34049, 0);
                RenderWrapper.setShaderTexture(0, texture);
            }, () -> {});
            this.textureId = ((class_10868)texture).method_68427();
        }

        public String toString() {
            return this.field_21363 + "[" + this.textureId + ")]";
        }
    }

    protected static class IconStateShard
    extends class_4668.class_5939 {
        private final int textureId;
        private final boolean blur;
        private final boolean clamp;

        public IconStateShard(GpuTexture tex) {
            this(tex, true);
        }

        public IconStateShard(GpuTexture texture, boolean blur) {
            this(texture, blur, false);
        }

        public IconStateShard(GpuTexture texture, boolean blur, boolean clamp) {
            super(() -> {
                RenderWrapper.bindTexture(((class_10868)texture).method_68427());
                RenderWrapper.texParameter(3553, 10241, blur ? 9729 : 9728);
                RenderWrapper.texParameter(3553, 10240, blur ? 9729 : 9728);
                RenderWrapper.texParameter(3553, 10242, clamp ? 33071 : 10497);
                RenderWrapper.texParameter(3553, 10243, clamp ? 33071 : 10497);
                RenderWrapper.setShaderTexture(0, texture);
            }, () -> {});
            this.blur = blur;
            this.clamp = clamp;
            this.textureId = ((class_10868)texture).method_68427();
        }

        public String toString() {
            return this.field_21363 + "[" + this.textureId + "] blur:" + this.blur + " clamp:" + this.clamp;
        }
    }
}

