/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.neoforge.common;

import fr.rakambda.fallingtree.common.FallingTreeCommon;
import fr.rakambda.fallingtree.common.config.enums.BreakMode;
import fr.rakambda.fallingtree.common.leaf.LeafBreakingHandler;
import fr.rakambda.fallingtree.common.network.ServerPacketHandler;
import fr.rakambda.fallingtree.common.utils.BoundedList;
import fr.rakambda.fallingtree.common.wrapper.DirectionCompat;
import fr.rakambda.fallingtree.common.wrapper.IBlock;
import fr.rakambda.fallingtree.common.wrapper.IBlockBreakEvent;
import fr.rakambda.fallingtree.common.wrapper.IBlockPos;
import fr.rakambda.fallingtree.common.wrapper.IBlockState;
import fr.rakambda.fallingtree.common.wrapper.IComponent;
import fr.rakambda.fallingtree.common.wrapper.IItem;
import fr.rakambda.fallingtree.common.wrapper.IItemStack;
import fr.rakambda.fallingtree.common.wrapper.ILevel;
import fr.rakambda.fallingtree.common.wrapper.IPlayer;
import fr.rakambda.fallingtree.neoforge.FallingTreeUtils;
import fr.rakambda.fallingtree.neoforge.client.event.PlayerLeaveListener;
import fr.rakambda.fallingtree.neoforge.common.wrapper.BlockWrapper;
import fr.rakambda.fallingtree.neoforge.common.wrapper.ComponentWrapper;
import fr.rakambda.fallingtree.neoforge.common.wrapper.ItemStackWrapper;
import fr.rakambda.fallingtree.neoforge.common.wrapper.ItemWrapper;
import fr.rakambda.fallingtree.neoforge.event.BlockBreakListener;
import fr.rakambda.fallingtree.neoforge.event.FallingTreeBlockBreakEvent;
import fr.rakambda.fallingtree.neoforge.event.LeafBreakingListener;
import fr.rakambda.fallingtree.neoforge.event.ServerCommandRegistrationListener;
import fr.rakambda.fallingtree.neoforge.network.NeoForgePacketHandler;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.NotNull;

public class FallingTreeCommonsImpl
extends FallingTreeCommon<Direction> {
    private final IEventBus modEventBus;
    private final LeafBreakingHandler leafBreakingHandler;
    private final NeoForgePacketHandler packetHandler;
    private final TagKey<Enchantment> chopperEnchantmentTag;
    private final Map<BreakMode, TagKey<Enchantment>> breakModeChopperEnchantmentTag;
    private final List<BlockEvent.BreakEvent> breakEvents;
    private final Map<IBlock, Boolean> isLogBlockCache;
    private final Map<IBlock, Boolean> isLeafBlockCache;
    private final Map<IBlock, Boolean> isWartBlockCache;

    public FallingTreeCommonsImpl(@NotNull IEventBus modEventBus) {
        this.modEventBus = modEventBus;
        this.leafBreakingHandler = new LeafBreakingHandler(this);
        this.packetHandler = new NeoForgePacketHandler(this);
        this.isLogBlockCache = new HashMap<IBlock, Boolean>();
        this.isLeafBlockCache = new HashMap<IBlock, Boolean>();
        this.isWartBlockCache = new HashMap<IBlock, Boolean>();
        this.chopperEnchantmentTag = TagKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)FallingTreeUtils.id("chopper_all"));
        this.breakModeChopperEnchantmentTag = new HashMap<BreakMode, TagKey<Enchantment>>();
        this.breakModeChopperEnchantmentTag.put(BreakMode.FALL_ALL_BLOCK, (TagKey<Enchantment>)TagKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)FallingTreeUtils.id("chopper_fall_all_block")));
        this.breakModeChopperEnchantmentTag.put(BreakMode.FALL_BLOCK, (TagKey<Enchantment>)TagKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)FallingTreeUtils.id("chopper_fall_block")));
        this.breakModeChopperEnchantmentTag.put(BreakMode.FALL_ITEM, (TagKey<Enchantment>)TagKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)FallingTreeUtils.id("chopper_fall_item")));
        this.breakModeChopperEnchantmentTag.put(BreakMode.INSTANTANEOUS, (TagKey<Enchantment>)TagKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)FallingTreeUtils.id("chopper_instantaneous")));
        this.breakModeChopperEnchantmentTag.put(BreakMode.SHIFT_DOWN, (TagKey<Enchantment>)TagKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)FallingTreeUtils.id("chopper_shift_down")));
        this.breakEvents = new BoundedList<BlockEvent.BreakEvent>(50);
    }

    @Override
    @NotNull
    public IComponent translate(@NotNull String key, Object ... objects) {
        Object[] vars = Arrays.stream(objects).map(o -> {
            if (o instanceof IComponent) {
                IComponent component = (IComponent)o;
                return component.getRaw();
            }
            return o;
        }).toArray();
        return new ComponentWrapper(Component.translatable((String)key, (Object[])vars));
    }

    @Override
    @NotNull
    public ServerPacketHandler getServerPacketHandler() {
        return this.packetHandler;
    }

    @Override
    @NotNull
    public Stream<IBlock> getBlock(@NotNull String name) {
        try {
            boolean isTag = name.startsWith("#");
            if (isTag) {
                name = name.substring(1);
            }
            ResourceLocation resourceLocation = FallingTreeUtils.idExternal(name);
            if (isTag) {
                TagKey tag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)resourceLocation);
                return this.getRegistryTagContent((Registry)BuiltInRegistries.BLOCK, (TagKey)tag).map(BlockWrapper::new);
            }
            return this.getRegistryElement((Registry)BuiltInRegistries.BLOCK, resourceLocation).stream().map(BlockWrapper::new);
        }
        catch (Exception e) {
            return Stream.empty();
        }
    }

    @Override
    @NotNull
    public Stream<IItem> getItem(@NotNull String name) {
        try {
            boolean isTag = name.startsWith("#");
            if (isTag) {
                name = name.substring(1);
            }
            ResourceLocation resourceLocation = FallingTreeUtils.idExternal(name);
            if (isTag) {
                TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)resourceLocation);
                return this.getRegistryTagContent((Registry)BuiltInRegistries.ITEM, (TagKey)tag).map(ItemWrapper::new);
            }
            return this.getRegistryElement((Registry)BuiltInRegistries.ITEM, resourceLocation).stream().map(ItemWrapper::new);
        }
        catch (Exception e) {
            return Stream.empty();
        }
    }

    @Override
    public boolean isLeafBlock(@NotNull IBlock block) {
        return this.isLeafBlockCache.computeIfAbsent(block, Key -> {
            boolean isAllowedBlock;
            boolean bl = isAllowedBlock = this.registryTagContains((Registry)BuiltInRegistries.BLOCK, (TagKey)BlockTags.LEAVES, (Object)((Block)block.getRaw())) || this.getConfiguration().getTrees().getAllowedLeaveBlocks(this).stream().anyMatch(leaf -> leaf.equals(block));
            if (isAllowedBlock) {
                boolean isDeniedBlock = this.getConfiguration().getTrees().getDeniedLeaveBlocks(this).stream().anyMatch(leaf -> leaf.equals(block));
                return !isDeniedBlock;
            }
            return false;
        });
    }

    @Override
    public boolean isLogBlock(@NotNull IBlock block) {
        return this.isLogBlockCache.computeIfAbsent(block, Key -> {
            boolean isAllowedBlock;
            boolean bl = isAllowedBlock = this.getConfiguration().getTrees().getDefaultLogsBlocks(this).stream().anyMatch(log -> log.equals(block)) || this.getConfiguration().getTrees().getAllowedLogBlocks(this).stream().anyMatch(log -> log.equals(block));
            if (isAllowedBlock) {
                boolean isDeniedBlock = this.getConfiguration().getTrees().getDeniedLogBlocks(this).stream().anyMatch(log -> log.equals(block));
                return !isDeniedBlock;
            }
            return false;
        });
    }

    @Override
    @NotNull
    public Set<IBlock> getAllNonStrippedLogsBlocks() {
        return this.getRegistryTagContent((Registry)BuiltInRegistries.BLOCK, (TagKey)BlockTags.LOGS).filter(block -> Optional.of(BuiltInRegistries.BLOCK.getKey(block)).map(ResourceLocation::getPath).map(name -> name.startsWith("stripped")).orElse(false) == false).map(BlockWrapper::new).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public DirectionCompat asDirectionCompat(@NotNull Direction dir) {
        return DirectionCompat.valueOf(dir.name());
    }

    @Override
    @NotNull
    public Direction asDirection(@NotNull DirectionCompat dir) {
        return Direction.valueOf((String)dir.name());
    }

    @Override
    public boolean isNetherWartOrShroomlight(@NotNull IBlock block) {
        return this.isWartBlockCache.computeIfAbsent(block, Key -> this.registryTagContains((Registry)BuiltInRegistries.BLOCK, (TagKey)BlockTags.WART_BLOCKS, (Object)((Block)block.getRaw())) || Blocks.SHROOMLIGHT.equals(block.getRaw()));
    }

    @Override
    public boolean isMangroveRoots(@NotNull IBlock block) {
        return Blocks.MANGROVE_ROOTS.equals(block.getRaw());
    }

    @Override
    public boolean checkCanBreakBlock(@NotNull ILevel level, @NotNull IBlockPos blockPos, @NotNull IBlockState blockState, @NotNull IPlayer player) {
        FallingTreeBlockBreakEvent event = new FallingTreeBlockBreakEvent((Level)level.getRaw(), (BlockPos)blockPos.getRaw(), (BlockState)blockState.getRaw(), (Player)player.getRaw());
        this.breakEvents.add(event);
        return !((FallingTreeBlockBreakEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled();
    }

    @Override
    public boolean isOwnEvent(@NotNull IBlockBreakEvent event) {
        boolean result;
        boolean bl = result = this.breakEvents.contains((BlockEvent.BreakEvent)event.getRaw()) || event instanceof FallingTreeBlockBreakEvent;
        if (result) {
            this.breakEvents.remove((BlockEvent.BreakEvent)event.getRaw());
        }
        return result;
    }

    @Override
    @NotNull
    public IItemStack getEmptyItemStack() {
        return new ItemStackWrapper(ItemStack.EMPTY);
    }

    @Override
    public void onConfigUpdate() {
        this.isLogBlockCache.clear();
        this.isLeafBlockCache.clear();
        this.isWartBlockCache.clear();
    }

    @NotNull
    private <T> Optional<T> getRegistryElement(Registry<T> registryKey, ResourceLocation identifier) {
        return registryKey.get(identifier).map(Holder::value);
    }

    @NotNull
    private <T> Stream<T> getRegistryTagContent(@NotNull Registry<T> registry, @NotNull TagKey<T> tag) {
        return registry.get(tag).stream().flatMap(a -> a.stream().map(Holder::value));
    }

    private <T> boolean registryTagContains(@NotNull Registry<T> registry, @NotNull TagKey<T> tag, @NotNull T element) {
        return this.getRegistryTagContent(registry, tag).anyMatch(element::equals);
    }

    public void registerForge(@NotNull IEventBus eventBus) {
        this.getServerPacketHandler().registerServer();
        eventBus.register((Object)new BlockBreakListener(this));
        eventBus.register((Object)new LeafBreakingListener(this));
        eventBus.register((Object)new PlayerLeaveListener(this));
        eventBus.register((Object)new ServerCommandRegistrationListener(this));
        this.modEventBus.register((Object)this.packetHandler);
    }

    @Override
    @Generated
    public LeafBreakingHandler getLeafBreakingHandler() {
        return this.leafBreakingHandler;
    }

    @Generated
    public TagKey<Enchantment> getChopperEnchantmentTag() {
        return this.chopperEnchantmentTag;
    }

    @Generated
    public Map<BreakMode, TagKey<Enchantment>> getBreakModeChopperEnchantmentTag() {
        return this.breakModeChopperEnchantmentTag;
    }
}

