/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.common.tree.builder;

import fr.rakambda.fallingtree.common.FallingTreeCommon;
import fr.rakambda.fallingtree.common.config.enums.AdjacentStopMode;
import fr.rakambda.fallingtree.common.config.enums.DetectionMode;
import fr.rakambda.fallingtree.common.tree.Tree;
import fr.rakambda.fallingtree.common.tree.TreePartType;
import fr.rakambda.fallingtree.common.tree.builder.AbortSearchException;
import fr.rakambda.fallingtree.common.tree.builder.AdjacentAbortSearchException;
import fr.rakambda.fallingtree.common.tree.builder.ToAnalyzePos;
import fr.rakambda.fallingtree.common.tree.builder.TreeTooBigException;
import fr.rakambda.fallingtree.common.tree.builder.position.AbovePositionFetcher;
import fr.rakambda.fallingtree.common.tree.builder.position.AboveYFetcher;
import fr.rakambda.fallingtree.common.tree.builder.position.BasicPositionFetcher;
import fr.rakambda.fallingtree.common.tree.builder.position.IPositionFetcher;
import fr.rakambda.fallingtree.common.wrapper.DirectionCompat;
import fr.rakambda.fallingtree.common.wrapper.IBlock;
import fr.rakambda.fallingtree.common.wrapper.IBlockEntity;
import fr.rakambda.fallingtree.common.wrapper.IBlockPos;
import fr.rakambda.fallingtree.common.wrapper.IBlockState;
import fr.rakambda.fallingtree.common.wrapper.ILevel;
import fr.rakambda.fallingtree.common.wrapper.IPlayer;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeBuilder {
    @Generated
    private static final Logger log = LogManager.getLogger(TreeBuilder.class);
    private static final EnumSet<DirectionCompat> ALL_DIRECTIONS = EnumSet.allOf(DirectionCompat.class);
    private final FallingTreeCommon<?> mod;

    @NotNull
    public Optional<Tree> getTree(@NotNull IPlayer player, @NotNull ILevel level, @NotNull IBlockPos originPos, @NotNull IBlockState originState, @Nullable IBlockEntity originEntity) throws TreeTooBigException {
        IBlock originBlock = originState.getBlock();
        if (!this.mod.isLogBlock(originBlock)) {
            return Optional.empty();
        }
        int maxScanSize = this.mod.getConfiguration().getTrees().getMaxScanSize();
        PriorityQueue<ToAnalyzePos> toAnalyzePos = new PriorityQueue<ToAnalyzePos>();
        HashSet<ToAnalyzePos> analyzedPos = new HashSet<ToAnalyzePos>();
        Tree tree = new Tree(level, originPos);
        toAnalyzePos.add(new ToAnalyzePos(this.getFirstPositionFetcher(), originPos, originBlock, originPos, originBlock, originState, originEntity, TreePartType.LOG_START, 0, 0));
        Predicate<IBlockPos> boundingBoxSearch = this.getBoundingBoxSearch(originPos);
        Predicate<IBlock> adjacentPredicate = this.getAdjacentPredicate();
        try {
            TreeBuilder.checkAdjacent(adjacentPredicate, level, originPos);
            while (!toAnalyzePos.isEmpty()) {
                ToAnalyzePos analyzingPos = (ToAnalyzePos)toAnalyzePos.remove();
                if (analyzingPos.toTreePart().treePartType().isIncludeInTree()) {
                    tree.addPart(analyzingPos.toTreePart());
                }
                analyzedPos.add(analyzingPos);
                if (tree.getSize() > maxScanSize) {
                    log.info("Tree at {} reached max scan size of {}", (Object)tree.getHitPos(), (Object)maxScanSize);
                    throw new TreeTooBigException();
                }
                if (analyzingPos.treePartType().isEdge() && analyzingPos.sequenceSinceLastLog() >= this.mod.getConfiguration().getTrees().getMaxLeafDistanceFromLog()) continue;
                Collection<ToAnalyzePos> potentialPositions = analyzingPos.positionFetcher().getPositions(level, originPos, analyzingPos);
                Collection<ToAnalyzePos> nextPositions = this.filterPotentialPos(boundingBoxSearch, adjacentPredicate, level, originPos, originBlock, analyzingPos, potentialPositions, analyzedPos);
                nextPositions.removeAll(analyzedPos);
                nextPositions.removeAll(toAnalyzePos);
                toAnalyzePos.addAll(nextPositions);
            }
            TreeBuilder.postProcess(tree);
        }
        catch (AbortSearchException e) {
            log.info("Didn't cut tree at {}, reason: {}", (Object)originPos, (Object)e.getMessage());
            this.mod.notifyPlayer(player, this.mod.translate("chat.fallingtree.search_aborted", new Object[0]).append(e.getComponent()));
            return Optional.empty();
        }
        if (this.mod.getConfiguration().getTrees().getBreakMode().isCheckLeavesAround()) {
            int aroundRequired = this.mod.getConfiguration().getTrees().getMinimumLeavesAroundRequired();
            if (tree.getTopMostLog().map(topLog -> this.getLeavesAround(level, (IBlockPos)topLog) < (long)aroundRequired).orElse(true).booleanValue()) {
                log.debug("Tree at {} doesn't have enough leaves around top most log", (Object)originPos);
                return Optional.empty();
            }
        }
        return Optional.of(tree);
    }

    private static void postProcess(@NotNull Tree tree) {
        tree.getTopMostLog().ifPresent(topMostLog -> tree.removePartsHigherThan(topMostLog.getY() + 1, TreePartType.NETHER_WART));
    }

    @NotNull
    private Predicate<IBlock> getAdjacentPredicate() {
        Collection<IBlock> allowedList = this.mod.getConfiguration().getTrees().getAllowedAdjacentBlockBlocks(this.mod);
        Collection<IBlock> base = this.mod.getConfiguration().getTrees().getAllAllowedAdjacentBlockBlocks(this.mod);
        if (allowedList.isEmpty()) {
            return block -> true;
        }
        return switch (this.mod.getConfiguration().getTrees().getAdjacentStopMode()) {
            default -> throw new MatchException(null, null);
            case AdjacentStopMode.STOP_ALL -> block -> {
                boolean isAllowed;
                boolean bl = isAllowed = allowedList.contains(block) || base.contains(block);
                if (!isAllowed) {
                    throw new AdjacentAbortSearchException((IBlock)block, this.mod);
                }
                return true;
            };
            case AdjacentStopMode.STOP_BRANCH -> block -> {
                boolean isAllowed;
                boolean bl = isAllowed = allowedList.contains(block) || base.contains(block);
                if (!isAllowed) {
                    log.info("Found block {} that isn't allowed in the adjacent blocks, branch will be ignored further", block);
                    return false;
                }
                return true;
            };
        };
    }

    @NotNull
    private Predicate<IBlockPos> getBoundingBoxSearch(@NotNull IBlockPos originPos) {
        int radius = this.mod.getConfiguration().getTrees().getSearchAreaRadius();
        if (radius < 0) {
            return pos -> true;
        }
        int minX = originPos.getX() - radius;
        int maxX = originPos.getX() + radius;
        int minZ = originPos.getZ() - radius;
        int maxZ = originPos.getZ() + radius;
        return pos -> minX <= pos.getX() && maxX >= pos.getX() && minZ <= pos.getZ() && maxZ >= pos.getZ();
    }

    @NotNull
    private IPositionFetcher getFirstPositionFetcher() {
        DetectionMode detectionMode = this.mod.getConfiguration().getTrees().getDetectionMode();
        return switch (detectionMode) {
            default -> throw new MatchException(null, null);
            case DetectionMode.ABOVE_CUT -> AbovePositionFetcher.getInstance(this.mod);
            case DetectionMode.ABOVE_Y -> AboveYFetcher.getInstance(this.mod);
            case DetectionMode.WHOLE_TREE -> BasicPositionFetcher.getInstance(this.mod);
        };
    }

    @NotNull
    private Collection<ToAnalyzePos> filterPotentialPos(@NotNull Predicate<IBlockPos> boundingBoxSearch, @NotNull Predicate<IBlock> adjacentPredicate, @NotNull ILevel level, @NotNull IBlockPos originPos, @NotNull IBlock originBlock, @NotNull ToAnalyzePos parent, @NotNull Collection<ToAnalyzePos> potentialPos, @NotNull Collection<ToAnalyzePos> analyzedPos) {
        return potentialPos.stream().filter(pos -> !analyzedPos.contains(pos)).filter(pos -> this.shouldIncludeInChain(boundingBoxSearch, originPos, originBlock, parent, (ToAnalyzePos)pos)).filter(pos -> TreeBuilder.checkAdjacent(adjacentPredicate, level, pos.checkPos())).collect(Collectors.toList());
    }

    private static boolean checkAdjacent(@NotNull Predicate<IBlock> adjacentPredicate, @NotNull ILevel level, IBlockPos pos) {
        return EnumSet.allOf(DirectionCompat.class).stream().map(pos::relative).map(level::getBlockState).map(IBlockState::getBlock).allMatch(adjacentPredicate);
    }

    private long getLeavesAround(@NotNull ILevel level, @NotNull IBlockPos blockPos) {
        return ALL_DIRECTIONS.stream().map(blockPos::relative).filter(testPos -> {
            boolean isLeaf;
            IBlockState blockState = level.getBlockState((IBlockPos)testPos);
            IBlock block = blockState.getBlock();
            boolean bl = isLeaf = this.mod.isLeafBlock(block) || this.mod.isNetherWartOrShroomlight(block) || this.mod.isLeafNeedBreakBlock(block);
            if (!isLeaf) {
                return false;
            }
            if (this.mod.getConfiguration().getTrees().isIncludePersistentLeavesInRequiredCount()) {
                return true;
            }
            return blockState.hasLeafPersistentFlag().orElse(false) == false;
        }).count();
    }

    private boolean shouldIncludeInChain(@NotNull Predicate<IBlockPos> boundingBoxSearch, @NotNull IBlockPos originPos, @NotNull IBlock originBlock, @NotNull ToAnalyzePos parent, @NotNull ToAnalyzePos check) {
        if (parent.treePartType().isEdge() && !check.treePartType().isEdge()) {
            return false;
        }
        if (parent.treePartType().isLog() && this.isSameTree(originBlock, check) && boundingBoxSearch.test(check.checkPos())) {
            return true;
        }
        if (this.mod.getConfiguration().getTrees().isBreakNetherTreeWarts() && check.treePartType() == TreePartType.NETHER_WART) {
            IBlockPos checkBlockPos = check.checkPos();
            int dx = Math.abs(originPos.getX() - checkBlockPos.getX());
            int dz = Math.abs(originPos.getZ() - checkBlockPos.getZ());
            return dx <= 4 && dz <= 4;
        }
        if (this.mod.getConfiguration().getTrees().isBreakMangroveRoots() && check.treePartType() == TreePartType.MANGROVE_ROOTS) {
            return true;
        }
        return check.treePartType().isEdge();
    }

    private boolean isSameTree(@NotNull IBlock parentLogBlock, @NotNull ToAnalyzePos check) {
        if (this.mod.getConfiguration().getTrees().isAllowMixedLogs()) {
            return check.treePartType().isLog();
        }
        return check.checkBlock().equals(parentLogBlock);
    }

    @Generated
    public TreeBuilder(FallingTreeCommon<?> mod) {
        this.mod = mod;
    }
}

