/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.trades.type;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import com.mrcrayfish.goblintraders.trades.GoblinMerchantOffer;
import com.mrcrayfish.goblintraders.trades.TradeCost;
import com.mrcrayfish.goblintraders.trades.type.BaseTrade;
import com.mrcrayfish.goblintraders.util.Utils;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1814;
import net.minecraft.class_1914;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8824;
import net.minecraft.class_9306;
import net.minecraft.class_9334;
import net.minecraft.class_9428;

public class TreasureMapTrade
implements BaseTrade {
    public static final class_2960 ID = Utils.resource("treasure_map");
    public static final Codec<class_6862<class_3195>> STRUCTURE_CODEC = class_2960.field_25139.xmap(id -> class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)id), class_6862::comp_327);
    public static final MapCodec<TreasureMapTrade> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)STRUCTURE_CODEC.fieldOf("structure").forGetter(trade -> trade.structure), (App)class_7923.field_50078.method_40294().fieldOf("decoration").forGetter(trade -> trade.mapDecoration), (App)class_8824.field_46597.fieldOf("name").forGetter(trade -> trade.name), (App)TradeCost.CODEC.fieldOf("payment_item").forGetter(trade -> trade.primaryPayment), (App)TradeCost.CODEC.lenientOptionalFieldOf("secondary_payment_item").forGetter(trade -> trade.secondaryPayment), (App)Codec.FLOAT.optionalFieldOf("price_multiplier", (Object)Float.valueOf(0.0f)).forGetter(trade -> Float.valueOf(trade.priceMultiplier)), (App)Codec.INT.optionalFieldOf("max_trades", (Object)12).forGetter(trade -> trade.maxTrades), (App)Codec.INT.optionalFieldOf("experience", (Object)0).forGetter(trade -> trade.experience)).apply((Applicative)builder, TreasureMapTrade::new));
    private final class_6862<class_3195> structure;
    private final class_6880<class_9428> mapDecoration;
    private final class_2561 name;
    private final TradeCost primaryPayment;
    private final Optional<TradeCost> secondaryPayment;
    private final float priceMultiplier;
    private final int maxTrades;
    private final int experience;

    public TreasureMapTrade(class_6862<class_3195> structure, class_6880<class_9428> mapDecoration, class_2561 name, TradeCost primaryPayment, Optional<TradeCost> secondaryPayment, float priceMultiplier, int maxTrades, int experience) {
        this.structure = structure;
        this.mapDecoration = mapDecoration;
        this.name = name;
        this.primaryPayment = primaryPayment;
        this.secondaryPayment = secondaryPayment;
        this.priceMultiplier = priceMultiplier;
        this.maxTrades = maxTrades;
        this.experience = experience;
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public class_1914 createVanillaOffer(AbstractGoblinEntity goblin, class_5819 random) {
        class_3218 level;
        class_2338 pos;
        class_1937 class_19372 = goblin.method_37908();
        if (class_19372 instanceof class_3218 && (pos = (level = (class_3218)class_19372).method_8487(this.structure, goblin.method_24515(), 100, true)) != null) {
            class_1799 map = class_1806.method_8005((class_3218)level, (int)pos.method_10263(), (int)pos.method_10260(), (byte)2, (boolean)true, (boolean)true);
            class_1806.method_8002((class_3218)level, (class_1799)map);
            class_22.method_110((class_1799)map, (class_2338)pos, (String)"+", this.mapDecoration);
            map.method_57379(class_9334.field_50239, (Object)this.name);
            map.method_57379(class_9334.field_49641, (Object)true);
            map.method_57379(class_9334.field_50073, (Object)class_1814.field_8903);
            class_9306 primaryCost = this.primaryPayment.createVanillaCost(random);
            Optional<class_9306> secondaryCost = this.secondaryPayment.map(cost -> cost.createVanillaCost(random));
            return new GoblinMerchantOffer(primaryCost, secondaryCost, map, this.maxTrades, 0, this.experience);
        }
        return null;
    }

    public static class Builder {
        private class_6862<class_3195> structure;
        private class_6880<class_9428> mapDecoration;
        private class_2561 name;
        private TradeCost paymentStack;
        private TradeCost secondaryPaymentStack;
        private float priceMultiplier = 0.0f;
        private int maxTrades = 12;
        private int experience = 10;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public TreasureMapTrade build() {
            Preconditions.checkNotNull(this.structure, (Object)"No structure was set");
            Preconditions.checkNotNull(this.mapDecoration, (Object)"No map decoration was set");
            Preconditions.checkNotNull((Object)this.paymentStack, (Object)"No payment was set");
            Preconditions.checkNotNull((Object)this.name, (Object)"No name was set");
            return new TreasureMapTrade(this.structure, this.mapDecoration, this.name, this.paymentStack, Optional.ofNullable(this.secondaryPaymentStack), this.priceMultiplier, this.maxTrades, this.experience);
        }

        public Builder setStructure(class_6862<class_3195> structure) {
            this.structure = structure;
            return this;
        }

        public Builder setMapDecoration(class_6880<class_9428> mapDecoration) {
            this.mapDecoration = mapDecoration;
            return this;
        }

        public Builder setName(class_2561 name) {
            this.name = name;
            return this;
        }

        public Builder setPaymentStack(TradeCost paymentStack) {
            this.paymentStack = paymentStack;
            return this;
        }

        public Builder setSecondaryPaymentStack(TradeCost secondaryPaymentStack) {
            this.secondaryPaymentStack = secondaryPaymentStack;
            return this;
        }

        public Builder setPriceMultiplier(float priceMultiplier) {
            this.priceMultiplier = priceMultiplier;
            return this;
        }

        public Builder setMaxTrades(int maxTrades) {
            this.maxTrades = maxTrades;
            return this;
        }

        public Builder setExperience(int experience) {
            this.experience = experience;
            return this;
        }
    }
}

