/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.spawner;

import com.mrcrayfish.goblintraders.Config;
import com.mrcrayfish.goblintraders.core.ModEntities;
import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import com.mrcrayfish.goblintraders.spawner.IGoblinData;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_10741;
import net.minecraft.class_1299;
import net.minecraft.class_1317;
import net.minecraft.class_18;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_1972;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class GoblinTraderSpawner
extends class_18 {
    private static final SpawnProperties GOBLIN_TRADER_PROPERTIES = new SpawnProperties(() -> ModEntities.GOBLIN_TRADER.get(), () -> Config.ENTITIES.goblinTrader);
    private static final SpawnProperties VEIN_GOBLIN_TRADER_PROPERTIES = new SpawnProperties(() -> ModEntities.VEIN_GOBLIN_TRADER.get(), () -> Config.ENTITIES.veinGoblinTrader);
    private static final class_10741<GoblinTraderSpawner> TYPE_GOBLIN_TRADER = new class_10741("goblintraders_goblin_trader_spawner", context -> GoblinTraderSpawner.createSpawner(context.method_67417(), GOBLIN_TRADER_PROPERTIES), context -> class_2487.field_25128.xmap(tag -> GoblinTraderSpawner.createSpawner(context.method_67417(), GOBLIN_TRADER_PROPERTIES).load((class_2487)tag), spawner -> Objects.requireNonNullElseGet(spawner.save((class_7225.class_7874)spawner.level.method_30349()), class_2487::new)), null);
    private static final class_10741<GoblinTraderSpawner> TYPE_VEIN_GOBLIN_TRADER = new class_10741("goblintraders_vein_goblin_trader_spawner", context -> GoblinTraderSpawner.createSpawner(context.method_67417(), VEIN_GOBLIN_TRADER_PROPERTIES), context -> class_2487.field_25128.xmap(tag -> GoblinTraderSpawner.createSpawner(context.method_67417(), VEIN_GOBLIN_TRADER_PROPERTIES).load((class_2487)tag), spawner -> Objects.requireNonNullElseGet(spawner.save((class_7225.class_7874)spawner.level.method_30349()), class_2487::new)), null);
    private static final int SAFE_POSITION_ATTEMPTS = 50;
    private static final int MIN_SPAWN_DISTANCE = 5;
    private static final int GROUND_SEARCH_DISTANCE = 5;
    private static final int SAVE_INTERVAL = 200;
    private final class_3218 level;
    private final class_1299<? extends AbstractGoblinEntity> type;
    private final IGoblinData data;
    private int runDelay;
    private int spawnChance;

    public <T extends AbstractGoblinEntity> GoblinTraderSpawner(class_3218 level, class_1299<T> type, IGoblinData data) {
        this.level = level;
        this.type = type;
        this.data = data;
        this.runDelay = data.getSpawnDelay();
        this.spawnChance = data.getSpawnChance();
    }

    public void serverTick() {
        if (!this.level.method_64395().method_8355(class_1928.field_21832)) {
            return;
        }
        --this.runDelay;
        if (this.runDelay % 200 == 0) {
            this.method_80();
        }
        if (this.runDelay > 0) {
            return;
        }
        this.runDelay = this.data.getSpawnInterval();
        if (!this.level.method_64395().method_8355(class_1928.field_19390)) {
            return;
        }
        double randomChance = this.level.method_8409().method_43058();
        if ((double)this.spawnChance / 100.0 < randomChance) {
            this.spawnChance = Math.min(this.spawnChance + this.data.getSpawnChance(), 100);
            this.method_80();
            return;
        }
        if (this.spawnGoblin()) {
            this.runDelay = this.data.getSpawnDelay();
            this.spawnChance = this.data.getSpawnChance();
            this.method_80();
        }
    }

    private boolean spawnGoblin() {
        class_3222 player = this.level.method_18779();
        if (player == null) {
            return false;
        }
        class_2338 pos = this.createSpawnPosition(player.method_24515(), 16);
        if (pos == null) {
            return false;
        }
        class_6880 biome = this.level.method_23753(pos);
        if (biome.method_40225(class_1972.field_9473) || biome.method_40225(class_1972.field_37543)) {
            return false;
        }
        if (pos.method_10264() < this.data.getMinSpawnYLevel() || pos.method_10264() >= this.data.getMaxSpawnYLevel()) {
            return false;
        }
        AbstractGoblinEntity goblin = (AbstractGoblinEntity)this.type.method_47821(this.level, pos, class_3730.field_16467);
        if (goblin == null) {
            return false;
        }
        this.runDelay = this.data.getSpawnDelay();
        goblin.setDespawnDelay(this.data.getDespawnDelay());
        goblin.method_18408(pos, 16);
        this.method_80();
        return true;
    }

    @Nullable
    private class_2338 createSpawnPosition(class_2338 center, int range) {
        for (int i = 0; i < 50; ++i) {
            int posZ;
            int posY;
            int posX = center.method_10263() + this.createRandomSpawnableDistance(range);
            class_2338 pos = this.findGround(new class_2338(posX, posY = center.method_10264() + this.createRandomSpawnableDistance(range), posZ = center.method_10260() + this.createRandomSpawnableDistance(range)));
            if (pos == null || pos.method_19771((class_2382)center, 5.0) || !class_1317.method_56558(this.type, (class_4538)this.level, (class_2338)pos)) continue;
            return pos;
        }
        return null;
    }

    private int createRandomSpawnableDistance(int maxSpawnDistance) {
        class_5819 random = this.level.method_8409();
        int direction = random.method_43048(2) == 0 ? 1 : -1;
        int spawnableRange = Math.max(maxSpawnDistance - 5, 0);
        return (5 + random.method_39332(0, spawnableRange)) * direction;
    }

    @Nullable
    private class_2338 findGround(class_2338 pos) {
        int i;
        boolean colliding = this.canCollide(pos);
        class_2338 testPos = pos.method_10074();
        for (i = 0; i < 5 && class_1937.method_25953((class_2338)testPos); ++i) {
            if (!this.canCollide(testPos)) {
                colliding = false;
                testPos = testPos.method_10074();
                continue;
            }
            if (colliding) continue;
            return testPos.method_10084();
        }
        colliding = this.canCollide(pos);
        testPos = pos.method_10084();
        for (i = 0; i < 5 && class_1937.method_25953((class_2338)testPos); ++i) {
            if (this.canCollide(testPos)) {
                colliding = true;
                testPos = testPos.method_10084();
                continue;
            }
            if (!colliding) continue;
            return testPos;
        }
        return null;
    }

    private boolean canCollide(class_2338 pos) {
        return !this.level.method_8320(pos).method_26220((class_1922)this.level, pos).method_1110();
    }

    public GoblinTraderSpawner load(class_2487 tag) {
        this.runDelay = tag.method_10550("RunDelay").orElse(this.data.getSpawnDelay());
        this.spawnChance = tag.method_10550("SpawnChance").orElse(this.data.getSpawnChance());
        return this;
    }

    public class_2487 save(class_7225.class_7874 provider) {
        class_2487 tag = new class_2487();
        tag.method_10569("RunDelay", this.runDelay);
        tag.method_10569("SpawnChance", this.spawnChance);
        return tag;
    }

    public static Optional<GoblinTraderSpawner> getGoblinTraderSpawner(MinecraftServer server) {
        return GoblinTraderSpawner.getTraderSpawner(server, (class_5321<class_1937>)class_1937.field_25179, TYPE_GOBLIN_TRADER);
    }

    public static Optional<GoblinTraderSpawner> getVeinGoblinTraderSpawner(MinecraftServer server) {
        return GoblinTraderSpawner.getTraderSpawner(server, (class_5321<class_1937>)class_1937.field_25180, TYPE_VEIN_GOBLIN_TRADER);
    }

    private static Optional<GoblinTraderSpawner> getTraderSpawner(MinecraftServer server, class_5321<class_1937> key, class_10741<GoblinTraderSpawner> type) {
        class_3218 level = server.method_3847(key);
        if (level != null) {
            return Optional.of((GoblinTraderSpawner)level.method_17983().method_17924(type));
        }
        return Optional.empty();
    }

    private static GoblinTraderSpawner createSpawner(class_3218 level, SpawnProperties properties) {
        return new GoblinTraderSpawner(level, properties.type.get(), properties.goblinData.get());
    }

    public record SpawnProperties(Supplier<class_1299<? extends AbstractGoblinEntity>> type, Supplier<IGoblinData> goblinData) {
    }
}

