/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.entity;

import com.mojang.serialization.DynamicOps;
import com.mrcrayfish.goblintraders.Config;
import com.mrcrayfish.goblintraders.core.ModSounds;
import com.mrcrayfish.goblintraders.entity.GoblinRotationControl;
import com.mrcrayfish.goblintraders.entity.TraderCreatureEntity;
import com.mrcrayfish.goblintraders.entity.ai.goal.AttackRevengeTargetGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.EatFavouriteFoodGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.FindFavouriteFoodGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.FirePanicGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.FollowPotentialCustomerGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.GoblinTemptGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.LookAtCustomerGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.SitAndLookGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.TradeWithPlayerGoal;
import com.mrcrayfish.goblintraders.inventory.GoblinMerchantMenu;
import com.mrcrayfish.goblintraders.trades.GoblinOffers;
import com.mrcrayfish.goblintraders.trades.type.BaseTrade;
import com.mrcrayfish.goblintraders.util.Utils;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1330;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1358;
import net.minecraft.class_1361;
import net.minecraft.class_1370;
import net.minecraft.class_1394;
import net.minecraft.class_1588;
import net.minecraft.class_1655;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_4135;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5454;
import net.minecraft.class_747;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGoblinEntity
extends TraderCreatureEntity
implements class_1655 {
    public static final class_2940<Boolean> STUNNED = class_2945.method_12791(AbstractGoblinEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Float> STUN_ROTATION = class_2945.method_12791(AbstractGoblinEntity.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Boolean> SITTING = class_2945.method_12791(AbstractGoblinEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> CURIOUS = class_2945.method_12791(AbstractGoblinEntity.class, (class_2941)class_2943.field_13323);
    @Nullable
    private class_1657 customer;
    @Nullable
    private class_1916 offers;
    private final Set<UUID> tradedCustomers = new HashSet<UUID>();
    private int stunDelay;
    private int despawnDelay = -1;
    private int fallCounter;
    private int restockDelay;
    private float headTilt;
    private float headTiltO;
    private float armAngle;
    private float armAngleO;
    private int curiousTime;

    protected AbstractGoblinEntity(class_1299<? extends TraderCreatureEntity> type, class_1937 level) {
        super(type, level);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new FirePanicGoal(this, 1.3));
        this.field_6201.method_6277(2, (class_1352)new TradeWithPlayerGoal(this));
        this.field_6201.method_6277(3, (class_1352)new LookAtCustomerGoal(this));
        this.field_6201.method_6277(4, (class_1352)new AttackRevengeTargetGoal(this));
        this.field_6201.method_6277(5, (class_1352)new EatFavouriteFoodGoal(this));
        this.field_6201.method_6277(6, (class_1352)new FindFavouriteFoodGoal(this));
        this.field_6201.method_6277(7, (class_1352)new GoblinTemptGoal(this, 1.0, stack -> stack.method_31574(this.getFavouriteFood().method_7909()), false));
        this.field_6201.method_6277(8, (class_1352)new FollowPotentialCustomerGoal(this));
        this.field_6201.method_6277(9, (class_1352)new SitAndLookGoal(this));
        this.field_6201.method_6277(10, (class_1352)new class_1370((class_1314)this, 1.0));
        this.field_6201.method_6277(11, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(12, (class_1352)new class_1358((class_1308)this, class_1657.class, 4.0f, 1.0f));
        this.field_6201.method_6277(13, (class_1352)new class_1361((class_1308)this, class_1308.class, 8.0f));
    }

    protected void method_20417() {
        super.method_20417();
        if (this.isStunned()) {
            this.field_6201.method_6276(class_1352.class_4134.field_18405, true);
            this.field_6201.method_6276(class_1352.class_4134.field_18407, true);
            this.field_6201.method_6276(class_1352.class_4134.field_18406, true);
        }
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(STUNNED, (Object)false);
        builder.method_56912(STUN_ROTATION, (Object)Float.valueOf(0.0f));
        builder.method_56912(SITTING, (Object)false);
        builder.method_56912(CURIOUS, (Object)false);
    }

    public abstract class_2960 getTexture();

    public int getFallCounter() {
        return this.fallCounter;
    }

    public void method_5670() {
        this.headTiltO = this.headTilt;
        this.armAngleO = this.armAngle;
        if (this.despawnDelay > 0) {
            --this.despawnDelay;
        }
        super.method_5670();
        this.method_6119();
        if (this.stunDelay > 0) {
            --this.stunDelay;
            if (this.stunDelay == 0) {
                this.field_6011.method_12778(STUNNED, (Object)false);
                this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), (class_3414)ModSounds.ENTITY_GOBLIN_TRADER_ANNOYED_GRUNT.get(), class_3419.field_15254, 1.0f, 0.9f + this.method_59922().method_43057() * 0.2f);
            }
        }
        if (((Boolean)this.field_6011.method_12789(STUNNED)).booleanValue()) {
            if (this.fallCounter < 10) {
                ++this.fallCounter;
            }
        } else {
            this.fallCounter = 0;
        }
        if (!this.method_37908().method_8608() && this.getMaxRestockDelay() != -1 && ++this.restockDelay >= this.getMaxRestockDelay()) {
            this.method_8264().forEach(class_1914::method_19275);
            this.restockDelay = 0;
            this.resendOffers();
        }
        if (!this.method_37908().method_8608() && --this.curiousTime <= 0) {
            this.setCurious(false);
        }
        float targetTilt = this.isCurious() ? 20.0f : 0.0f;
        this.headTilt = class_3532.method_16439((float)0.35f, (float)this.headTilt, (float)targetTilt);
        float targetAngle = this.getTargetArmAngle();
        this.armAngle = class_3532.method_16439((float)0.35f, (float)this.armAngle, (float)targetAngle);
    }

    private void resendOffers() {
        class_1916 offers = this.method_8264();
        class_1657 player = this.method_8257();
        if (player != null && !offers.isEmpty()) {
            player.method_17354(player.field_7512.field_7763, offers, 0, 0, false, this.method_20708());
        }
    }

    public void method_8259(@Nullable class_1657 player) {
        this.customer = player;
    }

    @Nullable
    public class_1657 method_8257() {
        return this.customer;
    }

    public boolean hasCustomer() {
        return this.customer != null;
    }

    public class_1916 method_8264() {
        if (this.offers == null) {
            this.offers = new GoblinOffers();
            this.populateTradeData();
        }
        return this.offers;
    }

    protected abstract void populateTradeData();

    protected void addTrades(class_1916 offers, @Nullable List<BaseTrade> trades, int max, boolean shuffle) {
        if (trades == null) {
            return;
        }
        List randomIndexes = IntStream.range(0, trades.size()).boxed().collect(Collectors.toList());
        if (shuffle) {
            Collections.shuffle(randomIndexes);
        }
        randomIndexes = randomIndexes.subList(0, Math.min(trades.size(), max));
        for (Integer index : randomIndexes) {
            BaseTrade trade = trades.get(index);
            class_1914 offer = trade.createVanillaOffer(this, this.method_59922());
            if (offer == null) continue;
            offers.add((Object)offer);
        }
    }

    public void method_17449(class_1657 player, class_2561 title, int level) {
        class_1916 offers;
        OptionalInt id = player.method_17355((class_3908)new class_747((windowId, playerInventory, player1) -> new GoblinMerchantMenu(windowId, playerInventory, this), title));
        if (id.isPresent() && !(offers = this.method_8264()).isEmpty()) {
            player.method_17354(id.getAsInt(), offers, level, 0, false, this.method_20708());
        }
    }

    public boolean method_20708() {
        return true;
    }

    public void method_8261(@Nullable class_1916 offers) {
    }

    public void method_8262(class_1914 offer) {
        class_1937 class_19372;
        offer.method_8244();
        if (this.customer != null) {
            this.tradedCustomers.add(this.customer.method_5667());
        }
        if ((class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_1303.method_31493((class_3218)serverLevel, (class_243)this.method_30950(1.0f), (int)offer.method_19279());
        }
    }

    public void method_8258(class_1799 stack) {
    }

    public boolean method_38069() {
        return this.method_37908().method_8608();
    }

    public int method_19269() {
        return 0;
    }

    public void method_19271(int xpIn) {
    }

    public boolean method_19270() {
        return false;
    }

    public class_3414 method_18010() {
        return class_3417.field_14815;
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 heldItem = player.method_5998(hand);
        if (heldItem.method_7909() == class_1802.field_8448) {
            class_1269 result = heldItem.method_7920(player, (class_1309)this, hand);
            if (result.method_23665()) {
                this.method_35055();
            }
            return result;
        }
        if (this.getFavouriteFood().method_31574(heldItem.method_7909())) {
            if (this.method_6118(class_1304.field_6173).method_7960()) {
                this.method_5673(class_1304.field_6173, heldItem.method_46651(1));
                heldItem.method_7934(1);
                return class_1269.field_5812;
            }
        } else if (!(!this.method_5805() || this.hasCustomer() || this.method_6109() || !this.method_5753() && this.method_5809() || this.isStunned())) {
            if (this.method_8264().isEmpty()) {
                return class_1269.field_5811;
            }
            if (!(this.method_38069() || this.method_6065() != null && this.method_6065() == player)) {
                this.method_8259(player);
                this.method_17449(player, Objects.requireNonNull(this.method_5476()), 1);
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    protected void spawnFoodParticles(class_1799 stack, int count) {
        for (int i = 0; i < count; ++i) {
            class_243 frontPosition = class_243.method_1030((float)0.0f, (float)this.field_6283).method_1021(0.25);
            frontPosition = frontPosition.method_1031(0.0, 0.35, 0.0);
            frontPosition = frontPosition.method_1019(this.method_19538());
            class_243 motion = new class_243(this.method_59922().method_43058() * 0.2 - 0.1, 0.1, this.method_59922().method_43058() * 0.2 - 0.1);
            this.method_37908().method_8406((class_2394)new class_2392(class_2398.field_11218, stack), frontPosition.field_1352, frontPosition.field_1351, frontPosition.field_1350, motion.field_1352, motion.field_1351 + 0.05, motion.field_1350);
        }
    }

    public boolean isPreviousCustomer(class_1657 player) {
        return this.tradedCustomers.contains(player.method_5667());
    }

    public boolean method_64397(class_3218 level, class_1282 source, float amount) {
        boolean attacked = super.method_64397(level, source, amount);
        if (attacked) {
            this.setCurious(false);
            this.setSitting(false);
            if (source.method_5529() instanceof class_1657) {
                this.method_5942().method_6340();
                this.field_6011.method_12778(STUNNED, (Object)true);
                this.field_6011.method_12778(STUN_ROTATION, (Object)Float.valueOf(this.getStunRotation(source.method_5529())));
                this.field_6201.method_35115().forEach(class_4135::method_6270);
                this.stunDelay = 20;
            }
        }
        return attacked;
    }

    private float getStunRotation(@Nullable class_1297 entity) {
        return entity != null ? entity.method_36454() : 0.0f;
    }

    public void setDespawnDelay(int despawnDelay) {
        this.despawnDelay = despawnDelay;
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_10545("Offers")) {
            this.offers = new GoblinOffers(compound.method_68568("Offers"));
        }
        if (compound.method_10545("DespawnDelay")) {
            this.despawnDelay = compound.method_68083("DespawnDelay", 0);
        }
        if (compound.method_10545("RestockDelay")) {
            this.restockDelay = compound.method_68083("RestockDelay", 0);
        }
        if (compound.method_10545("TradedCustomers")) {
            this.tradedCustomers.clear();
            class_2499 list = compound.method_68569("TradedCustomers");
            list.forEach(tag -> {
                if (tag instanceof class_2519) {
                    String value;
                    class_2519 $b$0 = (class_2519)tag;
                    try {
                        String patt1$temp;
                        value = patt1$temp = $b$0.comp_3831();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    UUID id = Utils.parseUuid(value);
                    if (id != null) {
                        this.tradedCustomers.add(id);
                    }
                }
            });
        }
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        class_1916 offers = this.method_8264();
        if (!offers.isEmpty()) {
            class_1916.field_48850.encodeStart((DynamicOps)class_2509.field_11560, (Object)offers).result().ifPresent(tag -> compound.method_10566("Offers", tag));
        }
        compound.method_10569("DespawnDelay", this.despawnDelay);
        compound.method_10569("RestockDelay", this.restockDelay);
        if (!this.tradedCustomers.isEmpty()) {
            class_2499 list = new class_2499();
            this.tradedCustomers.forEach(id -> list.add((Object)class_2519.method_23256((String)id.toString())));
            compound.method_10566("TradedCustomers", (class_2520)list);
        }
    }

    @Nullable
    protected class_3414 method_5994() {
        return (class_3414)ModSounds.ENTITY_GOBLIN_TRADER_IDLE_GRUNT.get();
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return (class_3414)ModSounds.ENTITY_GOBLIN_TRADER_IDLE_GRUNT.get();
    }

    public abstract class_1799 getFavouriteFood();

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23719, 0.25).method_26868(class_5134.field_52450, 10.0);
    }

    public boolean isStunned() {
        return (Boolean)this.field_6011.method_12789(STUNNED);
    }

    public float getStunRotation() {
        return ((Float)this.field_6011.method_12789(STUN_ROTATION)).floatValue();
    }

    protected abstract int getMaxRestockDelay();

    public abstract boolean canAttackBack();

    @Nullable
    public class_1296 method_5613(class_3218 level, class_1296 mob) {
        return null;
    }

    public void setSitting(boolean sitting) {
        this.field_6011.method_12778(SITTING, (Object)sitting);
    }

    public boolean isSitting() {
        return (Boolean)this.field_6011.method_12789(SITTING);
    }

    public void setCurious(boolean curious) {
        this.field_6011.method_12778(CURIOUS, (Object)curious);
        this.curiousTime = curious ? 100 : 0;
    }

    public void resetCurious() {
        this.field_6011.method_12778(CURIOUS, (Object)false);
        this.curiousTime = 0;
    }

    public boolean isCurious() {
        return (Boolean)this.field_6011.method_12789(CURIOUS);
    }

    protected float method_53964() {
        return 90.0f;
    }

    protected class_1330 method_5963() {
        return new GoblinRotationControl(this);
    }

    public float getHeadTilt(float partial) {
        return class_3532.method_16439((float)partial, (float)this.headTiltO, (float)this.headTilt);
    }

    public double method_23320() {
        return !this.isSitting() ? super.method_23320() : super.method_23320() - 0.17;
    }

    public float getArmAngle(float partial) {
        return class_3532.method_16439((float)partial, (float)this.armAngleO, (float)this.armAngle);
    }

    private float getTargetArmAngle() {
        if (this.isCurious() && !this.isSitting()) {
            return 110.0f;
        }
        if (!this.method_6118(class_1304.field_6173).method_7960()) {
            return 80.0f;
        }
        return 0.0f;
    }

    public void method_6078(class_1282 source) {
        super.method_6078(source);
        this.method_8259(null);
    }

    @Nullable
    public class_1297 method_5731(class_5454 transition) {
        this.method_8259(null);
        return super.method_5731(transition);
    }

    protected class_243 method_29919() {
        return new class_243(0.0, (double)this.method_5751() - 0.25, 0.0);
    }

    public void method_60964(class_1297 entity, boolean broadcast) {
        super.method_60964(entity, broadcast);
        this.method_35055();
    }

    public boolean method_17326() {
        if (((Boolean)Config.ENTITIES.preventDespawnIfNamed.get()).booleanValue() && this.method_16914()) {
            return true;
        }
        if (this.hasCustomer() || this.despawnDelay != 0) {
            return true;
        }
        if (this.method_60953()) {
            return true;
        }
        return super.method_17326();
    }

    public boolean method_65125(class_1657 player) {
        return this.method_8257() == player && this.method_5805() && player.method_56094((class_1297)this, 4.0);
    }

    public void method_6037(class_1799 stack, int count) {
        this.spawnFoodParticles(stack, count);
    }
}

