/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.util.io.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.api.registry.TRegistries;
import io.github.thecsdev.tcdcommons.api.registry.TSimpleRegistry;
import io.github.thecsdev.tcdcommons.api.util.io.cache.CacheFileUtils;
import io.github.thecsdev.tcdcommons.api.util.io.cache.CachedResource;
import io.github.thecsdev.tcdcommons.api.util.io.cache.CachedResourceSerializer;
import io.github.thecsdev.tcdcommons.api.util.io.cache.IResourceFetchTask;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1255;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class CachedResourceManager {
    private static final String THREAD_NAME = TCDCommons.getModID() + ":" + CachedResourceManager.class.getSimpleName().toLowerCase();
    private static final ExecutorService THREAD_SCHEDULER = Executors.newCachedThreadPool(task -> {
        Thread thread = new Thread(task, THREAD_NAME);
        thread.setDaemon(true);
        return thread;
    });
    private static final ScheduledExecutorService MAID_SCHEDULER = Executors.newScheduledThreadPool(0, task -> {
        Thread thread = new Thread(task, THREAD_NAME + "/maid");
        thread.setDaemon(true);
        return thread;
    });
    @ApiStatus.Internal
    static final Cache<class_2960, CachedResource<?>> RESOURCE_CACHE;
    @ApiStatus.Internal
    static final Cache<class_2960, Exception> RECENT_EXCEPTIONS;
    @ApiStatus.Internal
    static final Cache<class_2960, LinkedBlockingDeque<IResourceFetchTask<?>>> CURRENT_TASKS;

    private CachedResourceManager() {
    }

    public static final void init() {
    }

    public static final <R> void getResourceAsync(class_2960 resourceId, IResourceFetchTask<R> task) throws NullPointerException {
        CachedResourceManager.getResource(resourceId, task, true);
    }

    public static final <R> void getResourceSync(class_2960 resourceId, IResourceFetchTask<R> task) throws NullPointerException {
        CachedResourceManager.getResource(resourceId, task, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    private static final <R> void getResource(class_2960 resourceId, IResourceFetchTask<R> task, boolean isAsync) throws NullPointerException {
        Exception recentException;
        Objects.requireNonNull(resourceId);
        Objects.requireNonNull(task);
        Class rt = Objects.requireNonNull(task.getResourceType());
        class_1255<?> mc = task.getMinecraftClientOrServer();
        if (isAsync) {
            Objects.requireNonNull(mc);
        }
        if ((recentException = (Exception)RECENT_EXCEPTIONS.getIfPresent((Object)resourceId)) != null) {
            Runnable r = () -> task.onError(recentException);
            if (isAsync) {
                mc.method_40000(r);
            } else {
                r.run();
            }
            return;
        }
        @Nullable Cache<class_2960, LinkedBlockingDeque<IResourceFetchTask<?>>> cachedResource = (Cache<class_2960, LinkedBlockingDeque<IResourceFetchTask<?>>>)RESOURCE_CACHE.getIfPresent((Object)resourceId);
        if (cachedResource != null && cachedResource.getResource() != null && Objects.equals(rt, cachedResource.getResource().getClass()) && Instant.now().isBefore(cachedResource.getExpirationDate())) {
            Object castedRs = cachedResource.getResource();
            Runnable r = () -> task.onReady(castedRs);
            if (isAsync) {
                mc.method_40000(r);
            } else {
                r.run();
            }
            return;
        }
        AtomicReference<Object> currentTaskQueue = new AtomicReference<Object>(null);
        cachedResource = CURRENT_TASKS;
        synchronized (cachedResource) {
            currentTaskQueue.set(((LinkedBlockingDeque)CURRENT_TASKS.getIfPresent((Object)resourceId)));
            if (currentTaskQueue.get() != null) {
                ((LinkedBlockingDeque)currentTaskQueue.get()).add(task);
                return;
            }
            LinkedBlockingDeque<IResourceFetchTask<R>> newTask = new LinkedBlockingDeque<IResourceFetchTask<R>>(Integer.MAX_VALUE);
            CURRENT_TASKS.put((Object)resourceId, newTask);
            currentTaskQueue.set(newTask);
            newTask.add(task);
        }
        Runnable asyncFetchTask = () -> {
            AtomicReference result = new AtomicReference(CacheFileUtils.tryLoadCachedResource(resourceId, rt));
            AtomicReference<Object> error = new AtomicReference<Object>(null);
            if (result.get() == null) {
                try {
                    try {
                        Objects.requireNonNull(CachedResourceManager.getResourceSerializer(rt));
                    }
                    catch (NullPointerException npe) {
                        throw new UnsupportedOperationException(String.format("Resource type '%s' does not have a %s.", rt.getName(), CachedResourceSerializer.class.getSimpleName()), npe);
                    }
                    CachedResource fetched = Objects.requireNonNull(task.fetchResourceSync());
                    if (!Objects.equals(rt, fetched.getResourceType())) {
                        throw new ClassCastException("Resource fetching returned an illegal type.");
                    }
                    result.set(fetched);
                    CacheFileUtils.trySaveCachedResource(resourceId, fetched);
                }
                catch (Exception exc) {
                    error.set(exc);
                }
                catch (Error err) {
                    Runnable r = () -> {
                        throw err;
                    };
                    if (isAsync) {
                        mc.method_40000(r);
                    } else {
                        r.run();
                    }
                    CURRENT_TASKS.invalidate((Object)resourceId);
                    return;
                }
            }
            if (result.get() != null) {
                RESOURCE_CACHE.put((Object)resourceId, result.get());
            } else if (error.get() != null) {
                RECENT_EXCEPTIONS.put((Object)resourceId, (Object)error.get());
            }
            CURRENT_TASKS.invalidate((Object)resourceId);
            CachedResourceManager.__broadcastResult(((LinkedBlockingDeque)currentTaskQueue.get()).stream().toList(), result.get(), error.get(), isAsync);
        };
        if (isAsync) {
            THREAD_SCHEDULER.execute(asyncFetchTask);
        } else {
            asyncFetchTask.run();
        }
    }

    @ApiStatus.Internal
    private static final void __broadcastResult(Collection<IResourceFetchTask<?>> listeners, @Nullable CachedResource<?> result, @Nullable Exception error, boolean isAsync) {
        if (result == null && error == null) {
            return;
        }
        listeners.forEach(task -> {
            class_1255<?> mc = task.getMinecraftClientOrServer();
            if (isAsync && mc == null) {
                return;
            }
            Runnable r = () -> {
                if (error != null) {
                    task.onError(error);
                } else if (!Objects.equals(task.getResourceType(), result.getResourceType())) {
                    task.onError(new ClassCastException("Fetching returned an illegal resource type."));
                } else {
                    task.onReady(result.getResource());
                }
            };
            if (isAsync) {
                mc.method_40000(r);
            } else {
                r.run();
            }
        });
    }

    public static final void forceCache(class_2960 resourceId, CachedResource<?> cachedResource) throws NullPointerException {
        CachedResourceManager.forceCache(resourceId, cachedResource, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void forceCache(class_2960 resourceId, CachedResource<?> cachedResource, boolean overrideExisting) throws NullPointerException {
        Objects.requireNonNull(resourceId);
        Objects.requireNonNull(cachedResource);
        Cache<class_2960, CachedResource<?>> cache = RESOURCE_CACHE;
        synchronized (cache) {
            if (!overrideExisting && (RESOURCE_CACHE.getIfPresent((Object)resourceId) != null || CacheFileUtils.cacheFileExistsForResource(resourceId))) {
                return;
            }
            RESOURCE_CACHE.put((Object)resourceId, cachedResource);
            THREAD_SCHEDULER.execute(() -> CacheFileUtils.trySaveCachedResource(resourceId, cachedResource));
        }
    }

    public static final void forceInvalidate(class_2960 resourceId, boolean deleteCacheFiles) throws NullPointerException {
        Objects.requireNonNull(resourceId);
        RESOURCE_CACHE.invalidate((Object)resourceId);
        if (deleteCacheFiles) {
            THREAD_SCHEDULER.execute(() -> CacheFileUtils.tryDeleteCacheFile(resourceId));
        }
    }

    public static final boolean cachedResourceExists(class_2960 resourceId) throws NullPointerException {
        return CacheFileUtils.cacheFileExistsForResource(resourceId) || RESOURCE_CACHE.getIfPresent((Object)Objects.requireNonNull(resourceId)) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final <T> CachedResourceSerializer<T> getResourceSerializer(Class<T> resourceType) throws NullPointerException {
        Objects.requireNonNull(resourceType);
        TSimpleRegistry<CachedResourceSerializer<?>> tSimpleRegistry = TRegistries.CACHED_RESOURCE_SERIALIZER;
        synchronized (tSimpleRegistry) {
            for (Map.Entry entry : TRegistries.CACHED_RESOURCE_SERIALIZER) {
                CachedResourceSerializer crs = (CachedResourceSerializer)entry.getValue();
                if (!Objects.equals(resourceType, crs.getResourceType())) continue;
                CachedResourceSerializer crsCast = crs;
                return crsCast;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void cleanUp() {
        RESOURCE_CACHE.cleanUp();
        RECENT_EXCEPTIONS.cleanUp();
        CURRENT_TASKS.cleanUp();
        Cache<class_2960, CachedResource<?>> cache = RESOURCE_CACHE;
        synchronized (cache) {
            Instant now = Instant.now();
            RESOURCE_CACHE.asMap().entrySet().stream().filter(entry -> now.isAfter(((CachedResource)entry.getValue()).getExpirationDate())).map(entry -> (class_2960)entry.getKey()).toList().forEach(expiredId -> RESOURCE_CACHE.invalidate(expiredId));
        }
        CacheFileUtils.cleanUpExpiredFiles(null);
    }

    static {
        MAID_SCHEDULER.scheduleAtFixedRate(() -> CachedResourceManager.cleanUp(), 1L, 180L, TimeUnit.MINUTES);
        RESOURCE_CACHE = CacheBuilder.newBuilder().maximumWeight(102400L).expireAfterWrite(1L, TimeUnit.HOURS).weigher((k, v) -> (int)Math.min(v.getResourceSizeB(), Integer.MAX_VALUE)).removalListener(notif -> CacheFileUtils.resourceCacheRemovalListener(notif)).build();
        RECENT_EXCEPTIONS = CacheBuilder.newBuilder().maximumSize(256L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
        CURRENT_TASKS = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
        CachedResourceSerializer.init();
    }
}

