/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.badge;

import com.google.common.collect.Lists;
import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.TCDCommonsConfig;
import io.github.thecsdev.tcdcommons.api.badge.PlayerBadge;
import io.github.thecsdev.tcdcommons.api.badge.PlayerBadgeHandler;
import io.github.thecsdev.tcdcommons.api.hooks.entity.EntityHooks;
import io.github.thecsdev.tcdcommons.api.network.CustomPayloadNetwork;
import io.github.thecsdev.tcdcommons.api.registry.TRegistries;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.network.TCDCommonsNetwork;
import io.github.thecsdev.tcdcommons.util.TCDCT;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public final class ServerPlayerBadgeHandler
extends PlayerBadgeHandler {
    private static final TCDCommonsConfig CONFIG = Objects.requireNonNull(TCDCommons.getInstance().getConfig());
    protected final class_3222 player;
    protected final Object2IntMap<class_2960> pendingStatMap = Object2IntMaps.synchronize((Object2IntMap)new Object2IntOpenHashMap());

    public ServerPlayerBadgeHandler(class_3222 player) {
        this.player = Objects.requireNonNull(player);
    }

    public class_3222 getPlayer() {
        return this.player;
    }

    @Override
    public final void setValue(class_2960 badgeId, int value) throws NullPointerException {
        int oldValue = this.statMap.getInt((Object)badgeId);
        super.setValue(badgeId, value);
        this.pendingStatMap.put((Object)badgeId, value);
        if (value > oldValue) {
            ServerPlayerBadgeHandler.announceEarnedBadge(this.player, badgeId);
        }
    }

    protected final Object2IntMap<class_2960> takePendingStats() {
        Object2IntOpenHashMap copy = new Object2IntOpenHashMap(this.pendingStatMap);
        this.pendingStatMap.clear();
        return copy;
    }

    public final void loadFromPlayerNbt(class_2487 nbt) {
        block5: {
            class_2487 nbt_modId;
            block4: {
                String[] badgeList;
                String modId = TCDCommons.getModID();
                if (!nbt.method_10545(modId)) {
                    return;
                }
                nbt_modId = nbt.method_10562(modId).orElse(new class_2487());
                if (!nbt_modId.method_10545("player_badges")) break block4;
                String badgeListStr = nbt_modId.method_10558("player_badges").orElse("").trim();
                if (StringUtils.isBlank((CharSequence)badgeListStr)) {
                    return;
                }
                for (String badgeItem : badgeList = badgeListStr.split("\\R")) {
                    if (StringUtils.isBlank((CharSequence)badgeItem)) continue;
                    this.increaseValue(class_2960.method_60654((String)badgeItem), 1);
                }
                break block5;
            }
            if (!nbt_modId.method_10545("player_badges")) break block5;
            class_2487 badgeList = nbt_modId.method_10562("player_badges").orElse(new class_2487());
            for (String badgeIdStr : badgeList.method_10541()) {
                if (!badgeList.method_10545(badgeIdStr)) continue;
                this.setValue(class_2960.method_60654((String)badgeIdStr), badgeList.method_10550(badgeIdStr).orElse(0));
            }
        }
    }

    public final class_2487 saveToPlayerNbt(class_2487 nbt) {
        class_2487 nbt_modId;
        if (this.statMap.isEmpty()) {
            return nbt;
        }
        String modId = TCDCommons.getModID();
        if (!nbt.method_10545(modId)) {
            nbt.method_10566(modId, (class_2520)new class_2487());
        }
        if (!(nbt_modId = nbt.method_10562(modId).orElse(new class_2487())).method_10545("player_badges")) {
            nbt_modId.method_10566("player_badges", (class_2520)new class_2487());
        }
        class_2487 badgeList = nbt_modId.method_10562("player_badges").orElse(new class_2487());
        ObjectIterator<Object2IntMap.Entry<class_2960>> objectIterator = this.iterator();
        while (objectIterator.hasNext()) {
            Object2IntMap.Entry badgeEntry = (Object2IntMap.Entry)objectIterator.next();
            badgeList.method_10569(Objects.toString(badgeEntry.getKey()), badgeEntry.getIntValue());
        }
        return nbt;
    }

    public final boolean sendStats(class_3222 player) {
        if (!TCDCommons.getInstance().getConfig().enablePlayerBadges) {
            return false;
        }
        ArrayList badges = Lists.newArrayList((Iterator)this.takePendingStats().object2IntEntrySet().iterator());
        if (badges.size() == 0) {
            return false;
        }
        int chunkSize = 15;
        List badgePartitions = Lists.partition((List)badges, (int)15);
        for (List badgePartition : badgePartitions) {
            ServerPlayerBadgeHandler.sendStats(player, badgePartition);
        }
        return true;
    }

    private static void sendStats(class_3222 player, Collection<Object2IntMap.Entry<class_2960>> badgeChunk) {
        class_2540 data = new class_2540(Unpooled.buffer());
        data.method_53002(badgeChunk.size());
        for (Object2IntMap.Entry<class_2960> badgeEntry : badgeChunk) {
            if (badgeEntry.getKey() == null) continue;
            data.method_10812((class_2960)badgeEntry.getKey());
            data.method_10804(badgeEntry.getIntValue());
        }
        try {
            CustomPayloadNetwork.sendS2C(player, TCDCommonsNetwork.S2C_PLAYER_BADGES, (ByteBuf)data);
        }
        catch (Exception e) {
            TCDCommons.LOGGER.debug("Failed to send " + String.valueOf(TCDCommonsNetwork.S2C_PLAYER_BADGES) + " packet; " + e.getMessage());
            throw e;
        }
    }

    public static ServerPlayerBadgeHandler getServerBadgeHandler(class_3222 player) {
        ServerPlayerBadgeHandler pbh = (ServerPlayerBadgeHandler)EntityHooks.getCustomDataEntryG((class_1297)player, PlayerBadgeHandler.PBH_CUSTOM_DATA_ID);
        if (pbh == null) {
            pbh = EntityHooks.setCustomDataEntryG((class_1297)player, PlayerBadgeHandler.PBH_CUSTOM_DATA_ID, new ServerPlayerBadgeHandler(player));
        }
        return pbh;
    }

    public static boolean announceEarnedBadge(class_3222 player, class_2960 badgeId) {
        if (!ServerPlayerBadgeHandler.CONFIG.enablePlayerBadges || !ServerPlayerBadgeHandler.CONFIG.broadcastEarningPlayerBadges) {
            return false;
        }
        PlayerBadge badge = TRegistries.PLAYER_BADGE.getValue(badgeId).orElse(null);
        class_5250 badgeName = badge != null ? TextUtils.literal("").method_10852(badge.getName()) : TextUtils.literal(Objects.toString(badgeId));
        badgeName = ServerPlayerBadgeHandler.__formatBadgeName(badgeName, badgeId, badge);
        class_5250 message = TCDCT.cmd_pb_chatGrant(player.method_5477(), (class_2561)badgeName);
        player.method_5682().method_3760().method_43514((class_2561)message, false);
        return true;
    }

    private static final class_5250 __formatBadgeName(class_5250 badgeName, @Nullable class_2960 badgeId, @Nullable PlayerBadge badge) {
        class_5250 root = TextUtils.literal("");
        root.method_10852((class_2561)TextUtils.literal("[")).method_27692(class_124.field_1054);
        root.method_10852((class_2561)badgeName).method_27692(class_124.field_1054);
        root.method_10852((class_2561)TextUtils.literal("]")).method_27692(class_124.field_1054);
        class_5250 hover = TextUtils.literal("");
        hover.method_10852((class_2561)(badge != null ? badge.getName() : TextUtils.literal(Objects.toString(badgeId)).method_27692(class_124.field_1054)));
        hover.method_27693("\n");
        hover.method_10852((class_2561)TextUtils.literal(Objects.toString(badgeId)).method_27692(class_124.field_1080));
        if (badge != null) {
            hover.method_27693("\n\n");
            hover.method_10852(badge.getDescription());
        }
        class_2568.class_10613 hoverEvent = new class_2568.class_10613((class_2561)hover);
        root.method_10862(root.method_10866().method_10949((class_2568)hoverEvent));
        return root;
    }
}

