/*
 * Decompiled with CFR 0.152.
 */
package com.vsngarcia.fabric.client;

import com.vsngarcia.ElevatorHandler;
import com.vsngarcia.ElevatorMod;
import com.vsngarcia.client.ColorCamoElevator;
import com.vsngarcia.client.gui.ElevatorScreen;
import com.vsngarcia.fabric.ElevatorBlock;
import com.vsngarcia.fabric.FabricRegistry;
import com.vsngarcia.fabric.client.render.ElevatorBakedModel;
import com.vsngarcia.level.ElevatorContainer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelModifier;
import net.fabricmc.fabric.api.client.model.loading.v1.wrapper.WrapperUnbakedGroupedBlockStateModel;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableMesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3929;
import net.minecraft.class_4730;
import net.minecraft.class_7775;

@Environment(value=EnvType.CLIENT)
public final class ElevatorModFabricClient
implements ClientModInitializer {
    public void onInitializeClient() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> ElevatorHandler.handleInput(ClientPlayNetworking::send));
        ColorProviderRegistry.BLOCK.register((Object)new ColorCamoElevator(), (Object[])FabricRegistry.ELEVATOR_BLOCKS.values().toArray(new class_2248[0]));
        ModelLoadingPlugin.register((ModelLoadingPlugin)new ElevatorModelLoadingPlugin());
        class_3929.method_17542(FabricRegistry.ELEVATOR_CONTAINER, (container, inv, title) -> new ElevatorScreen((ElevatorContainer)container, inv, title, ClientPlayNetworking::send));
    }

    public static class ElevatorModelLoadingPlugin
    implements ModelLoadingPlugin {
        private static final class_4730 ARROW_SPRITE = new class_4730(class_1059.field_5275, class_2960.method_60655((String)"elevatorid", (String)"block/arrow"));
        private Mesh arrowMesh = null;

        public void initialize(ModelLoadingPlugin.Context ctx) {
            ctx.modifyBlockModelOnLoad().register(ModelModifier.WRAP_PHASE, (model, context) -> {
                if (!(context.state().method_26204() instanceof ElevatorBlock)) {
                    return model;
                }
                ElevatorMod.LOGGER.debug("Wrapping elevator model: {}", (Object)context.state());
                return new WrapperUnbakedGroupedBlockStateModel(model){

                    public class_1087 method_65542(class_2680 state, class_7775 baker) {
                        return new ElevatorBakedModel(model.method_65542(context.state(), baker), this.getArrowMesh(baker));
                    }
                };
            });
        }

        private Mesh getArrowMesh(class_7775 baker) {
            if (this.arrowMesh != null) {
                return this.arrowMesh;
            }
            class_1058 atlasSprite = baker.method_65732().method_65739(ARROW_SPRITE, () -> "elevator_arrow");
            Renderer renderer = Renderer.get();
            MutableMesh builder = renderer.mutableMesh();
            QuadEmitter emitter = builder.emitter();
            emitter.square(class_2350.field_11036, 0.3125f, 0.0f, 0.6875f, 0.375f, -0.01f);
            emitter.uvUnitSquare();
            emitter.spriteBake(atlasSprite, 35);
            emitter.color(-1, -1, -1, -1);
            emitter.cullFace(class_2350.field_11036);
            emitter.material(renderer.materialFinder().blendMode(BlendMode.CUTOUT_MIPPED).find());
            emitter.emit();
            this.arrowMesh = builder.immutableCopy();
            return this.arrowMesh;
        }
    }
}

