/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.stats.tabs;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.github.thecsdev.betterstats.BetterStatsProperties;
import io.github.thecsdev.betterstats.api.client.gui.util.StatsTabUtils;
import io.github.thecsdev.betterstats.api.client.registry.StatsTab;
import io.github.thecsdev.betterstats.client.gui.widget.CreditsTabPersonWidget;
import io.github.thecsdev.betterstats.util.BST;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.TParentElement;
import io.github.thecsdev.tcdcommons.api.client.gui.layout.UILayout;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TLabelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TPanelElement;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.enumerations.HorizontalAlignment;
import io.github.thecsdev.tcdcommons.util.TCDCT;
import io.github.thecsdev.tcdcommons.util.io.http.TcdWebApiPerson;
import java.awt.Rectangle;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public final class BSCreditsTab
extends StatsTab {
    private static final class_2561 TEXT_TITLE = TextUtils.translatable((String)"credits_and_attribution.button.credits", (Object[])new Object[0]);
    private static final class_2561 TEXT_CONTRIBUTORS = BST.bss_contributors_title();
    private static final class_2561 TEXT_SPECIAL_THANKS = TCDCT.tcdc_term_specialThanks();

    @Override
    public final class_2561 getName() {
        return TEXT_TITLE;
    }

    @Override
    public final boolean isAvailable() {
        return false;
    }

    @Override
    public final void initFilters(StatsTab.FiltersInitContext initContext) {
        StatsTabUtils.initDefaultFilters(initContext);
    }

    @Override
    public final void initStats(StatsTab.StatsInitContext initContext) {
        TPanelElement panel = initContext.getStatsPanel();
        TLabelElement lbl_title = StatsTabUtils.initGroupLabel(panel, TEXT_TITLE);
        lbl_title.setSize(lbl_title.getWidth(), lbl_title.getHeight() * 2);
        lbl_title.setTextColor(0xFFFFFF);
        lbl_title.setTextScale(1.8f);
        lbl_title.setTextHorizontalAlignment(HorizontalAlignment.CENTER);
        BSCreditsTab.initGroupLabel(panel, TEXT_CONTRIBUTORS);
        BSCreditsTab.initContributorStats(panel, null);
        BSCreditsTab.initGroupLabel(panel, TEXT_SPECIAL_THANKS);
        BSCreditsTab.initContributorStats(panel, "special_thanks");
    }

    private static final void initGroupLabel(TPanelElement panel, class_2561 text) {
        Rectangle n1 = UILayout.nextChildVerticalRect((TParentElement)panel);
        TPanelElement panel_tGroup = new TPanelElement(n1.x, n1.y, n1.width, 20);
        panel_tGroup.setBackgroundColor(-13290187);
        panel_tGroup.setOutlineColor(-16777216);
        panel.addChild((TElement)panel_tGroup, false);
        TLabelElement lbl = new TLabelElement(panel_tGroup.getHeight() + 5, 0, panel_tGroup.getWidth(), panel_tGroup.getHeight(), text);
        lbl.setTextHorizontalAlignment(HorizontalAlignment.LEFT);
        lbl.setTextColor(-256);
        lbl.setTextScale(0.9f);
        panel_tGroup.addChild((TElement)lbl);
    }

    private static final void initContributorStats(TPanelElement panel, @Nullable String key) {
        TcdWebApiPerson[] contributors = BSCreditsTab.getContributors(key);
        boolean highlight = true;
        int iteration = 1;
        for (TcdWebApiPerson contributor : contributors) {
            highlight = !highlight;
            Rectangle n1 = UILayout.nextChildVerticalRect((TParentElement)panel);
            CreditsTabPersonWidget ctpw = new CreditsTabPersonWidget(n1.x, n1.y, n1.width, contributor, ++iteration <= 15);
            ctpw.setBackgroundColor(highlight ? 0x44000000 : 0x22000000);
            panel.addChild((TElement)ctpw, false);
        }
    }

    public static final TcdWebApiPerson[] getContributors(@Nullable String key) {
        if (key == null) {
            key = "contributors";
        }
        @Nullable JsonArray contributors = null;
        try {
            contributors = BetterStatsProperties.getModProperties().get(key).getAsJsonArray();
        }
        catch (Exception e) {
            return new TcdWebApiPerson[0];
        }
        return (TcdWebApiPerson[])contributors.asList().stream().filter(p -> p.isJsonObject()).map(p -> p.getAsJsonObject()).map(p -> BSCreditsTab.tryParsePerson(p)).filter(p -> p != null).toArray(TcdWebApiPerson[]::new);
    }

    @Nullable
    private static final TcdWebApiPerson tryParsePerson(JsonObject json) throws NullPointerException {
        try {
            return new TcdWebApiPerson(json);
        }
        catch (Exception e) {
            return null;
        }
    }
}

