/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.panel;

import io.github.thecsdev.betterstats.api.client.gui.panel.BSComponentPanel;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TLabelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TButtonWidget;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.enumerations.HorizontalAlignment;
import java.util.Objects;
import net.minecraft.class_2561;

public final class PageChooserPanel
extends BSComponentPanel {
    private final PageChooserPanelProxy proxy;

    public PageChooserPanel(int x, int y, int width, PageChooserPanelProxy proxy) {
        super(x, y, width, 22);
        this.proxy = Objects.requireNonNull(proxy);
    }

    public PageChooserPanelProxy getProxy() {
        return this.proxy;
    }

    protected final void init() {
        int maxPages = Math.max(this.proxy.getPageCount(), 1);
        int page = Math.min(Math.max(this.proxy.getPage(), 1), maxPages);
        TLabelElement lbl = new TLabelElement(0, 0, this.width, this.height);
        lbl.setText((class_2561)TextUtils.literal((String)(page + " / " + maxPages)));
        lbl.setTextHorizontalAlignment(HorizontalAlignment.CENTER);
        this.addChild((TElement)lbl, true);
        TButtonWidget btn_left = new TButtonWidget(1, 1, 20, 20, (class_2561)TextUtils.literal((String)"<"));
        btn_left.setOnClick(__ -> this.nav(-1));
        btn_left.setEnabled(page > 1);
        this.addChild((TElement)btn_left, true);
        TButtonWidget btn_right = new TButtonWidget(this.width - 21, 1, 20, 20, (class_2561)TextUtils.literal((String)">"));
        btn_right.setOnClick(__ -> this.nav(1));
        btn_right.setEnabled(page < maxPages);
        this.addChild((TElement)btn_right, true);
    }

    private final void nav(int num) {
        int maxPages = Math.max(this.proxy.getPageCount(), 1);
        int page = Math.min(Math.max(this.proxy.getPage() + num, 1), maxPages);
        this.proxy.setPage(page);
        if (this.getParent() != null) {
            this.refresh();
        }
    }

    public static interface PageChooserPanelProxy {
        public int getPage();

        public int getPageCount();

        public void setPage(int var1);
    }
}

