/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.render;

import com.hidoni.customizableelytra.Constants;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1049;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class TextureUtils {
    private static final Map<class_2960, class_2960> TEXTURE_CACHE = new HashMap<class_2960, class_2960>();

    private static void convertTextureToGrayscale(class_1011 nativeImage) {
        for (int x = 0; x < nativeImage.method_4307(); ++x) {
            for (int y = 0; y < nativeImage.method_4323(); ++y) {
                int pixelARGB = nativeImage.method_61940(x, y);
                int originalRGB = pixelARGB & 0xFFFFFF;
                int grayscale = (((originalRGB & 0xFF0000) >> 16) + ((originalRGB & 0xFF00) >> 8) + (originalRGB & 0xFF)) / 3;
                int newRGB = 65793 * grayscale;
                nativeImage.method_61941(x, y, pixelARGB & 0xFF000000 | newRGB);
            }
        }
    }

    private static class_1011 copyNativeImage(class_1011 nativeImage) {
        class_1011 returnTexture = new class_1011(nativeImage.method_4307(), nativeImage.method_4323(), false);
        returnTexture.method_4317(nativeImage);
        return returnTexture;
    }

    private static class_1011 getNativeImageFromTexture(class_2960 locationIn) {
        class_1044 texture = class_310.method_1551().method_1531().method_4619(locationIn);
        if (texture instanceof class_1043) {
            class_1043 dynamicTexture = (class_1043)texture;
            class_1011 dynamicTextureData = dynamicTexture.method_4525();
            if (dynamicTextureData != null) {
                return TextureUtils.copyNativeImage(dynamicTextureData);
            }
        } else if (texture instanceof class_1049) {
            class_1049 simpleTexture = (class_1049)texture;
            try {
                return TextureUtils.copyNativeImage(simpleTexture.method_65809(class_310.method_1551().method_1478()).comp_3447());
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    private static class_2960 createGrayscaleTexture(class_2960 locationIn) {
        Constants.LOG.debug("Creating grayscale texture for: " + String.valueOf(locationIn));
        class_1011 texture = TextureUtils.getNativeImageFromTexture(locationIn);
        if (texture == null) {
            return locationIn;
        }
        TextureUtils.convertTextureToGrayscale(texture);
        class_2960 locationOut = class_2960.method_60655((String)"customizableelytra", (String)("grayscale_" + locationIn.method_12832()));
        class_310.method_1551().method_1531().method_4616(locationOut, (class_1044)new class_1043(() -> ((class_2960)locationOut).toString(), texture));
        return locationOut;
    }

    public static class_2960 getGrayscale(class_2960 locationIn) {
        return TEXTURE_CACHE.computeIfAbsent(locationIn, TextureUtils::createGrayscaleTexture);
    }
}

