/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.client;

import com.hidoni.customizableelytra.Constants;
import com.hidoni.customizableelytra.customization.CustomizationUtils;
import com.hidoni.customizableelytra.item.CustomizableElytraItem;
import com.hidoni.customizableelytra.item.components.ElytraCustomization;
import com.hidoni.customizableelytra.mixin.ElytraModelAccessor;
import com.hidoni.customizableelytra.mixin.TextureAtlasAccessor;
import com.hidoni.customizableelytra.render.TextureUtils;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_10191;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2582;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5321;
import net.minecraft.class_563;
import net.minecraft.class_630;
import net.minecraft.class_8053;
import net.minecraft.class_8056;
import net.minecraft.class_918;
import net.minecraft.class_9307;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomizableElytraLayerHelper {
    private static final class_1059 bannerPatternAtlas = CustomizableElytraLayerHelper.getAtlas(Constants.ELYTRA_BANNER_SHEET);
    private static final class_1059 armorTrimAtlas = CustomizableElytraLayerHelper.getAtlas(class_4722.field_42071);
    private static final class_2960 TEXTURE_GRAYSCALE_ELYTRA = class_2960.method_60655((String)"customizableelytra", (String)"textures/entity/elytra.png");
    private static final Function<class_8053, class_1058> elytraTrimLookup = class_156.method_34866(trim -> armorTrimAtlas.method_4608(trim.method_67225("trims/models/elytra", class_10191.field_54142)));
    private static final class_2960 VANILLA_WINGS_LOCATION = class_2960.method_60656((String)"textures/entity/equipment/wings/elytra.png");

    public static void render(class_563 elytraModel, class_1799 elytraStack, class_4587 poseStack, class_4597 multiBufferSource, int packedLight, @Nullable class_2960 playerTexture) {
        ElytraCustomization customization = CustomizationUtils.getElytraCustomization(elytraStack);
        CustomizableElytraLayerHelper.renderWing(((ElytraModelAccessor)elytraModel).getLeftWing(), customization.leftWing(), poseStack, multiBufferSource, packedLight, elytraStack.method_7958(), ((CustomizableElytraItem)customization.leftWing().method_7909()).isCapeHidden(customization.leftWing()) ? null : playerTexture);
        CustomizableElytraLayerHelper.renderWing(((ElytraModelAccessor)elytraModel).getRightWing(), customization.rightWing(), poseStack, multiBufferSource, packedLight, elytraStack.method_7958(), ((CustomizableElytraItem)customization.rightWing().method_7909()).isCapeHidden(customization.rightWing()) ? null : playerTexture);
    }

    private static void renderWing(class_630 wingModel, class_1799 wingStack, class_4587 poseStack, class_4597 multiBufferSource, int packedLight, boolean hasFoil, @Nullable class_2960 playerTexture) {
        CustomizableElytraItem wingItem = (CustomizableElytraItem)wingStack.method_7909();
        if (wingItem.isGlowing(wingStack)) {
            packedLight |= 0xFF;
        }
        if (wingItem.isDyed(wingStack)) {
            CustomizableElytraLayerHelper.renderDyedWing(wingModel, wingStack, poseStack, multiBufferSource, packedLight, wingItem, CustomizableElytraLayerHelper.getGrayscaleTexture(playerTexture), hasFoil);
        } else if (wingItem.hasBanner(wingStack)) {
            CustomizableElytraLayerHelper.renderWingBannerPatterns(wingModel, wingStack, poseStack, multiBufferSource, packedLight, wingItem, CustomizableElytraLayerHelper.getGrayscaleTexture(playerTexture), hasFoil);
        } else {
            CustomizableElytraLayerHelper.renderBasicWing(wingModel, wingStack, poseStack, multiBufferSource, packedLight, wingItem, hasFoil, playerTexture);
        }
        if (wingItem.hasArmorTrim(wingStack)) {
            CustomizableElytraLayerHelper.renderWingTrim(wingModel, wingStack, poseStack, multiBufferSource, packedLight, wingItem, hasFoil);
        }
    }

    private static void renderDyedWing(class_630 wingModel, class_1799 wingStack, class_4587 poseStack, class_4597 multiBufferSource, int packedLight, CustomizableElytraItem wingItem, class_2960 elytraTexture, boolean hasFoil) {
        class_4588 elytraVertexConsumer = class_918.method_27952((class_4597)multiBufferSource, (class_1921)class_1921.method_25448((class_2960)elytraTexture), (boolean)hasFoil);
        wingModel.method_22699(poseStack, elytraVertexConsumer, packedLight, class_4608.field_21444, wingItem.getColor(wingStack));
    }

    private static void renderWingBannerPatterns(class_630 wingModel, class_1799 wingStack, class_4587 poseStack, class_4597 multiBufferSource, int packedLight, CustomizableElytraItem wingItem, class_2960 elytraTexture, boolean hasFoil) {
        class_9307 bannerPatterns = wingItem.getBannerPatterns(wingStack);
        wingModel.method_22698(poseStack, class_918.method_23181((class_4597)multiBufferSource, (class_1921)class_1921.method_23588((class_2960)elytraTexture), (boolean)false, (boolean)hasFoil), packedLight, class_4608.field_21444);
        wingModel.method_22699(poseStack, class_918.method_23181((class_4597)multiBufferSource, (class_1921)class_1921.method_23580((class_2960)elytraTexture), (boolean)false, (boolean)false), packedLight, class_4608.field_21444, wingItem.getBaseColor(wingStack).method_7787());
        for (int i = 0; i < bannerPatterns.comp_2428().size(); ++i) {
            class_9307.class_9308 bannerAndColor = (class_9307.class_9308)bannerPatterns.comp_2428().get(i);
            Optional resourceKey = bannerAndColor.comp_2429().method_40230();
            if (!resourceKey.isPresent()) continue;
            class_4730 bannerMaterial = new class_4730(Constants.ELYTRA_BANNER_SHEET, CustomizableElytraLayerHelper.getTextureLocation((class_5321<class_2582>)((class_5321)resourceKey.get())));
            Map<class_2960, class_1058> texturesByName = ((TextureAtlasAccessor)bannerPatternAtlas).getTexturesByName();
            if (texturesByName.get(bannerMaterial.method_24147()) == null) continue;
            wingModel.method_22699(poseStack, bannerMaterial.method_24145(multiBufferSource, class_1921::method_23580), packedLight, class_4608.field_21444, bannerAndColor.comp_2430().method_7787());
        }
    }

    private static void renderBasicWing(class_630 wingModel, class_1799 wingStack, class_4587 poseStack, class_4597 multiBufferSource, int packedLight, CustomizableElytraItem wingItem, boolean hasFoil, @Nullable class_2960 playerTexture) {
        class_4588 vertexConsumer = class_918.method_27952((class_4597)multiBufferSource, (class_1921)class_1921.method_25448((class_2960)(playerTexture == null ? VANILLA_WINGS_LOCATION : playerTexture)), (boolean)hasFoil);
        wingModel.method_22698(poseStack, vertexConsumer, packedLight, class_4608.field_21444);
    }

    @NotNull
    private static class_1059 getAtlas(class_2960 location) {
        return class_310.method_1551().method_1554().method_24153(location);
    }

    private static void renderWingTrim(class_630 wingModel, class_1799 wingStack, class_4587 poseStack, class_4597 multiBufferSource, int packedLight, CustomizableElytraItem wingItem, boolean hasFoil) {
        Optional<class_8053> armorTrim = wingItem.getArmorTrim(wingStack);
        armorTrim.ifPresent(trim -> {
            class_1058 sprite = elytraTrimLookup.apply((class_8053)trim);
            class_4588 consumer = sprite.method_24108(class_918.method_23181((class_4597)multiBufferSource, (class_1921)class_4722.method_48480((boolean)((class_8056)trim.comp_3180().comp_349()).comp_1905()), (boolean)true, (boolean)hasFoil));
            wingModel.method_22698(poseStack, consumer, packedLight, class_4608.field_21444);
        });
    }

    private static class_2960 getGrayscaleTexture(@Nullable class_2960 playerTexture) {
        if (playerTexture != null) {
            return TextureUtils.getGrayscale(playerTexture);
        }
        return TEXTURE_GRAYSCALE_ELYTRA;
    }

    private static class_2960 getTextureLocation(class_5321<class_2582> bannerIn) {
        return class_2960.method_60655((String)"customizableelytra", (String)("entity/elytra_banner/" + bannerIn.method_29177().method_12832()));
    }
}

