/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.comforts.common;

import com.illusivesoulworks.comforts.ComfortsConstants;
import com.illusivesoulworks.comforts.common.ComfortsConfig;
import com.illusivesoulworks.comforts.common.block.HammockBlock;
import com.illusivesoulworks.comforts.common.block.SleepingBagBlock;
import com.illusivesoulworks.comforts.platform.Services;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5838;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;

public class ComfortsEvents {
    private static final List<class_1293> SLEEPING_BAG_EFFECTS = new ArrayList<class_1293>();
    static boolean effectsInitialized = false;

    public static boolean canSetSpawn(class_1657 player, class_2338 pos) {
        class_1937 level = player.method_37908();
        if (pos != null && !player.method_37908().method_8608()) {
            class_2248 block = level.method_8320(pos).method_26204();
            return !(block instanceof SleepingBagBlock) && !(block instanceof HammockBlock);
        }
        return true;
    }

    public static Result checkTime(class_1937 level, class_2338 pos) {
        long time = level.method_8532() % 24000L;
        ComfortsConfig.ComfortsTimeUse timeUse = ComfortsConfig.ComfortsTimeUse.NIGHT;
        class_2248 block = level.method_8320(pos).method_26204();
        if (block instanceof HammockBlock) {
            timeUse = (ComfortsConfig.ComfortsTimeUse)((Object)ComfortsConfig.SERVER.hammockUse.get());
        } else if (block instanceof SleepingBagBlock) {
            timeUse = (ComfortsConfig.ComfortsTimeUse)((Object)ComfortsConfig.SERVER.sleepingBagUse.get());
        }
        if (time > 500L && time < 11500L && (timeUse == ComfortsConfig.ComfortsTimeUse.DAY || timeUse == ComfortsConfig.ComfortsTimeUse.DAY_OR_NIGHT)) {
            return Result.ALLOW;
        }
        if (timeUse == ComfortsConfig.ComfortsTimeUse.DAY_OR_NIGHT || timeUse == ComfortsConfig.ComfortsTimeUse.NIGHT) {
            return Result.DEFAULT;
        }
        return Result.DENY;
    }

    public static long getWakeTime(class_3218 level, long currentTime, long newTime) {
        boolean[] daySleeping = new boolean[]{false};
        List players = level.method_18456();
        for (class_1657 player : players) {
            player.method_18398().ifPresent(bedPos -> {
                if (player.method_7276()) {
                    ComfortsConfig.ComfortsTimeUse timeUse = ComfortsConfig.ComfortsTimeUse.NIGHT;
                    class_2248 block = level.method_8320(bedPos).method_26204();
                    if (block instanceof HammockBlock) {
                        timeUse = (ComfortsConfig.ComfortsTimeUse)((Object)((Object)ComfortsConfig.SERVER.hammockUse.get()));
                    } else if (block instanceof SleepingBagBlock) {
                        timeUse = (ComfortsConfig.ComfortsTimeUse)((Object)((Object)ComfortsConfig.SERVER.sleepingBagUse.get()));
                    }
                    if (timeUse == ComfortsConfig.ComfortsTimeUse.DAY || timeUse == ComfortsConfig.ComfortsTimeUse.DAY_OR_NIGHT) {
                        daySleeping[0] = true;
                    }
                }
            });
            if (!daySleeping[0]) continue;
            break;
        }
        if (daySleeping[0] && level.method_8410().method_8530()) {
            long i = currentTime + 24000L;
            long result = i - i % 24000L - 12001L;
            return Math.max((long)((Integer)ComfortsConfig.SERVER.nightWakeTimeOffset.get()).intValue() + result, currentTime);
        }
        return Math.max(newTime + (long)((Integer)ComfortsConfig.SERVER.dayWakeTimeOffset.get()).intValue(), currentTime);
    }

    public static void onWakeUp(class_1657 player) {
        class_1937 level = player.method_37908();
        if (!level.field_9236) {
            Services.SLEEP_EVENTS.getSleepData(player).ifPresent(data -> player.method_18398().ifPresent(bedPos -> {
                long wakeTime = level.method_8532();
                long timeSlept = wakeTime - data.getSleepTime();
                class_2680 state = level.method_8320(bedPos);
                if (state.method_26204() instanceof SleepingBagBlock) {
                    boolean broke = false;
                    if (timeSlept > 500L) {
                        class_1324 attributeInstance;
                        List<class_1293> effectInstances;
                        if (!effectsInitialized) {
                            ComfortsEvents.initializeEffects();
                            effectsInitialized = true;
                        }
                        if (!(effectInstances = SLEEPING_BAG_EFFECTS).isEmpty()) {
                            for (class_1293 effect : effectInstances) {
                                player.method_6092(new class_1293(effect.method_5579(), effect.method_5584(), effect.method_5578()));
                            }
                        }
                        double breakChance = (double)((Integer)ComfortsConfig.SERVER.sleepingBagBreakChance.get()).intValue() / 100.0;
                        double luckMultiplier = (Double)ComfortsConfig.SERVER.sleepingBagBreakChanceLuckMultiplier.get();
                        if (luckMultiplier > 0.0 && (attributeInstance = player.method_5996(class_5134.field_23726)) != null) {
                            breakChance -= luckMultiplier * attributeInstance.method_6194();
                        }
                        if (level.field_9229.method_43058() < breakChance) {
                            broke = true;
                            class_2338 blockpos = bedPos.method_10093(((class_2350)state.method_11654((class_2769)class_2383.field_11177)).method_10153());
                            level.method_8650(bedPos, false);
                            level.method_8650(blockpos, false);
                            player.method_7353((class_2561)class_2561.method_43471((String)"item.comforts.sleeping_bag.broke"), true);
                            level.method_8396(null, bedPos, class_3417.field_14983, class_3419.field_15245, 1.0f, 1.0f);
                            player.method_18399();
                        }
                    }
                    if (!broke && data.getAutoSleepPos() != null) {
                        class_2338 blockpos = bedPos.method_10093(((class_2350)state.method_11654((class_2769)class_2383.field_11177)).method_10153());
                        if (!player.method_68878()) {
                            level.method_8650(blockpos, false);
                            level.method_8650(bedPos, false);
                        } else {
                            level.method_8650(bedPos, false);
                            level.method_8650(blockpos, false);
                        }
                        player.method_18399();
                    }
                }
                data.setWakeTime(wakeTime);
                data.setTiredTime(wakeTime + (long)((double)timeSlept / (Double)ComfortsConfig.SERVER.restMultiplier.get()));
                data.setAutoSleepPos(null);
            }));
        }
    }

    private static void initializeEffects() {
        SLEEPING_BAG_EFFECTS.clear();
        ((List)ComfortsConfig.SERVER.sleepingBagEffects.get()).forEach(effect -> {
            String[] elements = effect.split(";");
            class_6880<class_1291> mobEffect = Services.REGISTRY_UTIL.getMobEffect(class_2960.method_12829((String)elements[0]));
            if (mobEffect == null) {
                return;
            }
            int duration = 0;
            int amp = 0;
            try {
                duration = Math.max(1, Math.min(Integer.parseInt(elements[1]), 1600));
                amp = Math.max(1, Math.min(Integer.parseInt(elements[2]), 4));
            }
            catch (Exception e) {
                ComfortsConstants.LOG.error("Problem parsing sleeping bag effects in config!", (Throwable)e);
            }
            SLEEPING_BAG_EFFECTS.add(new class_1293(mobEffect, duration * 20, amp - 1));
        });
    }

    public static class_1657.class_1658 onSleep(class_1657 player) {
        if (!player.method_37908().method_8608()) {
            return Services.SLEEP_EVENTS.getSleepData(player).map(data -> {
                long dayTime = player.method_5770().method_8532();
                data.setSleepTime(dayTime);
                if (((Boolean)ComfortsConfig.SERVER.restrictSleeping.get()).booleanValue()) {
                    if (data.getWakeTime() > dayTime) {
                        data.setWakeTime(0L);
                        data.setTiredTime(0L);
                    }
                    if (data.getTiredTime() > dayTime) {
                        player.method_7353((class_2561)class_2561.method_43471((String)"capability.comforts.not_sleepy"), true);
                        return class_1657.class_1658.field_7531;
                    }
                }
                return null;
            }).orElse(null);
        }
        return null;
    }

    public static int sleepersNeeded(int activePlayers) {
        int percentage = (Integer)ComfortsConfig.SERVER.daySleepingPercentage.get();
        if (percentage < 0) {
            return 0;
        }
        return Math.max(1, class_3532.method_15386((float)((float)(activePlayers * percentage) / 100.0f)));
    }

    public static boolean announceSleepStatus(class_5838 sleepStatus, class_3218 serverLevel) {
        MinecraftServer server = serverLevel.method_8503();
        if (!serverLevel.method_8530()) {
            return false;
        }
        if (!server.method_3724() || server.method_3860()) {
            int percentage = (Integer)ComfortsConfig.SERVER.daySleepingPercentage.get();
            if (percentage < 0) {
                percentage = serverLevel.method_64395().method_8356(class_1928.field_28357);
            }
            if (percentage > 100) {
                return false;
            }
            class_5250 component = sleepStatus.method_33812(percentage) ? class_2561.method_43471((String)"comforts.skipping_day") : class_2561.method_43469((String)"sleep.players_sleeping", (Object[])new Object[]{sleepStatus.method_33815(), sleepStatus.method_33816(percentage)});
            for (class_3222 player : serverLevel.method_18456()) {
                player.method_7353((class_2561)component, true);
            }
            return true;
        }
        return false;
    }

    public static enum Result {
        ALLOW,
        DEFAULT,
        DENY;

    }
}

