/*
 * Decompiled with CFR 0.152.
 */
package malte0811.ferritecore.fastmap.neighbormap;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import malte0811.ferritecore.ducks.FastMapStateHolder;
import malte0811.ferritecore.fastmap.FastMapKey;
import malte0811.ferritecore.fastmap.neighbormap.NeighborMapBase;
import net.minecraft.class_2769;
import org.jetbrains.annotations.NotNull;

public class FastmapNeighborMap<S>
extends NeighborMapBase<S> {
    private final FastMapStateHolder<S> owner;

    public FastmapNeighborMap(FastMapStateHolder<S> owner) {
        this.owner = owner;
    }

    @Override
    public int size() {
        return this.owner.getStateMap().numProperties();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.owner.getStateMap().getPropertySet().contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return false;
    }

    @Override
    public S[] get(Object key) {
        if (this.containsKey(key)) {
            return this.buildNeighbors((class_2769)key);
        }
        return null;
    }

    @Override
    @NotNull
    public Set<class_2769<?>> keySet() {
        return this.owner.getStateMap().getPropertySet();
    }

    @Override
    @NotNull
    public Collection<S[]> values() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (class_2769 property : this.owner.getStateMap().getPropertySet()) {
            builder.add(this.buildNeighbors(property));
        }
        return builder.build();
    }

    @Override
    @NotNull
    public Set<Map.Entry<class_2769<?>, S[]>> entrySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (class_2769 property : this.owner.getStateMap().getPropertySet()) {
            builder.add(new AbstractMap.SimpleEntry<class_2769, S[]>(property, this.buildNeighbors(property)));
        }
        return builder.build();
    }

    private <V extends Comparable<V>> S[] buildNeighbors(class_2769<V> prop) {
        Object[] neighbors = new Object[prop.method_11898().size()];
        FastMapKey key = (FastMapKey)Preconditions.checkNotNull(this.owner.getStateMap().getKeyFor(prop));
        for (int i = 0; i < neighbors.length; ++i) {
            int neighborIndex = key.replaceIn(this.owner.getStateIndex(), key.toPartialMapIndex(i));
            neighbors[i] = this.owner.getStateMap().getStateByIndex(neighborIndex);
        }
        return neighbors;
    }
}

