/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.entity.sync;

import com.mrcrayfish.framework.api.sync.SyncedClassKey;
import com.mrcrayfish.framework.api.sync.SyncedDataKey;
import com.mrcrayfish.framework.entity.sync.DataEntry;
import com.mrcrayfish.framework.entity.sync.SyncedEntityData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class DataHolder {
    Map<SyncedDataKey<?, ?>, DataEntry<?, ?>> dataMap = new HashMap();
    private class_1297 entity;
    private boolean pendingSync;

    public DataHolder setup(class_1297 entity) {
        if (this.entity == null) {
            this.entity = entity;
        }
        return this;
    }

    <E extends class_1297, T> boolean set(SyncedDataKey<?, ?> key, T value) {
        DataEntry entry = this.dataMap.computeIfAbsent(key, key2 -> new DataEntry(this, key2));
        if (!entry.getValue().equals(value)) {
            entry.setValue(value);
            return true;
        }
        return false;
    }

    @Nullable
    <E extends class_1297, T> T get(SyncedDataKey<E, T> key) {
        return this.dataMap.computeIfAbsent(key, key2 -> new DataEntry(this, key2)).getValue();
    }

    boolean markForSync() {
        if (SyncedEntityData.instance().markForSync(this.entity)) {
            this.pendingSync = true;
            return true;
        }
        return false;
    }

    boolean isPendingSync() {
        return this.pendingSync;
    }

    void clearSync() {
        this.pendingSync = false;
        this.dataMap.forEach((key, entry) -> entry.clearSync());
    }

    List<DataEntry<?, ?>> gatherPendingSyncDataEntries() {
        return this.dataMap.values().stream().filter(DataEntry::isPendingSync).filter(entry -> entry.getKey().syncMode().willSync()).collect(Collectors.toList());
    }

    List<DataEntry<?, ?>> gatherAllTrackingDataEntries() {
        return this.dataMap.values().stream().filter(entry -> entry.getKey().syncMode().willSync()).collect(Collectors.toList());
    }

    public class_2499 serialize(class_7225.class_7874 provider) {
        class_2499 list = new class_2499();
        this.dataMap.forEach((key, entry) -> {
            if (key.save()) {
                class_2487 keyTag = new class_2487();
                keyTag.method_10582("ClassKey", key.classKey().id().toString());
                keyTag.method_10582("DataKey", key.id().toString());
                Optional.ofNullable(entry.writeValue(provider)).ifPresent(tag -> keyTag.method_10566("Value", tag));
                list.add((Object)keyTag);
            }
        });
        return list;
    }

    public void deserialize(class_2499 listTag, class_7225.class_7874 provider) {
        this.dataMap.clear();
        listTag.forEach(entryTag -> {
            class_2487 keyTag = (class_2487)entryTag;
            Optional rawClassKey = keyTag.method_10558("ClassKey");
            if (rawClassKey.isEmpty()) {
                return;
            }
            Optional rawDataKey = keyTag.method_10558("DataKey");
            if (rawDataKey.isEmpty()) {
                return;
            }
            class_2960 classKey = class_2960.method_12829((String)((String)rawClassKey.get()));
            class_2960 dataKey = class_2960.method_12829((String)((String)rawDataKey.get()));
            class_2520 value = keyTag.method_10580("Value");
            SyncedClassKey<?> syncedClassKey = SyncedEntityData.instance().getClassKey(classKey);
            if (syncedClassKey == null) {
                return;
            }
            Map<class_2960, SyncedDataKey<?, ?>> keys = SyncedEntityData.instance().getDataKeys(syncedClassKey);
            if (keys == null) {
                return;
            }
            SyncedDataKey<?, ?> syncedDataKey = keys.get(dataKey);
            if (syncedDataKey == null || !syncedDataKey.save()) {
                return;
            }
            DataEntry entry = new DataEntry(this, syncedDataKey);
            entry.readValue(value, provider);
            this.dataMap.put(syncedDataKey, entry);
        });
    }
}

