/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.client.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mrcrayfish.framework.api.serialize.DataObject;
import com.mrcrayfish.framework.client.model.OpenModelDeserializer;
import com.mrcrayfish.framework.util.reflection.ReflectedMethod;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Type;
import java.lang.runtime.ObjectMethods;
import net.minecraft.class_10419;
import net.minecraft.class_10820;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_793;
import net.minecraft.class_809;
import org.jetbrains.annotations.Nullable;

public final class OpenBlockModel
extends Record
implements class_1100 {
    @Nullable
    private final class_10820 geometry;
    @Nullable
    private final class_1100.class_4751 guiLight;
    @Nullable
    private final Boolean ambientOcclusion;
    @Nullable
    private final class_809 transforms;
    private final class_10419.class_10420 textureSlots;
    @Nullable
    private final class_2960 parent;
    private final DataObject data;

    public OpenBlockModel(@Nullable class_10820 geometry, @Nullable class_1100.class_4751 guiLight, @Nullable Boolean ambientOcclusion, @Nullable class_809 transforms, class_10419.class_10420 textureSlots, @Nullable class_2960 parent, DataObject data) {
        this.geometry = geometry;
        this.guiLight = guiLight;
        this.ambientOcclusion = ambientOcclusion;
        this.transforms = transforms;
        this.textureSlots = textureSlots;
        this.parent = parent;
        this.data = data;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{OpenBlockModel.class, "geometry;guiLight;ambientOcclusion;transforms;textureSlots;parent;data", "geometry", "guiLight", "ambientOcclusion", "transforms", "textureSlots", "parent", "data"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{OpenBlockModel.class, "geometry;guiLight;ambientOcclusion;transforms;textureSlots;parent;data", "geometry", "guiLight", "ambientOcclusion", "transforms", "textureSlots", "parent", "data"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{OpenBlockModel.class, "geometry;guiLight;ambientOcclusion;transforms;textureSlots;parent;data", "geometry", "guiLight", "ambientOcclusion", "transforms", "textureSlots", "parent", "data"}, this, o);
    }

    @Nullable
    public class_10820 comp_3739() {
        return this.geometry;
    }

    @Nullable
    public class_1100.class_4751 comp_3740() {
        return this.guiLight;
    }

    @Nullable
    public Boolean comp_3741() {
        return this.ambientOcclusion;
    }

    @Nullable
    public class_809 comp_3742() {
        return this.transforms;
    }

    public class_10419.class_10420 comp_3743() {
        return this.textureSlots;
    }

    @Nullable
    public class_2960 comp_3744() {
        return this.parent;
    }

    public DataObject data() {
        return this.data;
    }

    public static class Deserializer
    implements JsonDeserializer<OpenBlockModel> {
        public static final Deserializer INSTANCE = new Deserializer();
        private static final class_793.class_795 BLOCK_MODEL_DESERIALIZER = new class_793.class_795();
        private static final ReflectedMethod<class_793.class_795, String> GET_PARENT = new ReflectedMethod(class_793.class_795.class, "getParentName", JsonObject.class);
        private static final ReflectedMethod<class_793.class_795, class_10419.class_10420> GET_TEXTURES = new ReflectedMethod(class_793.class_795.class, "getTextureMap", JsonObject.class);
        private static final ReflectedMethod<class_793.class_795, Boolean> GET_AMBIENT_OCCLUSION = new ReflectedMethod(class_793.class_795.class, "getAmbientOcclusion", JsonObject.class);

        public OpenBlockModel deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = element.getAsJsonObject();
            class_10820 geometry = this.createGeometry(context, object);
            class_2960 parent = this.parseParent(GET_PARENT.invoke(BLOCK_MODEL_DESERIALIZER, object));
            class_10419.class_10420 textures = GET_TEXTURES.invoke(BLOCK_MODEL_DESERIALIZER, object);
            Boolean ambientOcclusion = GET_AMBIENT_OCCLUSION.invoke(BLOCK_MODEL_DESERIALIZER, object);
            class_809 transforms = this.createTransforms(context, object);
            class_1100.class_4751 guiLight = this.createGuiLight(object);
            DataObject data = DataObject.convertNonNull(object.get("data"));
            return new OpenBlockModel(geometry, guiLight, ambientOcclusion, transforms, textures, parent, data);
        }

        @Nullable
        private class_10820 createGeometry(JsonDeserializationContext context, JsonObject object) {
            return OpenModelDeserializer.INSTANCE.method_3449(context, object);
        }

        @Nullable
        private class_809 createTransforms(JsonDeserializationContext context, JsonObject object) {
            if (object.has("display")) {
                JsonObject display = class_3518.method_15296((JsonObject)object, (String)"display");
                return (class_809)context.deserialize((JsonElement)display, class_809.class);
            }
            return null;
        }

        @Nullable
        private class_1100.class_4751 createGuiLight(JsonObject object) {
            return object.has("gui_light") ? class_1100.class_4751.method_24300((String)class_3518.method_15265((JsonObject)object, (String)"gui_light")) : null;
        }

        @Nullable
        private class_2960 parseParent(String parent) {
            return !parent.isBlank() ? class_2960.method_12829((String)parent) : null;
        }
    }
}

