/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.structure;

import com.google.common.collect.Lists;
import dev.worldgen.lithostitched.LithostitchedCommon;
import dev.worldgen.lithostitched.access.StructurePoolAccess;
import dev.worldgen.lithostitched.config.ConfigHandler;
import dev.worldgen.lithostitched.worldgen.poolelement.DelegatingPoolElement;
import dev.worldgen.lithostitched.worldgen.structure.AlternateJigsawConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_3748;
import net.minecraft.class_3777;
import net.minecraft.class_3780;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5468;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6626;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8891;
import net.minecraft.class_8917;
import net.minecraft.class_9822;
import org.apache.commons.lang3.mutable.MutableObject;

public class AlternateJigsawGenerator {
    public static Optional<class_3195.class_7150> generate(class_3195.class_7149 context, AlternateJigsawConfig config, boolean vanilla, int size, class_2338 pos, class_8891 aliasLookup) {
        class_5455 registries = context.comp_561();
        class_2794 chunkGenerator = context.comp_562();
        class_3485 structureTemplateManager = context.comp_565();
        class_5539 heightView = context.comp_569();
        class_2919 random = context.comp_566();
        class_2378 templatePoolRegistry = registries.method_30530(class_7924.field_41249);
        class_2470 rotation = class_2470.method_16548((class_5819)random);
        class_3784 startingElement = config.startPool().method_40230().flatMap(resourceKey -> templatePoolRegistry.method_31189(aliasLookup.lookup(resourceKey))).orElse((class_3785)config.startPool().comp_349()).method_16631((class_5819)random);
        if (startingElement == class_3777.field_16663) {
            return Optional.empty();
        }
        class_2338 blockPos = pos;
        Optional<class_2960> startJigsawName = config.startJigsawName();
        if (startJigsawName.isPresent()) {
            Optional<class_2338> optional = AlternateJigsawGenerator.findNamedJigsaw(startingElement, startJigsawName.get(), pos, rotation, structureTemplateManager, random);
            if (optional.isEmpty()) {
                LithostitchedCommon.LOGGER.error("No starting jigsaw {} found in start pool {}", (Object)startJigsawName.get(), (Object)config.startPool().method_40230().map(key -> key.method_29177().toString()).orElse("<unregistered>"));
                return Optional.empty();
            }
            blockPos = optional.get();
        }
        class_2338 vec3i = blockPos.method_10059((class_2382)pos);
        class_2338 blockPos2 = pos.method_10059((class_2382)vec3i);
        class_3790 poolStructurePiece = new class_3790(structureTemplateManager, startingElement, blockPos2, startingElement.method_19308(), rotation, startingElement.method_16628(structureTemplateManager, blockPos2, rotation), config.liquidSettings());
        class_3341 blockBox = poolStructurePiece.method_14935();
        int x = (blockBox.method_35418() + blockBox.method_35415()) / 2;
        int z = (blockBox.method_35420() + blockBox.method_35417()) / 2;
        int startHeight = config.projectStartToHeightmap().map(type -> pos.method_10264() + chunkGenerator.method_20402(x, z, type, heightView, context.comp_564())).orElseGet(() -> ((class_2338)blockPos2).method_10264());
        int l = blockBox.method_35416() + poolStructurePiece.method_16646();
        poolStructurePiece.method_14922(0, startHeight - l, 0);
        int y = startHeight + vec3i.method_10264();
        return Optional.of(new class_3195.class_7150(new class_2338(x, y, z), collector -> {
            ArrayList pieces = Lists.newArrayList();
            pieces.add(poolStructurePiece);
            if (size > 0) {
                int maxDistanceFromCenter = config.maxDistanceFromCenter();
                class_238 box = new class_238((double)(x - maxDistanceFromCenter), (double)Math.max(y - maxDistanceFromCenter, heightView.method_31607() + config.dimensionPadding().comp_2818()), (double)(z - maxDistanceFromCenter), (double)(x + maxDistanceFromCenter + 1), (double)Math.min(y + maxDistanceFromCenter + 1, heightView.method_31600() - config.dimensionPadding().comp_2819()), (double)(z + maxDistanceFromCenter + 1));
                class_265 voxelShape = class_259.method_1072((class_265)class_259.method_1078((class_238)box), (class_265)class_259.method_1078((class_238)class_238.method_19316((class_3341)blockBox)), (class_247)class_247.field_16886);
                AlternateJigsawGenerator.generate(context, vanilla, size, config.useExpansionHack(), chunkGenerator, structureTemplateManager, heightView, (class_5819)random, (class_2378<class_3785>)templatePoolRegistry, poolStructurePiece, pieces, voxelShape, aliasLookup, config.liquidSettings());
                Objects.requireNonNull(collector);
                pieces.forEach(arg_0 -> ((class_6626)collector).method_35462(arg_0));
            }
        }));
    }

    private static Optional<class_2338> findNamedJigsaw(class_3784 pool, class_2960 name, class_2338 pos, class_2470 rotation, class_3485 structureManager, class_2919 random) {
        List list = pool.method_16627(structureManager, pos, rotation, (class_5819)random);
        for (class_3499.class_10326 jigsawBlock : list) {
            if (!name.equals((Object)jigsawBlock.comp_3280())) continue;
            return Optional.of(jigsawBlock.comp_3278().comp_1341());
        }
        return Optional.empty();
    }

    private static void generate(class_3195.class_7149 context, boolean vanilla, int maxSize, boolean useExpansionHack, class_2794 chunkGenerator, class_3485 structureTemplateManager, class_5539 heightLimitView, class_5819 random, class_2378<class_3785> structurePoolRegistry, class_3790 firstPiece, List<class_3790> pieces, class_265 pieceShape, class_8891 aliasLookup, class_9822 liquidSettings) {
        StructurePoolGenerator generator = new StructurePoolGenerator(context, vanilla, structurePoolRegistry, maxSize, chunkGenerator, structureTemplateManager, pieces, random);
        generator.generatePiece(firstPiece, (MutableObject<class_265>)new MutableObject((Object)pieceShape), 0, useExpansionHack, heightLimitView, aliasLookup, liquidSettings);
        while (generator.pieces.hasNext()) {
            PieceState pieceState = (PieceState)generator.pieces.next();
            generator.generatePiece(pieceState.piece, pieceState.pieceShape, pieceState.depth, useExpansionHack, heightLimitView, aliasLookup, liquidSettings);
        }
    }

    static final class StructurePoolGenerator {
        private final class_3195.class_7149 context;
        private final boolean vanilla;
        private final class_2378<class_3785> registry;
        private final int maxSize;
        private final class_2794 chunkGenerator;
        private final class_3485 structureTemplateManager;
        private final List<? super class_3790> piecesToPlace;
        private final class_5819 random;
        private final Map<class_3784, Integer> groupCounts = new HashMap<class_3784, Integer>();
        final class_8917<PieceState> pieces = new class_8917();

        private StructurePoolGenerator(class_3195.class_7149 context, boolean vanilla, class_2378<class_3785> registry, int maxSize, class_2794 chunkGenerator, class_3485 structureTemplateManager, List<? super class_3790> children, class_5819 random) {
            this.context = context;
            this.vanilla = vanilla;
            this.registry = registry;
            this.maxSize = maxSize;
            this.chunkGenerator = chunkGenerator;
            this.structureTemplateManager = structureTemplateManager;
            this.piecesToPlace = children;
            this.random = random;
        }

        private void generatePiece(class_3790 parentPiece, MutableObject<class_265> voxelShape, int depth, boolean useExpansionHack, class_5539 world, class_8891 aliasLookup, class_9822 liquidSettings) {
            class_3784 anchorElement = parentPiece.method_16644();
            class_3341 parentBoundingBox = parentPiece.method_14935();
            MutableObject<class_265> parentShape = new MutableObject<class_265>();
            for (class_3499.class_10326 anchorJigsaw : anchorElement.method_16627(this.structureTemplateManager, parentPiece.method_16648(), parentPiece.method_16888(), this.random)) {
                MutableObject<class_265> childShape;
                class_3499.class_3501 anchorInfo = anchorJigsaw.comp_3278();
                class_2338 candidateConnectorPos = StructurePoolGenerator.adjustJigsawPos(anchorInfo);
                class_6880<class_3785> poolEntry = this.getTemplatePoolHolder((class_5321<class_3785>)aliasLookup.lookup(anchorJigsaw.comp_3281()));
                if (poolEntry == null) continue;
                boolean connectorInParentBoundingBox = parentBoundingBox.method_14662((class_2382)candidateConnectorPos);
                if (connectorInParentBoundingBox) {
                    childShape = parentShape;
                    if (parentShape.getValue() == null) {
                        parentShape.setValue((Object)class_259.method_1078((class_238)class_238.method_19316((class_3341)parentBoundingBox)));
                    }
                } else {
                    childShape = voxelShape;
                }
                MutableObject checkedPools = new MutableObject(new ArrayList());
                this.findAndTestChildCandidates(poolEntry, (MutableObject<List<class_5321<class_3785>>>)checkedPools, parentPiece, anchorJigsaw, childShape, -1, depth, useExpansionHack, world, true, aliasLookup, liquidSettings);
            }
        }

        private void findAndTestChildCandidates(class_6880<class_3785> entry, MutableObject<List<class_5321<class_3785>>> checkedPools, class_3790 parentPiece, class_3499.class_10326 anchorJigsawInfo, MutableObject<class_265> mutableObject2, int k, int depth, boolean useExpansionHack, class_5539 world, boolean firstIteration, class_8891 aliasLookup, class_9822 liquidSettings) {
            List<class_3784> childCandidates = this.getPoolElements((class_5321<class_3785>)entry.method_40230().orElse(class_5468.field_26254), checkedPools, depth, firstIteration);
            if (childCandidates.isEmpty()) {
                return;
            }
            boolean foundChild = this.findValidChildPiece(childCandidates, parentPiece, anchorJigsawInfo, mutableObject2, k, depth, useExpansionHack, world, aliasLookup, liquidSettings);
            if (!foundChild) {
                this.findAndTestChildCandidates((class_6880<class_3785>)((class_3785)entry.comp_349()).method_46736(), checkedPools, parentPiece, anchorJigsawInfo, mutableObject2, k, depth, useExpansionHack, world, false, aliasLookup, liquidSettings);
            }
        }

        private List<class_3784> getPoolElements(class_5321<class_3785> poolKey, MutableObject<List<class_5321<class_3785>>> checkedPools, int depth, boolean firstIteration) {
            if (poolKey == class_5468.field_26254) {
                return List.of();
            }
            if (ConfigHandler.getConfig().breaksSeedParity() || !this.vanilla) {
                if (((List)checkedPools.getValue()).contains(poolKey)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (class_5321 checkedPoolKey : (List)checkedPools.getValue()) {
                        stringBuilder.append(checkedPoolKey.method_29177()).append(" -> ");
                    }
                    stringBuilder.append(poolKey.method_29177());
                    LithostitchedCommon.debug("Template pool fallback chain found: {}", stringBuilder);
                    return List.of();
                }
                ((List)checkedPools.getValue()).add(poolKey);
                class_6880 pool = (class_6880)this.registry.method_46746(poolKey).orElseThrow();
                if (depth == this.maxSize && firstIteration) {
                    pool = ((class_3785)pool.comp_349()).method_46736();
                }
                return ((StructurePoolAccess)pool.comp_349()).getLithostitchedTemplates().shuffle(this.random);
            }
            if (!firstIteration) {
                return List.of();
            }
            class_6880 pool = (class_6880)this.registry.method_46746(poolKey).orElseThrow();
            class_6880 fallback = ((class_3785)pool.comp_349()).method_46736();
            ArrayList<class_3784> elements = new ArrayList<class_3784>();
            if (depth != this.maxSize) {
                elements.addAll(((class_3785)pool.comp_349()).method_16633(this.random));
            }
            elements.addAll(((class_3785)fallback.comp_349()).method_16633(this.random));
            return elements;
        }

        private boolean findValidChildPiece(List<class_3784> elements, class_3790 parentPiece, class_3499.class_10326 anchorJigsaw, MutableObject<class_265> mutableObject2, int k, int depth, boolean useExpansionHack, class_5539 world, class_8891 aliasLookup, class_9822 liquidSettings) {
            class_3499.class_3501 anchorInfo = anchorJigsaw.comp_3278();
            class_2338 anchorPos = anchorInfo.comp_1341();
            class_2338 candidateConnectorPos = StructurePoolGenerator.adjustJigsawPos(anchorInfo);
            int parentMinY = parentPiece.method_14935().method_35416();
            int anchorDistanceToFloor = anchorPos.method_10264() - parentMinY;
            class_3785.class_3786 parentProjection = parentPiece.method_16644().method_16624();
            boolean parentRigid = parentProjection == class_3785.class_3786.field_16687;
            for (class_3784 element : elements) {
                DelegatingPoolElement delegating;
                if (element == class_3777.field_16663) {
                    return true;
                }
                if (element instanceof DelegatingPoolElement && !(delegating = (DelegatingPoolElement)element).config().isPlacementValid(this.context, candidateConnectorPos, depth, this.groupCounts.getOrDefault((Object)delegating, 0))) continue;
                for (class_2470 rotation : class_2470.method_16547((class_5819)this.random)) {
                    List connectorJigsaws = element.method_16627(this.structureTemplateManager, class_2338.field_10980, rotation, this.random);
                    class_3341 connectorBoundingBox = element.method_16628(this.structureTemplateManager, class_2338.field_10980, rotation);
                    int l = useExpansionHack && connectorBoundingBox.method_14660() <= 16 ? connectorJigsaws.stream().mapToInt(jigsawInfo -> {
                        class_3499.class_3501 blockInfo = jigsawInfo.comp_3278();
                        if (!connectorBoundingBox.method_14662((class_2382)StructurePoolGenerator.adjustJigsawPos(blockInfo))) {
                            return 0;
                        }
                        class_5321 registryKey2 = aliasLookup.lookup(jigsawInfo.comp_3281());
                        Optional optional1 = this.registry.method_46746(registryKey2);
                        Optional<class_6880> optional2 = optional1.map(entry -> ((class_3785)entry.comp_349()).method_46736());
                        int i2 = optional1.map(entry -> ((class_3785)entry.comp_349()).method_19309(this.structureTemplateManager)).orElse(0);
                        int j2 = optional2.map(entry -> ((class_3785)entry.comp_349()).method_19309(this.structureTemplateManager)).orElse(0);
                        return Math.max(i2, j2);
                    }).max().orElse(0) : 0;
                    for (class_3499.class_10326 connectorJigsawInfo : connectorJigsaws) {
                        int t;
                        int r;
                        int p;
                        if (!class_3748.method_16546((class_3499.class_10326)anchorJigsaw, (class_3499.class_10326)connectorJigsawInfo)) continue;
                        class_2338 connectorPos = connectorJigsawInfo.comp_3278().comp_1341();
                        class_2338 blockPos5 = candidateConnectorPos.method_10059((class_2382)connectorPos);
                        class_3341 blockBox3 = element.method_16628(this.structureTemplateManager, blockPos5, rotation);
                        int m = blockBox3.method_35416();
                        class_3785.class_3786 connectorProjection = element.method_16624();
                        boolean connectorProjectionRigid = connectorProjection == class_3785.class_3786.field_16687;
                        int connectorY = connectorPos.method_10264();
                        int o = anchorDistanceToFloor - connectorY + class_3748.method_26378((class_2680)anchorInfo.comp_1342()).method_10164();
                        if (parentRigid && connectorProjectionRigid) {
                            p = parentMinY + o;
                        } else {
                            if (k == -1) {
                                k = this.chunkGenerator.method_20402(anchorPos.method_10263(), anchorPos.method_10260(), class_2902.class_2903.field_13194, world, this.context.comp_564());
                            }
                            p = k - connectorY;
                        }
                        int q = p - m;
                        class_3341 blockBox4 = blockBox3.method_19311(0, q, 0);
                        class_2338 blockPos6 = blockPos5.method_10069(0, q, 0);
                        if (l > 0) {
                            r = Math.max(l + 1, blockBox4.method_35419() - blockBox4.method_35416());
                            blockBox4.method_34389(new class_2338(blockBox4.method_35415(), blockBox4.method_35416() + r, blockBox4.method_35417()));
                        }
                        if (class_259.method_1074((class_265)((class_265)mutableObject2.getValue()), (class_265)class_259.method_1078((class_238)class_238.method_19316((class_3341)blockBox4).method_1011(0.25)), (class_247)class_247.field_16893)) continue;
                        if (element instanceof DelegatingPoolElement) {
                            DelegatingPoolElement delegating2 = (DelegatingPoolElement)element;
                            this.groupCounts.put(delegating2, this.groupCounts.getOrDefault((Object)delegating2, 0) + 1);
                        }
                        mutableObject2.setValue((Object)class_259.method_1082((class_265)((class_265)mutableObject2.getValue()), (class_265)class_259.method_1078((class_238)class_238.method_19316((class_3341)blockBox4)), (class_247)class_247.field_16886));
                        r = parentPiece.method_16646();
                        int s = connectorProjectionRigid ? r - o : element.method_19308();
                        class_3790 poolStructurePiece = new class_3790(this.structureTemplateManager, element, blockPos6, s, rotation, blockBox4, liquidSettings);
                        if (parentRigid) {
                            t = parentMinY + anchorDistanceToFloor;
                        } else if (connectorProjectionRigid) {
                            t = p + connectorY;
                        } else {
                            if (k == -1) {
                                k = this.chunkGenerator.method_20402(anchorPos.method_10263(), anchorPos.method_10260(), class_2902.class_2903.field_13194, world, this.context.comp_564());
                            }
                            t = k + o / 2;
                        }
                        parentPiece.method_16647(new class_3780(candidateConnectorPos.method_10263(), t - anchorDistanceToFloor + r, candidateConnectorPos.method_10260(), o, connectorProjection));
                        poolStructurePiece.method_16647(new class_3780(anchorPos.method_10263(), t - connectorY + s, anchorPos.method_10260(), -o, parentProjection));
                        this.piecesToPlace.add((class_3790)poolStructurePiece);
                        if (depth + 1 <= this.maxSize) {
                            PieceState pieceState = new PieceState(poolStructurePiece, mutableObject2, depth + 1);
                            this.pieces.method_54726((Object)pieceState, anchorJigsaw.comp_3283());
                        }
                        return true;
                    }
                }
            }
            return false;
        }

        private class_6880<class_3785> getTemplatePoolHolder(class_5321<class_3785> key) {
            Optional optional = this.registry.method_46746(key);
            if (optional.isEmpty()) {
                LithostitchedCommon.LOGGER.warn("Couldn't find template pool reference: {}", (Object)key.method_29177());
            } else {
                class_6880 regularPool = (class_6880)optional.get();
                if (((class_3785)regularPool.comp_349()).method_16632() == 0) {
                    if (!regularPool.method_40225(class_5468.field_26254)) {
                        LithostitchedCommon.LOGGER.warn("Referenced template pool is empty: {}", (Object)key.method_29177());
                    }
                } else {
                    return regularPool;
                }
            }
            return null;
        }

        private static class_2338 adjustJigsawPos(class_3499.class_3501 jigsawInfo) {
            return jigsawInfo.comp_1341().method_10093(class_3748.method_26378((class_2680)jigsawInfo.comp_1342()));
        }
    }

    private record PieceState(class_3790 piece, MutableObject<class_265> pieceShape, int depth) {
    }
}

