/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.mixin.common.SinglePoolElementAccessor;
import dev.worldgen.lithostitched.mixin.common.StructureTemplatePoolAccessor;
import dev.worldgen.lithostitched.worldgen.LithostitchedCodecs;
import dev.worldgen.lithostitched.worldgen.modifier.Modifier;
import dev.worldgen.lithostitched.worldgen.poolelement.DelegatingPoolElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3781;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3828;
import net.minecraft.class_5497;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;

public record SetPoolElementProcessorsModifier(class_6885<class_3785> templatePools, Optional<List<class_2960>> locations, class_6880<class_5497> processorList, boolean append) implements Modifier
{
    public static final MapCodec<SetPoolElementProcessorsModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LithostitchedCodecs.registrySet(class_7924.field_41249, "template_pools").forGetter(SetPoolElementProcessorsModifier::templatePools), (App)class_5699.method_65313((Codec)class_2960.field_25139).optionalFieldOf("locations").forGetter(SetPoolElementProcessorsModifier::locations), (App)class_3828.field_25877.fieldOf("processor_list").forGetter(SetPoolElementProcessorsModifier::processorList), (App)Codec.BOOL.fieldOf("append").orElse((Object)true).forGetter(SetPoolElementProcessorsModifier::append)).apply((Applicative)instance, SetPoolElementProcessorsModifier::new));

    @Override
    public void applyModifier() {
        for (class_6880 templatePool : this.templatePools) {
            StructureTemplatePoolAccessor pool = (StructureTemplatePoolAccessor)templatePool.comp_349();
            for (class_3784 element : pool.getRawTemplates().stream().map(Pair::getFirst).toList()) {
                this.applyModifier(element);
            }
        }
    }

    private void applyModifier(class_3784 element) {
        if (element instanceof class_3781) {
            SinglePoolElementAccessor accessor = (SinglePoolElementAccessor)element;
            Optional template = accessor.getTemplate().left();
            if (this.locations.isEmpty() || template.isPresent() && this.locations.get().contains(template.get())) {
                this.addProcessor(accessor);
            }
        } else if (element instanceof DelegatingPoolElement) {
            DelegatingPoolElement delegating = (DelegatingPoolElement)element;
            this.applyModifier(delegating.delegate());
        }
    }

    private void addProcessor(SinglePoolElementAccessor element) {
        ArrayList processors = new ArrayList();
        if (this.append) {
            processors.addAll(((class_5497)element.getProcessors().comp_349()).method_31027());
        }
        processors.addAll(((class_5497)this.processorList.comp_349()).method_31027());
        element.setProcessors((class_6880<class_5497>)class_6880.method_40223((Object)new class_5497(processors)));
    }

    @Override
    public Modifier.ModifierPhase getPhase() {
        return this.append ? Modifier.ModifierPhase.REPLACE : Modifier.ModifierPhase.ADD;
    }

    @Override
    public MapCodec<? extends Modifier> codec() {
        return CODEC;
    }
}

