/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.feature;

import dev.worldgen.lithostitched.LithostitchedCommon;
import dev.worldgen.lithostitched.worldgen.feature.config.DungeonConfig;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1299;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3443;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class DungeonFeature
extends class_3031<DungeonConfig> {
    public static final DungeonFeature FEATURE = new DungeonFeature();

    public DungeonFeature() {
        super(DungeonConfig.CODEC);
    }

    public boolean method_13151(class_5821<DungeonConfig> context) {
        class_2338 currentPos;
        int z;
        int y;
        int x;
        class_2338 startPos = context.method_33655();
        class_5819 random = context.method_33654();
        class_5281 world = context.method_33652();
        DungeonConfig config = (DungeonConfig)context.method_33656();
        Predicate<class_2680> predicate = state -> !state.method_26164(config.dungeonInvalidBlocks());
        int xRadius = config.radius().method_35008(random);
        int minX = -xRadius - 1;
        int maxX = xRadius + 1;
        int zRadius = config.radius().method_35008(random);
        int minZ = -zRadius - 1;
        int maxZ = zRadius + 1;
        int openings = 0;
        for (x = minX; x <= maxX; ++x) {
            for (y = -1; y <= 4; ++y) {
                for (z = minZ; z <= maxZ; ++z) {
                    currentPos = startPos.method_10069(x, y, z);
                    boolean bl = world.method_8320(currentPos).method_51367();
                    if (y == -1 && !bl) {
                        return false;
                    }
                    if (y == 4 && !bl) {
                        return false;
                    }
                    if (x != minX && x != maxX && z != minZ && z != maxZ || y != 0 || !world.method_22347(currentPos) || !world.method_22347(currentPos.method_10084())) continue;
                    ++openings;
                }
            }
        }
        if (openings >= config.minOpenings() && openings <= config.maxOpenings()) {
            for (x = minX; x <= maxX; ++x) {
                for (y = 3; y >= -1; --y) {
                    for (z = minZ; z <= maxZ; ++z) {
                        currentPos = startPos.method_10069(x, y, z);
                        class_2680 currentState = world.method_8320(currentPos);
                        if (x != minX && y != -1 && z != minZ && x != maxX && y != 4 && z != maxZ) {
                            if (currentState.method_27852(class_2246.field_10034) || currentState.method_27852(class_2246.field_10260)) continue;
                            this.method_36998(world, currentPos, class_2246.field_10543.method_9564(), predicate);
                            continue;
                        }
                        if (currentPos.method_10264() >= world.method_31607() && !world.method_8320(currentPos.method_10074()).method_51367()) {
                            world.method_8652(currentPos, class_2246.field_10543.method_9564(), 2);
                            continue;
                        }
                        if (!currentState.method_51367() || currentState.method_27852(class_2246.field_10034)) continue;
                        this.method_36998(world, currentPos, y == -1 ? config.floorProvider().method_23455(random, currentPos) : config.wallProvider().method_23455(random, currentPos), predicate);
                    }
                }
            }
            block6: for (x = 0; x < config.maxChests(); ++x) {
                for (y = 0; y < 3; ++y) {
                    int w;
                    int v;
                    z = startPos.method_10263() + random.method_43048(xRadius * 2 + 1) - xRadius;
                    class_2338 chestPos = new class_2338(z, v = startPos.method_10264(), w = startPos.method_10260() + random.method_43048(zRadius * 2 + 1) - zRadius);
                    if (!world.method_22347(chestPos)) continue;
                    int solidFaces = 0;
                    for (class_2350 direction : class_2350.class_2353.field_11062) {
                        if (!world.method_8320(chestPos.method_10093(direction)).method_51367()) continue;
                        ++solidFaces;
                    }
                    if (solidFaces != true) continue;
                    this.method_36998(world, chestPos, class_3443.method_14916((class_1922)world, (class_2338)chestPos, (class_2680)class_2246.field_10034.method_9564()), predicate);
                    Optional chestEntity = world.method_35230(chestPos, class_2591.field_11914);
                    chestEntity.ifPresent(chestBlockEntity -> chestBlockEntity.method_54867(config.lootTable(), random.method_43055()));
                    continue block6;
                }
            }
            this.method_36998(world, startPos, class_2246.field_10260.method_9564(), predicate);
            class_2586 blockEntity = world.method_8321(startPos);
            if (blockEntity instanceof class_2636) {
                class_2636 spawner = (class_2636)blockEntity;
                spawner.method_46408(config.spawnerMobs().method_34992(random).orElse(class_1299.field_6093), random);
            } else {
                LithostitchedCommon.LOGGER.error(String.format("Failed to get spawner block entity for dungeon at block position (%s)", startPos));
            }
            return true;
        }
        return false;
    }
}

