/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.core;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.core.ICreativeRegistry;
import team.creative.creativecore.common.config.holder.ConfigHolderObject;
import team.creative.creativecore.common.util.type.TriPredicate;

public class ConfigEqualChecker {
    private final HashMap<Class, TriPredicate<Object, Object, Side>> checkers = new HashMap();

    public TriPredicate<Object, Object, Side> register(Class clazz, ICreativeRegistry registry) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ConfigHolderObject.collectFields(clazz, fields, registry);
        TriPredicate<Object, Object, Side> result = (x, y, side) -> {
            if (fields.isEmpty()) {
                return true;
            }
            for (int i = 0; i < fields.size(); ++i) {
                Field field = (Field)fields.get(i);
                if (!registry.is(field, (Side)((Object)side))) continue;
                try {
                    if (this.equals(field.get(x), field.get(y), (Side)((Object)side), registry)) continue;
                    return false;
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    CreativeCore.LOGGER.error("Could not check equals on object with class " + String.valueOf(clazz), (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            return true;
        };
        this.checkers.put(clazz, result);
        return result;
    }

    public boolean equals(Object one, Object two, Side side, ICreativeRegistry registry) {
        if (Objects.equals(one, two)) {
            return true;
        }
        if (one == null || two == null) {
            return false;
        }
        if (one.getClass() != two.getClass()) {
            return false;
        }
        TriPredicate<Object, Object, Side> check = this.checkers.get(one.getClass());
        if (check == null) {
            check = this.register(one.getClass(), registry);
        }
        if (check != null) {
            return check.test(one, two, side);
        }
        return false;
    }
}

