/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.render.text;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_327;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class DebugTextRenderer {
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.##");
    protected final List<String> lines = new ArrayList<String>();

    private static String format(Object value) {
        if (value instanceof Double || value instanceof Float) {
            return DECIMAL_FORMAT.format(value);
        }
        return value.toString();
    }

    public DebugTextRenderer() {
        this.lines.add("");
    }

    public DebugTextRenderer text(String text) {
        this.lines.set(this.lines.size() - 1, this.lines.get(this.lines.size() - 1) + text);
        return this;
    }

    public DebugTextRenderer detail(String name, Object value) {
        StringBuilder lastLine = new StringBuilder(this.lines.get(this.lines.size() - 1));
        if (!lastLine.isEmpty()) {
            lastLine.append(",");
        }
        if (name.isEmpty()) {
            lastLine.append(DebugTextRenderer.format(value));
        } else {
            lastLine.append(String.valueOf(class_124.field_1054) + name + String.valueOf(class_124.field_1070) + ":" + DebugTextRenderer.format(value));
        }
        this.lines.set(this.lines.size() - 1, lastLine.toString());
        return this;
    }

    public DebugTextRenderer newLine() {
        this.lines.add("");
        return this;
    }

    public void render(class_327 font, class_332 graphics) {
        int top = 2;
        for (String msg : this.lines) {
            if (msg != null && !msg.isEmpty()) {
                int n = 2 + font.method_1727(msg) + 1;
                Objects.requireNonNull(font);
                graphics.method_25294(1, top - 1, n, top + 9 - 1, -1873784752);
                graphics.method_51433(font, msg, 2, top, 0xE0E0E0, false);
            }
            Objects.requireNonNull(font);
            top += 9;
        }
    }
}

