/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.justhammers;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.utils.value.IntValue;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_9334;
import net.minecraft.class_9424;
import net.minecraft.class_9886;
import pro.mikey.justhammers.HammerTags;
import pro.mikey.justhammers.HammersPlatform;
import pro.mikey.justhammers.config.SimpleJsonConfig;

public class HammerItem
extends class_1792 {
    private final int depth;
    private final int radius;

    public HammerItem(class_1792.class_1793 rootProperties, class_9886 tier, int radius, int depth, int level) {
        super(HammerItem.computeProperties(tier, rootProperties, level));
        this.depth = depth;
        this.radius = radius;
    }

    private static class_1792.class_1793 computeProperties(class_9886 tier, class_1792.class_1793 properties, int level) {
        properties.method_66330(HammerItem.wrapMaterial(tier, HammerItem.computeDurability(tier, level)), 1.0f, -2.8f);
        if (tier == class_9886.field_52590) {
            properties.method_24359();
        }
        return properties;
    }

    public void method_67187(class_1799 itemStack, class_1792.class_9635 tooltipContext, class_10712 tooltipDisplay, Consumer<class_2561> consumer, class_1836 tooltipFlag) {
        consumer.accept((class_2561)class_2561.method_43469((String)"justhammers.tooltip.size", (Object[])new Object[]{this.radius, this.radius, this.depth}).method_27692(class_124.field_1080));
        if (SimpleJsonConfig.INSTANCE.disabledDurabilityTooltip.get().getAsBoolean()) {
            return;
        }
        int damage = Math.max(0, itemStack.method_7919());
        int maxDamage = itemStack.method_7936();
        int durabilityPercentage = (int)((float)(maxDamage - damage) / (float)maxDamage * 100.0f);
        class_124 color = class_124.field_1060;
        if (durabilityPercentage <= 50) {
            color = durabilityPercentage <= 25 ? class_124.field_1061 : class_124.field_1054;
        }
        int remaining = Math.max(0, durabilityPercentage / 20);
        class_5250 percentComponent = class_2561.method_43470((String)(HammerItem.prettyDurability(damage) + "/" + HammerItem.prettyDurability(maxDamage) + " ")).method_10852((class_2561)class_2561.method_43470((String)"*".repeat(remaining)).method_27692(color)).method_10852((class_2561)class_2561.method_43470((String)"*".repeat(5 - remaining)).method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)(" (" + durabilityPercentage + "%)")).method_27692(class_124.field_1080));
        consumer.accept((class_2561)percentComponent);
    }

    private static String prettyDurability(int durability) {
        String output;
        int unitIndex;
        String[] units = new String[]{"", "k", "m"};
        double displayDurability = durability;
        int n = unitIndex = durability > 0 ? (int)(Math.log10(durability) / 3.0) : 0;
        if (unitIndex >= units.length) {
            unitIndex = units.length - 1;
        }
        if ((output = String.format("%.2f", displayDurability /= Math.pow(1000.0, unitIndex))).endsWith(".00")) {
            output = output.substring(0, output.length() - 3);
        }
        return output + units[unitIndex];
    }

    private static int computeDurability(class_9886 tier, int level) {
        int baseModified = 0;
        if (level > 1) {
            baseModified = class_9886.field_52590.comp_2931();
        }
        return baseModified + ((int)((float)tier.comp_2931() * 2.5f) + 200 * level) * level;
    }

    public float method_58404(class_1799 itemStack, class_2680 blockState) {
        if (SimpleJsonConfig.INSTANCE.allowHammerBreaking.get().getAsBoolean()) {
            return super.method_58404(itemStack, blockState);
        }
        if (itemStack.method_7936() - itemStack.method_7919() <= 1) {
            return -1.0f;
        }
        return super.method_58404(itemStack, blockState);
    }

    public void causeAoe(class_1937 level, class_2338 pos, class_2680 state, class_1799 hammer, class_1309 livingEntity) {
        if (!(livingEntity instanceof class_3222)) {
            return;
        }
        if (level.field_9236 || state.method_26214((class_1922)level, pos) == 0.0f) {
            return;
        }
        if (livingEntity.method_18276()) {
            return;
        }
        class_239 pick = livingEntity.method_5745(20.0, 0.0f, false);
        if (!(pick instanceof class_3965)) {
            return;
        }
        class_3965 blockHitResult = (class_3965)pick;
        this.findAndBreakNearBlocks(blockHitResult, pos, hammer, level, livingEntity);
    }

    public void findAndBreakNearBlocks(class_3965 pick, class_2338 blockPos, class_1799 hammerStack, class_1937 level, class_1309 livingEntity) {
        if (!(livingEntity instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)livingEntity;
        class_2350 direction = pick.method_17780();
        class_3341 boundingBox = HammerItem.getAreaOfEffect(blockPos, direction, this.radius, this.depth);
        if (!player.method_68878() && hammerStack.method_7919() >= hammerStack.method_7936() - 1) {
            return;
        }
        int damage = 0;
        Iterator iterator = class_2338.method_23627((class_3341)boundingBox).iterator();
        HashSet<class_2338> removedPos = new HashSet<class_2338>();
        while (iterator.hasNext()) {
            boolean correctToolForDrops;
            boolean correctForDrops;
            class_9424 toolComponent;
            boolean isBroken;
            class_2338 pos = (class_2338)iterator.next();
            if (pick.method_17777().equals((Object)pos)) continue;
            boolean bl = isBroken = hammerStack.method_7919() + (damage + 1) >= hammerStack.method_7936() - 1;
            if (SimpleJsonConfig.INSTANCE.allowHammerBreaking.get().getAsBoolean()) {
                boolean bl2 = isBroken = hammerStack.method_7919() + (damage + 1) >= hammerStack.method_7936();
            }
            if (!player.method_68878() && isBroken) break;
            class_2680 targetState = level.method_8320(pos);
            if (pos == blockPos || removedPos.contains(pos) || !this.canDestroy(targetState, level, pos) || (toolComponent = (class_9424)hammerStack.method_58694(class_9334.field_50077)) == null || !(correctForDrops = toolComponent.method_58426(targetState)) || targetState.method_26164(HammerTags.HAMMER_NO_SMASHY)) continue;
            final int[] xp = new int[]{HammersPlatform.getBlockXpAmount(pos, targetState, level, (class_1297)livingEntity, hammerStack)};
            EventResult eventResult = ((BlockEvent.Break)BlockEvent.BREAK.invoker()).breakBlock(level, pos, targetState, (class_3222)livingEntity, xp[0] == -1 ? null : new IntValue(){

                public void accept(int value) {
                    xp[0] = value;
                }

                public int getAsInt() {
                    return xp[0];
                }
            });
            if (eventResult.isFalse()) continue;
            int outputXpLevel = xp[0];
            if (!player.method_68878() && (correctToolForDrops = player.method_7305(targetState))) {
                targetState.method_26180((class_3218)level, pos, hammerStack, true);
                List drops = class_2248.method_9609((class_2680)targetState, (class_3218)((class_3218)level), (class_2338)pos, (class_2586)level.method_8321(pos), (class_1297)livingEntity, (class_1799)hammerStack);
                List<class_1542> dropEntities = drops.stream().map(e -> new class_1542(level, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), e)).toList();
                boolean result = HammersPlatform.blockDropsEvent((class_3218)level, pos, targetState, level.method_8321(pos), dropEntities, (class_1297)livingEntity, hammerStack);
                if (!result) {
                    drops.forEach(e -> class_2248.method_36992((class_1937)level, (class_2338)pos, (class_2350)pick.method_17780(), (class_1799)e));
                }
                if (outputXpLevel != -1 && ((class_3218)level).method_64395().method_8355(class_1928.field_19392)) {
                    class_1303.method_31493((class_3218)((class_3218)level), (class_243)class_243.method_24953((class_2382)blockPos), (int)outputXpLevel);
                }
            }
            removedPos.add(pos);
            targetState.method_26204().method_9585((class_1936)level, pos, targetState);
            class_2680 newState = class_2246.field_10124.method_9564();
            boolean setResult = level.method_8652(pos, newState, 3);
            if (setResult) {
                level.method_43276((class_6880)class_5712.field_28165, blockPos, class_5712.class_7397.method_43286((class_1297)livingEntity, (class_2680)newState));
            }
            ++damage;
        }
        if (damage != 0 && !player.method_68878()) {
            hammerStack.method_7970(damage, livingEntity, class_1304.field_6173);
        }
    }

    public static class_3341 getAreaOfEffect(class_2338 blockPos, class_2350 direction, int radius, int depth) {
        int size = radius / 2;
        int offset = size - 1;
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11033, class_2350.field_11036 -> new class_3341(blockPos.method_10263() - size, blockPos.method_10264() - (direction == class_2350.field_11036 ? depth - 1 : 0), blockPos.method_10260() - size, blockPos.method_10263() + size, blockPos.method_10264() + (direction == class_2350.field_11033 ? depth - 1 : 0), blockPos.method_10260() + size);
            case class_2350.field_11043, class_2350.field_11035 -> new class_3341(blockPos.method_10263() - size, blockPos.method_10264() - size + offset, blockPos.method_10260() - (direction == class_2350.field_11035 ? depth - 1 : 0), blockPos.method_10263() + size, blockPos.method_10264() + size + offset, blockPos.method_10260() + (direction == class_2350.field_11043 ? depth - 1 : 0));
            case class_2350.field_11039, class_2350.field_11034 -> new class_3341(blockPos.method_10263() - (direction == class_2350.field_11034 ? depth - 1 : 0), blockPos.method_10264() - size + offset, blockPos.method_10260() - size, blockPos.method_10263() + (direction == class_2350.field_11039 ? depth - 1 : 0), blockPos.method_10264() + size + offset, blockPos.method_10260() + size);
        };
    }

    private boolean canDestroy(class_2680 targetState, class_1937 level, class_2338 pos) {
        if (targetState.method_26214((class_1922)level, pos) <= 0.0f) {
            return false;
        }
        if (targetState.method_26164(HammerTags.HAMMER_NO_SMASHY)) {
            return false;
        }
        return level.method_8321(pos) == null;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getRadius() {
        return this.radius;
    }

    private static class_9886 wrapMaterial(class_9886 toolMaterial, int durability) {
        return new class_9886(toolMaterial.comp_2930(), durability, toolMaterial.comp_2932(), toolMaterial.comp_2933(), toolMaterial.comp_2934(), toolMaterial.comp_2935());
    }
}

