/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.core;

import com.google.common.collect.Queues;
import fuzs.puzzleslib.api.capability.v3.CapabilityController;
import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.core.v1.utility.Buildable;
import fuzs.puzzleslib.api.init.v3.registry.RegistryManager;
import fuzs.puzzleslib.impl.core.ModListConfigurationTask;
import fuzs.puzzleslib.impl.core.proxy.ProxyImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.class_8605;
import net.minecraft.class_8610;
import net.minecraft.class_8735;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public abstract class ModContext {
    private static final Map<String, ModContext> MOD_CONTEXTS = new ConcurrentHashMap<String, ModContext>();
    protected final String modId;
    private final Queue<Buildable> buildables = Queues.newConcurrentLinkedQueue();
    @Nullable
    protected RegistryManager registryManager;
    @Nullable
    protected CapabilityController capabilityController;
    private boolean presentServerside = ModLoaderEnvironment.INSTANCE.isServer();

    protected ModContext(String modId) {
        this.modId = modId;
    }

    public static void onRegisterConfigurationTasks(MinecraftServer minecraftServer, class_8610 listener, Consumer<class_8605> configurationTaskConsumer) {
        configurationTaskConsumer.accept(new ModListConfigurationTask((class_8735)listener));
    }

    public static void onLoadComplete() {
        for (ModContext context : MOD_CONTEXTS.values()) {
            if (context.buildables.isEmpty()) continue;
            throw new IllegalStateException("Mod context for %s has %s remaining buildable(s)".formatted(context.modId, context.buildables.size()));
        }
    }

    public static void clearPresentServerside() {
        for (ModContext context : MOD_CONTEXTS.values()) {
            context.presentServerside = false;
        }
    }

    public static Collection<String> getModList() {
        return Collections.unmodifiableSet(MOD_CONTEXTS.keySet());
    }

    public static ModContext get(String modId) {
        return MOD_CONTEXTS.computeIfAbsent(modId, ProxyImpl.get()::getModContext);
    }

    public static void acceptServersideMods(Collection<String> modList) {
        modList.stream().map(MOD_CONTEXTS::get).filter(Objects::nonNull).forEach(context -> {
            context.presentServerside = true;
        });
    }

    public static boolean isPresentServerside(String modId) {
        return MOD_CONTEXTS.containsKey(modId) && ModContext.MOD_CONTEXTS.get((Object)modId).presentServerside;
    }

    public abstract ConfigHolder.Builder getConfigHolder();

    public abstract RegistryManager getRegistryManager();

    public abstract CapabilityController getCapabilityController();

    protected <T extends Buildable> T addBuildable(T buildable) {
        Objects.requireNonNull(buildable, "buildable is null");
        this.buildables.offer(buildable);
        return buildable;
    }

    public final void buildAll() {
        while (!this.buildables.isEmpty()) {
            this.buildables.poll().build();
        }
    }
}

