/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.fabric.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Cancellable;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.DefaultedFloat;
import fuzs.puzzleslib.api.event.v1.data.DefaultedValue;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingDeathCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.PickProjectileCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.BreakSpeedCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.ItemEntityEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerTickEvents;
import fuzs.puzzleslib.fabric.api.event.v1.FabricLivingEvents;
import fuzs.puzzleslib.fabric.api.event.v1.FabricPlayerEvents;
import fuzs.puzzleslib.fabric.impl.event.FabricEventImplHelper;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
abstract class PlayerFabricMixin
extends class_1309 {
    protected PlayerFabricMixin(class_1299<? extends class_1309> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tick$0(CallbackInfo callback) {
        ((PlayerTickEvents.Start)FabricPlayerEvents.PLAYER_TICK_START.invoker()).onStartPlayerTick((class_1657)class_1657.class.cast((Object)this));
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick$1(CallbackInfo callback) {
        ((PlayerTickEvents.End)FabricPlayerEvents.PLAYER_TICK_END.invoker()).onEndPlayerTick((class_1657)class_1657.class.cast((Object)this));
    }

    @Inject(method={"drop"}, at={@At(value="HEAD")}, cancellable=true)
    public void drop(class_1799 itemStack, boolean includeThrowerName, CallbackInfoReturnable<class_1542> callback) {
        if (!class_3222.class.isInstance((Object)this)) {
            return;
        }
        EventResult eventResult = ((ItemEntityEvents.Toss)FabricPlayerEvents.ITEM_TOSS.invoker()).onItemToss((class_3222)class_3222.class.cast((Object)this), itemStack);
        if (eventResult.isInterrupt()) {
            callback.setReturnValue(null);
        }
    }

    @ModifyReturnValue(method={"getDestroySpeed"}, at={@At(value="TAIL")})
    public float getDestroySpeed(float destroySpeed, class_2680 blockState) {
        DefaultedFloat defaultedFloat = DefaultedFloat.fromValue(destroySpeed);
        if (((BreakSpeedCallback)FabricPlayerEvents.BREAK_SPEED.invoker()).onBreakSpeed((class_1657)class_1657.class.cast((Object)this), blockState, defaultedFloat).isInterrupt()) {
            defaultedFloat.accept(-1.0f);
        }
        return defaultedFloat.getAsOptionalFloat().orElse(Float.valueOf(destroySpeed)).floatValue();
    }

    @Inject(method={"die"}, at={@At(value="HEAD")}, cancellable=true)
    public void die(class_1282 damageSource, CallbackInfo callback) {
        EventResult result = ((LivingDeathCallback)FabricLivingEvents.LIVING_DEATH.invoker()).onLivingDeath(this, damageSource);
        if (result.isInterrupt()) {
            callback.cancel();
        }
    }

    @ModifyVariable(method={"actuallyHurt"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    protected float actuallyHurt(float damageAmount, class_3218 serverLevel, class_1282 damageSource, @Cancellable CallbackInfo callback) {
        if (!this.method_5679(serverLevel, damageSource)) {
            MutableBoolean cancelInjection = new MutableBoolean();
            damageAmount = FabricEventImplHelper.onLivingHurt(this, serverLevel, damageSource, damageAmount, cancelInjection);
            if (cancelInjection.booleanValue()) {
                callback.cancel();
            }
        }
        return damageAmount;
    }

    @ModifyReturnValue(method={"getProjectile"}, at={@At(value="RETURN")})
    public class_1799 getProjectile(class_1799 projectileItemStack, class_1799 weaponItemStack) {
        if (weaponItemStack.method_7909() instanceof class_1811) {
            DefaultedValue<class_1799> projectileItemStackValue = DefaultedValue.fromValue(projectileItemStack);
            ((PickProjectileCallback)FabricLivingEvents.PICK_PROJECTILE.invoker()).onPickProjectile(this, weaponItemStack, projectileItemStackValue);
            return projectileItemStackValue.getAsOptional().orElse(projectileItemStack);
        }
        return projectileItemStack;
    }
}

