/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.fabric.impl.capability;

import com.mojang.serialization.Codec;
import fuzs.puzzleslib.api.capability.v3.CapabilityController;
import fuzs.puzzleslib.api.capability.v3.data.BlockEntityCapabilityKey;
import fuzs.puzzleslib.api.capability.v3.data.CapabilityComponent;
import fuzs.puzzleslib.api.capability.v3.data.CapabilityKey;
import fuzs.puzzleslib.api.capability.v3.data.EntityCapabilityKey;
import fuzs.puzzleslib.api.capability.v3.data.LevelCapabilityKey;
import fuzs.puzzleslib.api.capability.v3.data.LevelChunkCapabilityKey;
import fuzs.puzzleslib.api.core.v1.utility.NbtSerializable;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.fabric.impl.capability.data.FabricBlockEntityCapabilityKey;
import fuzs.puzzleslib.fabric.impl.capability.data.FabricCapabilityKey;
import fuzs.puzzleslib.fabric.impl.capability.data.FabricEntityCapabilityKey;
import fuzs.puzzleslib.fabric.impl.capability.data.FabricLevelCapabilityKey;
import fuzs.puzzleslib.fabric.impl.capability.data.FabricLevelChunkCapabilityKey;
import fuzs.puzzleslib.impl.capability.GlobalCapabilityRegister;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentTarget;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2586;
import net.minecraft.class_2818;
import net.minecraft.class_2960;

public final class FabricCapabilityController
implements CapabilityController {
    private final String modId;

    public FabricCapabilityController(String modId) {
        this.modId = modId;
    }

    @Override
    public <T extends class_1297, C extends CapabilityComponent<T>> EntityCapabilityKey.Mutable<T, C> registerEntityCapability(String identifier, Class<C> capabilityType, Supplier<C> capabilityFactory, Class<T> entityType) {
        return this.registerCapability(class_1297.class, identifier, capabilityFactory, entityType::isInstance, FabricEntityCapabilityKey::new);
    }

    @Override
    public <T extends class_2586, C extends CapabilityComponent<T>> BlockEntityCapabilityKey<T, C> registerBlockEntityCapability(String identifier, Class<C> capabilityType, Supplier<C> capabilityFactory, Class<T> blockEntityType) {
        return this.registerCapability(class_2586.class, identifier, capabilityFactory, blockEntityType::isInstance, FabricBlockEntityCapabilityKey::new);
    }

    @Override
    public <C extends CapabilityComponent<class_2818>> LevelChunkCapabilityKey<C> registerLevelChunkCapability(String identifier, Class<C> capabilityType, Supplier<C> capabilityFactory) {
        return this.registerCapability(class_2818.class, identifier, capabilityFactory, FabricLevelChunkCapabilityKey::new);
    }

    @Override
    public <C extends CapabilityComponent<class_1937>> LevelCapabilityKey<C> registerLevelCapability(String identifier, Class<C> capabilityType, Supplier<C> capabilityFactory) {
        return this.registerCapability(class_1937.class, identifier, capabilityFactory, FabricLevelCapabilityKey::new);
    }

    private <T, C extends CapabilityComponent<T>, K extends CapabilityKey<T, C>> K registerCapability(Class<? extends AttachmentTarget> holderType, String identifier, Supplier<C> capabilityFactory, FabricCapabilityKey.Factory<T, C, K> capabilityKeyFactory) {
        return this.registerCapability(holderType, identifier, capabilityFactory, holderType::isInstance, capabilityKeyFactory);
    }

    private <T, C extends CapabilityComponent<T>, K extends CapabilityKey<T, C>> K registerCapability(Class<? extends AttachmentTarget> holderType, String identifier, Supplier<C> capabilityFactory, Predicate<Object> filter, FabricCapabilityKey.Factory<T, C, K> capabilityKeyFactory) {
        GlobalCapabilityRegister.testHolderType(holderType);
        Codec<C> codec = NbtSerializable.codec(capabilityFactory);
        class_2960 capabilityName = ResourceLocationHelper.fromNamespaceAndPath(this.modId, identifier);
        AttachmentType attachmentType = AttachmentRegistry.createPersistent((class_2960)capabilityName, codec);
        return capabilityKeyFactory.apply(attachmentType, filter, capabilityFactory);
    }
}

