/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.data.v2;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_161;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2370;
import net.minecraft.class_2405;
import net.minecraft.class_2446;
import net.minecraft.class_2450;
import net.minecraft.class_2454;
import net.minecraft.class_2960;
import net.minecraft.class_3981;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5794;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7699;
import net.minecraft.class_7701;
import net.minecraft.class_7784;
import net.minecraft.class_7800;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8074;
import net.minecraft.class_8779;
import net.minecraft.class_8790;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRecipeProvider
extends class_2446
implements class_2405 {
    static final class_5455 EMPTY_REGISTRY_ACCESS = new class_5455.class_6891(List.of(new class_2370(class_7924.field_41197, Lifecycle.stable())));
    static final class_8790 EMPTY_RECIPE_OUTPUT = new class_8790(){

        public void method_53819(class_5321<class_1860<?>> resourceKey, class_1860<?> recipe, @Nullable class_8779 advancementHolder) {
            throw new UnsupportedOperationException();
        }

        public class_161.class_162 method_53818() {
            throw new UnsupportedOperationException();
        }

        public void method_62738() {
            throw new UnsupportedOperationException();
        }
    };
    private static final Map<class_5794.class_5796, BiFunction<class_1935, class_1935, class_5797>> STONECUTTING_BUILDERS = ImmutableMap.builder().put((Object)class_5794.class_5796.field_28534, (itemLike, itemLike2) -> class_3981.method_17968((class_1856)class_1856.method_8101((class_1935)itemLike2), (class_7800)class_7800.field_40634, (class_1935)itemLike)).put((Object)class_5794.class_5796.field_33689, (itemLike, itemLike2) -> class_3981.method_17968((class_1856)class_1856.method_8101((class_1935)itemLike2), (class_7800)class_7800.field_40634, (class_1935)itemLike)).put((Object)class_5794.class_5796.field_28539, (itemLike, itemLike2) -> class_3981.method_17969((class_1856)class_1856.method_8101((class_1935)itemLike2), (class_7800)class_7800.field_40634, (class_1935)itemLike, (int)2)).put((Object)class_5794.class_5796.field_28540, (itemLike, itemLike2) -> class_3981.method_17968((class_1856)class_1856.method_8101((class_1935)itemLike2), (class_7800)class_7800.field_40634, (class_1935)itemLike)).put((Object)class_5794.class_5796.field_28542, (itemLike, itemLike2) -> class_3981.method_17968((class_1856)class_1856.method_8101((class_1935)itemLike2), (class_7800)class_7800.field_40634, (class_1935)itemLike)).put((Object)class_5794.class_5796.field_28544, (itemLike, itemLike2) -> class_3981.method_17968((class_1856)class_1856.method_8101((class_1935)itemLike2), (class_7800)class_7800.field_40635, (class_1935)itemLike)).build();
    private final class_7784 packOutput;
    private final CompletableFuture<class_7225.class_7874> registries;
    protected final String modId;

    public AbstractRecipeProvider(DataProviderContext context) {
        this(context.getModId(), context.getPackOutput(), context.getRegistries());
    }

    public AbstractRecipeProvider(String modId, class_7784 packOutput, CompletableFuture<class_7225.class_7874> registries) {
        super((class_7225.class_7874)EMPTY_REGISTRY_ACCESS, EMPTY_RECIPE_OUTPUT);
        this.packOutput = packOutput;
        this.registries = registries;
        this.modId = modId;
    }

    @Nullable
    protected static <T> JsonElement searchAndReplaceValue(@Nullable JsonElement jsonElement, T searchFor, T replaceWith) {
        block10: {
            block11: {
                Objects.requireNonNull(searchFor, "search for is null");
                Objects.requireNonNull(replaceWith, "replace with is null");
                if (jsonElement == null || jsonElement.isJsonNull()) break block10;
                if (jsonElement.isJsonPrimitive()) {
                    JsonPrimitive jsonPrimitive = jsonElement.getAsJsonPrimitive();
                    if (jsonPrimitive.isNumber()) {
                        if (searchFor.equals(jsonPrimitive.getAsNumber())) {
                            return new JsonPrimitive((Number)replaceWith);
                        }
                    } else if (jsonPrimitive.isBoolean()) {
                        if (searchFor.equals(jsonPrimitive.getAsBoolean())) {
                            return new JsonPrimitive((Boolean)replaceWith);
                        }
                    } else if (jsonPrimitive.isString() && searchFor.toString().equals(jsonPrimitive.getAsString())) {
                        return new JsonPrimitive(replaceWith.toString());
                    }
                    return jsonElement;
                }
                if (!jsonElement.isJsonArray()) break block11;
                JsonArray jsonArray = jsonElement.getAsJsonArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    jsonArray.set(i, AbstractRecipeProvider.searchAndReplaceValue(jsonArray.get(i), searchFor, replaceWith));
                }
                break block10;
            }
            if (!jsonElement.isJsonObject()) break block10;
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            for (Map.Entry entry : jsonObject.entrySet()) {
                entry.setValue(AbstractRecipeProvider.searchAndReplaceValue((JsonElement)entry.getValue(), searchFor, replaceWith));
            }
        }
        return jsonElement;
    }

    public void generateForBlockFamilies(Stream<class_5794> blockFamilies) {
        blockFamilies.filter(class_5794::method_33478).forEach(blockFamily -> this.method_33535((class_5794)blockFamily, class_7701.field_40183));
    }

    public void method_33535(class_5794 blockFamily, class_7699 requiredFeatures) {
        super.method_33535(blockFamily, requiredFeatures);
        blockFamily.method_33474().forEach((variant, block) -> {
            if (block.method_45322().method_45400(requiredFeatures)) {
                BiFunction<class_1935, class_1935, class_5797> biFunction = STONECUTTING_BUILDERS.get(variant);
                class_2248 itemLike = this.method_33533(blockFamily, (class_5794.class_5796)variant);
                if (biFunction != null) {
                    class_5797 recipeBuilder = biFunction.apply((class_1935)block, (class_1935)itemLike);
                    recipeBuilder.method_33530(blockFamily.method_33480().orElseGet(() -> AbstractRecipeProvider.lambda$generateRecipes$7((class_1935)itemLike)), this.method_10426((class_1935)itemLike));
                    recipeBuilder.method_36443(this.field_53721, AbstractRecipeProvider.getStonecuttingRecipeName((class_1935)block, (class_1935)itemLike));
                }
            }
        });
    }

    public void stair(class_7800 recipeCategory, class_1935 resultItem, class_1935 ingredientItem) {
        this.stairBuilder(recipeCategory, resultItem, class_1856.method_8101((class_1935)ingredientItem)).method_33530(AbstractRecipeProvider.method_32807((class_1935)ingredientItem), this.method_10426(ingredientItem)).method_10431(this.field_53721);
    }

    public class_5797 stairBuilder(class_7800 recipeCategory, class_1935 resultItem, class_1856 ingredient) {
        return this.method_62747(recipeCategory, resultItem, 4).method_10428(Character.valueOf('#'), ingredient).method_10439("#  ").method_10439("## ").method_10439("###");
    }

    public void metalCooking(class_1935 resultItem, class_1935 ingredientItem, float experience) {
        this.metalCooking(resultItem, ingredientItem, experience, 200);
    }

    public void metalCooking(class_1935 resultItem, class_1935 ingredientItem, float experience, int baseCookingTime) {
        class_2454.method_17802((class_1856)class_1856.method_8101((class_1935)ingredientItem), (class_7800)class_7800.field_40642, (class_1935)resultItem, (float)experience, (int)baseCookingTime).method_10469(AbstractRecipeProvider.method_32807((class_1935)ingredientItem), this.method_10426(ingredientItem)).method_10431(this.field_53721);
        class_2454.method_10473((class_1856)class_1856.method_8101((class_1935)ingredientItem), (class_7800)class_7800.field_40642, (class_1935)resultItem, (float)experience, (int)(baseCookingTime / 2)).method_10469(AbstractRecipeProvider.method_32807((class_1935)ingredientItem), this.method_10426(ingredientItem)).method_36443(this.field_53721, AbstractRecipeProvider.method_36452((class_1935)resultItem));
    }

    public void foodCooking(class_1935 resultItem, class_1935 ingredientItem) {
        this.foodCooking(resultItem, ingredientItem, 0.35f, 200);
    }

    public void foodCooking(class_1935 resultItem, class_1935 ingredientItem, float experienceReward, int baseCookingTime) {
        class_2454.method_17802((class_1856)class_1856.method_8101((class_1935)ingredientItem), (class_7800)class_7800.field_40640, (class_1935)resultItem, (float)experienceReward, (int)baseCookingTime).method_10469(AbstractRecipeProvider.method_32807((class_1935)ingredientItem), this.method_10426(ingredientItem)).method_10431(this.field_53721);
        class_2454.method_35918((class_1856)class_1856.method_8101((class_1935)ingredientItem), (class_7800)class_7800.field_40640, (class_1935)resultItem, (float)experienceReward, (int)(baseCookingTime / 2)).method_10469(AbstractRecipeProvider.method_32807((class_1935)ingredientItem), this.method_10426(ingredientItem)).method_36443(this.field_53721, AbstractRecipeProvider.getCraftingMethodRecipeName(resultItem, class_1865.field_17085));
        class_2454.method_35916((class_1856)class_1856.method_8101((class_1935)ingredientItem), (class_7800)class_7800.field_40640, (class_1935)resultItem, (float)experienceReward, (int)(baseCookingTime * 3)).method_10469(AbstractRecipeProvider.method_32807((class_1935)ingredientItem), this.method_10426(ingredientItem)).method_36443(this.field_53721, AbstractRecipeProvider.getCraftingMethodRecipeName(resultItem, class_1865.field_17347));
    }

    public class_5797 stonecutterResultFromBaseBuilder(class_7800 recipeCategory, class_1935 resultItem, class_1856 ingredient) {
        return this.stonecutterResultFromBaseBuilder(recipeCategory, resultItem, ingredient, 1);
    }

    public class_5797 stonecutterResultFromBaseBuilder(class_7800 recipeCategory, class_1935 resultItem, class_1856 ingredient, int count) {
        return class_3981.method_17969((class_1856)ingredient, (class_7800)recipeCategory, (class_1935)resultItem, (int)count);
    }

    public void smithing(class_7800 recipeCategory, class_1935 resultItem, class_1935 templateItem, class_1935 baseItem, class_1935 materialItem) {
        class_8074.method_48535((class_1856)class_1856.method_8101((class_1935)templateItem), (class_1856)class_1856.method_8101((class_1935)baseItem), (class_1856)class_1856.method_8101((class_1935)materialItem), (class_7800)recipeCategory, (class_1792)resultItem.method_8389()).method_48536(AbstractRecipeProvider.method_32807((class_1935)materialItem), this.method_10426(materialItem)).method_48538(this.field_53721, AbstractRecipeProvider.getSmithingRecipeName(resultItem));
    }

    public void waxing(class_1935 resultItem, class_1935 ingredientItem) {
        class_2450.method_62770((class_7871)this.field_53722, (class_7800)class_7800.field_40634, (class_1935)resultItem).method_10454(ingredientItem).method_10454((class_1935)class_1802.field_20414).method_10452(AbstractRecipeProvider.method_33716((class_1935)resultItem)).method_10442(AbstractRecipeProvider.method_32807((class_1935)ingredientItem), this.method_10426(ingredientItem)).method_36443(this.field_53721, AbstractRecipeProvider.method_33714((class_1935)resultItem, (class_1935)class_1802.field_20414));
    }

    public static String getCraftingMethodRecipeName(class_1935 resultItem, class_1865<?> recipeSerializer) {
        class_2960 resourceLocation = class_7923.field_41189.method_10221(recipeSerializer);
        Objects.requireNonNull(resourceLocation, "resource location is null");
        return AbstractRecipeProvider.getCraftingMethodRecipeName(resultItem, resourceLocation.method_12832());
    }

    public static String getCraftingMethodRecipeName(class_1935 resultItem, String craftingMethod) {
        return AbstractRecipeProvider.method_33716((class_1935)resultItem) + "_from_" + craftingMethod;
    }

    public static String getStonecuttingRecipeName(class_1935 resultItem, class_1935 material) {
        return AbstractRecipeProvider.method_33714((class_1935)resultItem, (class_1935)material) + "_stonecutting";
    }

    public static String getSmithingRecipeName(class_1935 resultItem) {
        return AbstractRecipeProvider.method_33716((class_1935)resultItem) + "_smithing";
    }

    public static String getHasName(class_6862<class_1792> tagKey) {
        return "has_" + tagKey.comp_327().method_12832();
    }

    public CompletableFuture<?> method_10319(class_7403 output) {
        return ((CompletableFuture)this.registries.thenCompose(registries -> {
            ArrayList completableFutures = new ArrayList();
            RecipeOutputImpl recipeOutput = new RecipeOutputImpl(output, (class_7225.class_7874)registries, completableFutures::add);
            this.injectRegistries((class_7225.class_7874)registries, recipeOutput);
            this.addRecipes(recipeOutput);
            return CompletableFuture.allOf((CompletableFuture[])completableFutures.toArray(CompletableFuture[]::new));
        })).thenRun(() -> this.injectRegistries((class_7225.class_7874)EMPTY_REGISTRY_ACCESS, EMPTY_RECIPE_OUTPUT));
    }

    private void injectRegistries(class_7225.class_7874 registries, class_8790 recipeOutput) {
        this.field_48981 = registries;
        this.field_53722 = registries.method_46762(class_7924.field_41197);
        this.field_53721 = recipeOutput;
    }

    public final class_7225.class_7874 registries() {
        Preconditions.checkState((this.field_48981 != EMPTY_REGISTRY_ACCESS ? 1 : 0) != 0, (Object)"registry access is empty");
        return this.field_48981;
    }

    public final class_7871<class_1792> items() {
        Preconditions.checkState((this.field_48981 != EMPTY_REGISTRY_ACCESS ? 1 : 0) != 0, (Object)"registry access is empty");
        return this.field_53722;
    }

    public void method_10419() {
        throw new UnsupportedOperationException();
    }

    public abstract void addRecipes(class_8790 var1);

    public String method_10321() {
        return "Recipes";
    }

    private static /* synthetic */ String lambda$generateRecipes$7(class_1935 itemLike) {
        return AbstractRecipeProvider.method_32807((class_1935)itemLike);
    }

    private class RecipeOutputImpl
    implements class_8790 {
        private final class_7403 output;
        private final class_7784.class_7489 recipePathProvider;
        private final class_7784.class_7489 advancementPathProvider;
        private final class_7225.class_7874 registries;
        private final Consumer<CompletableFuture<?>> consumer;
        private final Set<class_5321<class_1860<?>>> recipes = new HashSet();

        public RecipeOutputImpl(class_7403 output, class_7225.class_7874 registries, Consumer<CompletableFuture<?>> consumer) {
            this.output = output;
            this.recipePathProvider = AbstractRecipeProvider.this.packOutput.method_60917(class_7924.field_52178);
            this.advancementPathProvider = AbstractRecipeProvider.this.packOutput.method_60917(class_7924.field_52177);
            this.registries = registries;
            this.consumer = consumer;
        }

        public void method_53819(class_5321<class_1860<?>> resourceKey, class_1860<?> recipe, @Nullable class_8779 advancementHolder) {
            class_5321 originalResourceKey = resourceKey;
            class_2960 resourceLocation = ResourceLocationHelper.fromNamespaceAndPath(AbstractRecipeProvider.this.modId, resourceKey.method_29177().method_12832());
            if (!this.recipes.add(resourceKey = class_5321.method_29179((class_5321)class_7924.field_52178, (class_2960)resourceLocation))) {
                throw new IllegalStateException("Duplicate recipe " + String.valueOf(resourceKey));
            }
            this.consumer.accept(class_2405.method_53496((class_7403)this.output, (class_7225.class_7874)this.registries, (Codec)class_1860.field_47319, recipe, (Path)this.recipePathProvider.method_44107(resourceKey.method_29177())));
            if (advancementHolder != null) {
                class_6903 registryOps = this.registries.method_57093((DynamicOps)JsonOps.INSTANCE);
                JsonElement jsonElement = (JsonElement)class_161.field_47179.encodeStart((DynamicOps)registryOps, (Object)advancementHolder.comp_1920()).getOrThrow();
                jsonElement = AbstractRecipeProvider.searchAndReplaceValue(jsonElement, originalResourceKey, resourceKey);
                class_2960 advancementLocation = ResourceLocationHelper.fromNamespaceAndPath(AbstractRecipeProvider.this.modId, advancementHolder.comp_1919().method_12832());
                this.consumer.accept(class_2405.method_10320((class_7403)this.output, (JsonElement)jsonElement, (Path)this.advancementPathProvider.method_44107(advancementLocation)));
            }
        }

        public class_161.class_162 method_53818() {
            return class_161.class_162.method_51698().method_708(class_5797.field_39377);
        }

        public void method_62738() {
            throw new UnsupportedOperationException();
        }
    }
}

