/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.container.v1;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;

public final class QuickMoveRuleSet {
    private static final Predicate<class_1735> IS_INVENTORY = slot -> slot.field_7871 instanceof class_1661;
    private static final Predicate<class_1735> IS_INVENTORY_ITEMS = slot -> IS_INVENTORY.test((class_1735)slot) && slot.method_34266() < 36;
    private static final Predicate<class_1735> IS_INVENTORY_ARMOR = slot -> IS_INVENTORY.test((class_1735)slot) && slot.method_34266() >= 36 && slot.method_34266() < 40;
    private static final Predicate<class_1735> IS_HOTBAR = slot -> IS_INVENTORY_ITEMS.test((class_1735)slot) && class_1661.method_7380((int)slot.method_34266());
    private static final Predicate<class_1735> IS_NOT_HOTBAR = slot -> IS_INVENTORY_ITEMS.test((class_1735)slot) && !IS_HOTBAR.test((class_1735)slot);
    private final List<Rule> rules = new ArrayList<Rule>();
    private final List<class_1735> slots;
    private final Action action;
    private final Type type;

    private QuickMoveRuleSet(class_1703 menu, Action action, Type type) {
        this.slots = menu.field_7761;
        this.action = action;
        this.type = type;
    }

    public static QuickMoveRuleSet of(class_1703 menu, Action action) {
        return QuickMoveRuleSet.of(menu, action, Type.RELAXED);
    }

    public static QuickMoveRuleSet of(class_1703 menu, Action action, Type type) {
        return new QuickMoveRuleSet(menu, action, type);
    }

    public class_1799 quickMoveStack(class_1657 player, int index) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot = this.slots.get(index);
        if (slot.method_7681()) {
            class_1799 itemInSlot = slot.method_7677();
            itemStack = itemInSlot.method_7972();
            for (Rule rule : this.rules) {
                if (!rule.isValid() || !rule.filter().test(slot)) continue;
                if (this.action.moveItemStackTo(itemInSlot, rule.startIndex(), rule.endIndex(), rule.reverseDirection())) break;
                if (this.type != Type.STRICT) continue;
                return class_1799.field_8037;
            }
            if (itemInSlot.method_7960()) {
                slot.method_53512(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (itemInSlot.method_7947() == itemStack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, itemInSlot);
        }
        return this.type == Type.RELAXED ? class_1799.field_8037 : itemStack;
    }

    public QuickMoveRuleSet addContainerSlotRule(int ... indices) {
        for (int index : indices) {
            this.addContainerSlotRule(index);
        }
        return this;
    }

    public QuickMoveRuleSet addContainerSlotRule(int index) {
        return this.addContainerSlotRule(index, (Predicate<class_1735>)Predicates.alwaysTrue());
    }

    public QuickMoveRuleSet addContainerSlotRule(int index, Predicate<class_1735> filter) {
        return this.addContainerSlotRule(index, false, filter);
    }

    public QuickMoveRuleSet addContainerSlotRule(int index, boolean reverseDirection, Predicate<class_1735> filter) {
        return this.addRule(new Rule(Rule.Type.CONTAINER_SLOT, index, index + 1, reverseDirection, slot -> IS_INVENTORY.test((class_1735)slot) && this.slots.get(index).method_7680(slot.method_7677()) && filter.test((class_1735)slot)));
    }

    public QuickMoveRuleSet addContainerRule(class_1263 container) {
        return this.addContainerRule(this.getInclusiveStartIndex(slot -> slot.field_7871 == container), this.getExclusiveEndIndex(slot -> slot.field_7871 == container));
    }

    public QuickMoveRuleSet addContainerRule(int startIndex, int endIndex) {
        return this.addRule(new Rule(Rule.Type.CONTAINER, startIndex, endIndex, false, slot -> slot.field_7874 >= this.getInclusiveStartIndex(IS_INVENTORY_ITEMS) && slot.field_7874 < this.getExclusiveEndIndex(IS_INVENTORY_ITEMS)));
    }

    public QuickMoveRuleSet addInventoryRules() {
        return this.addInventoryRules(true);
    }

    public QuickMoveRuleSet addInventoryRules(boolean reverseDirection) {
        this.addInventoryRule(Rule.Type.INVENTORY_ARMOR, reverseDirection, IS_INVENTORY_ARMOR);
        return this.addInventoryRule(Rule.Type.INVENTORY_ITEMS, reverseDirection, IS_INVENTORY_ITEMS);
    }

    private QuickMoveRuleSet addInventoryRule(Rule.Type type, boolean reverseDirection, Predicate<class_1735> filter) {
        return this.addRule(new Rule(type, this.getInclusiveStartIndex(filter), this.getExclusiveEndIndex(filter), reverseDirection, IS_INVENTORY.negate()));
    }

    public QuickMoveRuleSet addInventoryCompartmentRules() {
        this.addInventoryCompartmentRule(Rule.Type.TO_ARMOR, Rule.Type.FROM_ARMOR, IS_INVENTORY_ARMOR, IS_INVENTORY_ITEMS);
        return this.addInventoryCompartmentRule(Rule.Type.TO_HOTBAR, Rule.Type.FROM_HOTBAR, IS_HOTBAR, IS_NOT_HOTBAR);
    }

    private QuickMoveRuleSet addInventoryCompartmentRule(Rule.Type to, Rule.Type from, Predicate<class_1735> toFilter, Predicate<class_1735> fromFilter) {
        this.addRule(new Rule(to, this.getInclusiveStartIndex(toFilter), this.getExclusiveEndIndex(toFilter), false, slot -> slot.field_7874 >= this.getInclusiveStartIndex(fromFilter) && slot.field_7874 < this.getExclusiveEndIndex(fromFilter)));
        return this.addRule(new Rule(from, this.getInclusiveStartIndex(fromFilter), this.getExclusiveEndIndex(fromFilter), false, slot -> slot.field_7874 >= this.getInclusiveStartIndex(toFilter) && slot.field_7874 < this.getExclusiveEndIndex(toFilter)));
    }

    private QuickMoveRuleSet addRule(Rule rule) {
        this.rules.add(rule);
        return this;
    }

    private int getInclusiveStartIndex(Predicate<class_1735> predicate) {
        for (int i = 0; i < this.slots.size(); ++i) {
            if (!predicate.test(this.slots.get(i))) continue;
            return i;
        }
        return -1;
    }

    private int getExclusiveEndIndex(Predicate<class_1735> predicate) {
        for (int i = this.slots.size() - 1; i >= 0; --i) {
            if (!predicate.test(this.slots.get(i))) continue;
            return i + 1;
        }
        return -1;
    }

    @FunctionalInterface
    public static interface Action {
        public boolean moveItemStackTo(class_1799 var1, int var2, int var3, boolean var4);
    }

    public static enum Type {
        STRICT,
        RELAXED,
        LENIENT;

    }

    private record Rule(Type type, int startIndex, int endIndex, boolean reverseDirection, Predicate<class_1735> filter) {
        public boolean isValid() {
            return this.startIndex != -1 && this.endIndex != -1;
        }

        static enum Type {
            CONTAINER_SLOT,
            CONTAINER,
            INVENTORY_ITEMS,
            INVENTORY_ARMOR,
            TO_HOTBAR,
            FROM_HOTBAR,
            TO_ARMOR,
            FROM_ARMOR;

        }
    }
}

