/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.gui.v2.tooltip;

import com.google.common.collect.ImmutableList;
import fuzs.puzzleslib.impl.client.core.proxy.ClientProxyImpl;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_8000;
import net.minecraft.class_8001;
import net.minecraft.class_8002;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public final class TooltipRenderHelper {
    private TooltipRenderHelper() {
    }

    public static List<class_2561> getTooltipLines(class_1799 itemStack) {
        return TooltipRenderHelper.getTooltipLines(itemStack, (class_1836)(class_310.method_1551().field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070));
    }

    public static List<class_2561> getTooltipLines(class_1799 itemStack, class_1836 tooltipFlag) {
        Objects.requireNonNull(itemStack, "item stack is null");
        Objects.requireNonNull(tooltipFlag, "tooltip flag is null");
        class_310 minecraft = class_310.method_1551();
        return itemStack.method_7950(class_1792.class_9635.method_59528((class_1937)minecraft.field_1687), (class_1657)minecraft.field_1724, tooltipFlag);
    }

    public static List<class_5684> getTooltip(class_1799 itemStack) {
        return TooltipRenderHelper.getTooltip(itemStack, (class_1836)(class_310.method_1551().field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070));
    }

    public static List<class_5684> getTooltip(class_1799 itemStack, class_1836 tooltipFlag) {
        Objects.requireNonNull(itemStack, "item stack is null");
        Objects.requireNonNull(tooltipFlag, "tooltip flag is null");
        List<class_2561> components = TooltipRenderHelper.getTooltipLines(itemStack, tooltipFlag);
        List<class_5632> imageComponents = itemStack.method_32347().map(List::of).orElse(List.of());
        return TooltipRenderHelper.createClientComponents(components, imageComponents);
    }

    public static void renderTooltip(class_332 guiGraphics, int posX, int posY, class_1799 itemStack) {
        Objects.requireNonNull(itemStack, "item stack is null");
        TooltipRenderHelper.renderTooltipComponents(guiGraphics, posX, posY, TooltipRenderHelper.getTooltip(itemStack));
    }

    public static void renderTooltip(class_332 guiGraphics, int posX, int posY, class_2561 component, class_5632 imageComponent) {
        Objects.requireNonNull(component, "component is null");
        Objects.requireNonNull(imageComponent, "image component is null");
        TooltipRenderHelper.renderTooltip(guiGraphics, posX, posY, List.of(component), imageComponent);
    }

    public static void renderTooltip(class_332 guiGraphics, int posX, int posY, List<class_2561> components, class_5632 imageComponent) {
        Objects.requireNonNull(imageComponent, "image component is null");
        TooltipRenderHelper.renderTooltip(guiGraphics, posX, posY, components, List.of(imageComponent));
    }

    public static void renderTooltip(class_332 guiGraphics, int posX, int posY, List<class_2561> components) {
        TooltipRenderHelper.renderTooltip(guiGraphics, posX, posY, components, List.of());
    }

    public static void renderTooltip(class_332 guiGraphics, int posX, int posY, List<class_2561> components, List<class_5632> imageComponents) {
        TooltipRenderHelper.renderTooltipComponents(guiGraphics, posX, posY, TooltipRenderHelper.createClientComponents(components, imageComponents));
    }

    public static List<class_5684> createClientComponents(List<class_2561> components, List<class_5632> imageComponents) {
        return TooltipRenderHelper.createClientComponents(components, imageComponents, 1);
    }

    public static List<class_5684> createClientComponents(List<class_2561> components, List<class_5632> imageComponents, int insertAt) {
        List clientComponents = components.stream().map(class_2561::method_30937).map(class_5684::method_32662).collect(Collectors.toList());
        List<class_5684> clientImageComponents = imageComponents.stream().map(TooltipRenderHelper::createImageComponent).toList();
        if (insertAt == -1) {
            clientComponents.addAll(clientImageComponents);
        } else {
            clientComponents.addAll(Math.min(clientComponents.size(), insertAt), clientImageComponents);
        }
        return ImmutableList.copyOf(clientComponents);
    }

    public static class_5684 createImageComponent(class_5632 imageComponent) {
        return ClientProxyImpl.get().createImageComponent(imageComponent);
    }

    public static void renderTooltipComponents(class_332 guiGraphics, int posX, int posY, List<? extends class_5684> tooltipComponents) {
        TooltipRenderHelper.renderTooltipComponents(guiGraphics, posX, posY, tooltipComponents, null);
    }

    public static void renderTooltipComponents(class_332 guiGraphics, int posX, int posY, List<? extends class_5684> tooltipComponents, @Nullable class_2960 tooltipStyle) {
        class_5684 component;
        int i;
        if (tooltipComponents.isEmpty()) {
            return;
        }
        class_310 minecraft = class_310.method_1551();
        boolean isCancelled = TooltipRenderHelper.onRenderTooltip(guiGraphics, minecraft.field_1772, posX, posY, tooltipComponents, class_8001.field_41687);
        if (isCancelled) {
            return;
        }
        int lineWidth = 0;
        int lineHeight = tooltipComponents.size() == 1 ? -2 : 0;
        for (class_5684 component2 : tooltipComponents) {
            int width = component2.method_32664(minecraft.field_1772);
            if (width > lineWidth) {
                lineWidth = width;
            }
            lineHeight += component2.method_32661(minecraft.field_1772);
        }
        int originPosX = posX + 12;
        int originPosY = posY - 12;
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51452();
        class_8002.method_47946((class_332)guiGraphics, (int)originPosX, (int)originPosY, (int)lineWidth, (int)lineHeight, (int)400, (class_2960)tooltipStyle);
        guiGraphics.method_51452();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 400.0f);
        MutableInt currentPosY = new MutableInt(originPosY);
        for (i = 0; i < tooltipComponents.size(); ++i) {
            component = tooltipComponents.get(i);
            guiGraphics.method_64039(bufferSource -> component.method_32665(minecraft.field_1772, originPosX, currentPosY.intValue(), guiGraphics.method_51448().method_23760().method_23761(), (class_4597.class_4598)bufferSource));
            currentPosY.add(component.method_32661(minecraft.field_1772) + (i == 0 ? 2 : 0));
        }
        currentPosY.setValue(originPosY);
        for (i = 0; i < tooltipComponents.size(); ++i) {
            component = tooltipComponents.get(i);
            component.method_32666(minecraft.field_1772, originPosX, currentPosY.intValue(), lineWidth, lineHeight, guiGraphics);
            currentPosY.add(component.method_32661(minecraft.field_1772) + (i == 0 ? 2 : 0));
        }
        guiGraphics.method_51452();
        guiGraphics.method_51448().method_22909();
    }

    public static boolean onRenderTooltip(class_332 guiGraphics, class_327 font, int mouseX, int mouseY, List<class_5684> components, class_8000 positioner) {
        return ClientProxyImpl.get().onRenderTooltip(guiGraphics, font, mouseX, mouseY, components, positioner);
    }
}

