/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.data.v2;

import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_10405;
import net.minecraft.class_10410;
import net.minecraft.class_10434;
import net.minecraft.class_10439;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4916;
import net.minecraft.class_4941;
import net.minecraft.class_6880;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7923;

public abstract class AbstractModelProvider
implements class_2405 {
    protected final String modId;
    private final class_7784.class_7489 blockStatePathProvider;
    private final class_7784.class_7489 itemInfoPathProvider;
    private final class_7784.class_7489 modelPathProvider;
    private final Set<Object> skipValidation = new HashSet<Object>();

    public AbstractModelProvider(DataProviderContext context) {
        this(context.getModId(), context.getPackOutput());
    }

    public AbstractModelProvider(String modId, class_7784 packOutput) {
        this.modId = modId;
        this.blockStatePathProvider = packOutput.method_45973(class_7784.class_7490.field_39368, "blockstates");
        this.itemInfoPathProvider = packOutput.method_45973(class_7784.class_7490.field_39368, "items");
        this.modelPathProvider = packOutput.method_45973(class_7784.class_7490.field_39368, "models");
    }

    public CompletableFuture<?> method_10319(class_7403 output) {
        BlockStateOutputImpl blockStateOutput = new BlockStateOutputImpl(this::isValid);
        ItemModelOutputImpl itemModelOutput = new ItemModelOutputImpl(this::isValid);
        class_4916.class_10408 modelOutput = new class_4916.class_10408();
        this.addBlockModels(this.setupBlockModelGenerators(new class_4910((Consumer)((Object)blockStateOutput), (class_10405)itemModelOutput, (BiConsumer)modelOutput)));
        this.addItemModels(new class_4915((class_10405)itemModelOutput, (BiConsumer)modelOutput));
        blockStateOutput.method_65462();
        itemModelOutput.method_65469();
        return CompletableFuture.allOf(blockStateOutput.method_65465(output, this.blockStatePathProvider), modelOutput.method_65478(output, this.modelPathProvider), itemModelOutput.method_65473(output, this.itemInfoPathProvider));
    }

    private class_4910 setupBlockModelGenerators(class_4910 blockModelGenerators) {
        class_4910.field_56789 = new ArrayList(class_4910.field_56789);
        class_4910.field_56790 = new HashMap(class_4910.field_56790);
        class_4910.field_56796 = new HashMap(class_4910.field_56796);
        return blockModelGenerators;
    }

    private <T> boolean isValid(class_6880.class_6883<T> holder) {
        if (!this.skipAllValidation()) {
            if (holder.method_40237().method_29177().method_12836().equals(this.modId)) {
                return !this.skipValidation.contains(holder.comp_349());
            }
            return false;
        }
        return false;
    }

    public void addBlockModels(class_4910 blockModelGenerators) {
    }

    public void addItemModels(class_4915 itemModelGenerators) {
    }

    protected boolean skipAllValidation() {
        return false;
    }

    protected final void skipBlockValidation(class_2248 block) {
        this.skipValidation.add(block);
    }

    protected final void skipItemValidation(class_1792 item) {
        this.skipValidation.add(item);
    }

    public final String method_10321() {
        return "Model Definitions";
    }

    static class BlockStateOutputImpl
    extends class_4916.class_10406 {
        private final Predicate<class_6880.class_6883<class_2248>> filter;

        public BlockStateOutputImpl(Predicate<class_6880.class_6883<class_2248>> filter) {
            this.filter = filter;
        }

        public void method_65462() {
            List<class_2960> list = class_7923.field_41175.method_42017().filter(this.filter).filter(holder -> !this.field_55248.containsKey(holder.comp_349())).map(holder -> holder.method_40237().method_29177()).toList();
            if (!list.isEmpty()) {
                throw new IllegalStateException("Missing blockstate definitions for: " + String.valueOf(list));
            }
        }
    }

    static class ItemModelOutputImpl
    extends class_4916.class_10407
    implements CustomItemModelOutput {
        private final Predicate<class_6880.class_6883<class_1792>> filter;

        public ItemModelOutputImpl(Predicate<class_6880.class_6883<class_1792>> filter) {
            this.filter = filter;
        }

        @Override
        public void accept(class_1792 item, class_10439.class_10441 model, class_10434.class_10543 properties) {
            this.method_65471(item, new class_10434(model, properties));
        }

        public void method_65469() {
            class_7923.field_41178.method_42017().filter(this.filter).forEach(item -> {
                class_1747 blockItem;
                Object patt0$temp;
                if (!this.field_55250.containsKey(item.comp_349()) && (patt0$temp = item.comp_349()) instanceof class_1747 && !this.field_55249.containsKey(blockItem = (class_1747)patt0$temp)) {
                    class_2960 resourceLocation = class_4941.method_25842((class_2248)blockItem.method_7711());
                    this.method_65460((class_1792)blockItem, class_10410.method_65481((class_2960)resourceLocation));
                }
            });
            this.field_55250.forEach((item, item2) -> {
                class_10434 clientItem = (class_10434)this.field_55249.get(item2);
                if (clientItem == null) {
                    throw new IllegalStateException("Missing donor: " + String.valueOf(item2) + " -> " + String.valueOf(item));
                }
                this.method_65471((class_1792)item, clientItem);
            });
            List<class_2960> list = class_7923.field_41178.method_42017().filter(this.filter).filter(item -> !this.field_55249.containsKey(item.comp_349())).map(item -> item.method_40237().method_29177()).toList();
            if (!list.isEmpty()) {
                throw new IllegalStateException("Missing item model definitions for: " + String.valueOf(list));
            }
        }
    }

    public static interface CustomItemModelOutput
    extends class_10405 {
        public void accept(class_1792 var1, class_10439.class_10441 var2, class_10434.class_10543 var3);
    }
}

