/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.voiding;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.ButtonStates;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.FilterButton;
import com.tiviacz.travelersbackpack.inventory.upgrades.voiding.VoidUpgrade;
import com.tiviacz.travelersbackpack.network.ServerboundFilterSettingsPacket;
import com.tiviacz.travelersbackpack.util.PacketDistributor;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class VoidWidget
extends UpgradeWidgetBase<VoidUpgrade> {
    private final FilterButton<VoidWidget> whitelistButton;
    private final FilterButton<VoidWidget> objectButton;
    private final FilterButton<VoidWidget> ignoreModeButton;
    private static final List<class_2561> WHITELIST_TOOLTIPS = List.of(class_2561.method_43471((String)"screen.travelersbackpack.filter_allow_voiding"), class_2561.method_43471((String)"screen.travelersbackpack.filter_block_voiding"), class_2561.method_43471((String)"screen.travelersbackpack.filter_match_contents_voiding"));
    private static final List<class_2561> OBJECT_TOOLTIPS = List.of(class_2561.method_43471((String)"screen.travelersbackpack.filter_item"), class_2561.method_43471((String)"screen.travelersbackpack.filter_modid"));
    private static final List<class_2561> IGNORE_MODE_TOOLTIPS = List.of(class_2561.method_43471((String)"screen.travelersbackpack.filter_match_components"), class_2561.method_43471((String)"screen.travelersbackpack.filter_ignore_components"));

    public VoidWidget(BackpackScreen screen, VoidUpgrade upgrade, Point pos) {
        super(screen, upgrade, pos, new Point(137, 0), "screen.travelersbackpack.void_upgrade");
        this.whitelistButton = new FilterButton<VoidWidget>(this, upgrade.getFilter().get(0), ButtonStates.ALLOW, new Point(pos.x() + 6, pos.y() + 22));
        this.objectButton = new FilterButton<VoidWidget>(this, upgrade.getFilter().get(1), ButtonStates.OBJECT_TYPE, new Point(pos.x() + 6 + 18, pos.y() + 22));
        this.ignoreModeButton = new FilterButton<VoidWidget>(this, upgrade.getFilter().get(2), ButtonStates.IGNORE_MODE, new Point(pos.x() + 6 + 36, pos.y() + 22));
    }

    @Override
    public void renderBg(class_332 guiGraphics, int x, int y, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, x, y, mouseX, mouseY);
        this.renderMatchContentsSlotOverlay(guiGraphics, ((VoidUpgrade)this.upgrade).getFilter(), 0, 2, TravelersBackpackConfig.getConfig().backpackUpgrades.voidUpgradeSettings.filterSlotCount);
        if (this.isTabOpened()) {
            guiGraphics.method_48196(class_1921.method_51785(), this.pos.x() + 7, this.pos.y() + 44, this.pos.x() + 6 + 17, this.pos.y() + 43 + 17, 0, 2143884822);
        }
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.isTabOpened()) {
            this.whitelistButton.renderButton(guiGraphics, mouseX, mouseY);
            this.objectButton.renderButton(guiGraphics, mouseX, mouseY);
            this.ignoreModeButton.renderButton(guiGraphics, mouseX, mouseY);
        }
    }

    @Override
    public void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.isTabOpened()) {
            if (((VoidUpgrade)this.upgrade).filter.getStackInSlot(0).method_7960() && this.isWithinBounds(mouseX, mouseY, new Point(7, 44), new Point(17, 17))) {
                guiGraphics.method_64038(((BackpackScreen)this.screen).method_64506(), List.of(class_2561.method_43471((String)"screen.travelersbackpack.void_upgrade_trash_slot"), class_2561.method_43471((String)"screen.travelersbackpack.void_upgrade_trash_slot_description")), Optional.empty(), mouseX, mouseY);
            }
            if (this.whitelistButton.isMouseOver(mouseX, mouseY)) {
                guiGraphics.method_51438(((BackpackScreen)this.screen).method_64506(), WHITELIST_TOOLTIPS.get(this.whitelistButton.getCurrentState()), mouseX, mouseY);
            }
            if (this.objectButton.isMouseOver(mouseX, mouseY)) {
                guiGraphics.method_51438(((BackpackScreen)this.screen).method_64506(), OBJECT_TOOLTIPS.get(this.objectButton.getCurrentState()), mouseX, mouseY);
            }
            if (this.ignoreModeButton.isMouseOver(mouseX, mouseY)) {
                guiGraphics.method_51438(((BackpackScreen)this.screen).method_64506(), IGNORE_MODE_TOOLTIPS.get(this.ignoreModeButton.getCurrentState()), mouseX, mouseY);
            }
        }
    }

    @Override
    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        if (this.isTabOpened() && this.isBackpackOwner()) {
            if (this.whitelistButton.mouseClicked(pMouseX, pMouseY, pButton)) {
                PacketDistributor.sendToServer(new ServerboundFilterSettingsPacket(this.dataHolderSlot, List.of(Integer.valueOf(this.whitelistButton.getCurrentState()), Integer.valueOf(this.objectButton.getCurrentState()), Integer.valueOf(this.ignoreModeButton.getCurrentState()))));
                ((BackpackScreen)this.screen).playUIClickSound();
                return true;
            }
            if (this.objectButton.mouseClicked(pMouseX, pMouseY, pButton)) {
                PacketDistributor.sendToServer(new ServerboundFilterSettingsPacket(this.dataHolderSlot, List.of(Integer.valueOf(this.whitelistButton.getCurrentState()), Integer.valueOf(this.objectButton.getCurrentState()), Integer.valueOf(this.ignoreModeButton.getCurrentState()))));
                ((BackpackScreen)this.screen).playUIClickSound();
                return true;
            }
            if (this.ignoreModeButton.mouseClicked(pMouseX, pMouseY, pButton)) {
                PacketDistributor.sendToServer(new ServerboundFilterSettingsPacket(this.dataHolderSlot, List.of(Integer.valueOf(this.whitelistButton.getCurrentState()), Integer.valueOf(this.objectButton.getCurrentState()), Integer.valueOf(this.ignoreModeButton.getCurrentState()))));
                ((BackpackScreen)this.screen).playUIClickSound();
                return true;
            }
        }
        return super.method_25402(pMouseX, pMouseY, pButton);
    }
}

