/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.pickup;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.filter.IFilter;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.FilterSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.pickup.AutoPickupFilterSettings;
import com.tiviacz.travelersbackpack.inventory.upgrades.pickup.AutoPickupWidget;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;

public class AutoPickupUpgrade
extends UpgradeBase<AutoPickupUpgrade>
implements IFilter,
IEnable {
    public ItemStackHandler filter;
    private final AutoPickupFilterSettings filterSettings;

    public AutoPickupUpgrade(UpgradeManager manager, int dataHolderSlot, class_2371<class_1799> filter) {
        super(manager, dataHolderSlot, new Point(66, 103));
        this.filter = this.createFilter(filter);
        int activeSlotCount = TravelersBackpackConfig.getConfig().backpackUpgrades.pickupUpgradeSettings.filterSlotCount;
        this.filterSettings = new AutoPickupFilterSettings(manager.getWrapper().getStorage(), filter.stream().limit(activeSlotCount).filter(stack -> !stack.method_7960()).toList(), this.getFilter());
    }

    @Override
    public List<Integer> getFilter() {
        return (List)this.getDataHolderStack().method_58695(ModDataComponents.FILTER_SETTINGS, List.of(Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(1)));
    }

    public AutoPickupFilterSettings getFilterSettings() {
        return this.filterSettings;
    }

    public boolean canPickup(class_1799 stack) {
        return this.getFilterSettings().matchesFilter(null, stack) && this.isEnabled(this);
    }

    @Override
    public void updateSettings() {
        this.filterSettings.updateSettings(this.getFilter());
    }

    @Override
    public int getFilterSlotCount() {
        return TravelersBackpackConfig.getConfig().backpackUpgrades.pickupUpgradeSettings.filterSlotCount;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public WidgetBase<BackpackScreen> createWidget(BackpackScreen screen, int x, int y) {
        return new AutoPickupWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y));
    }

    @Override
    public List<class_1735> getUpgradeSlots(final BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        ArrayList<class_1735> slots = new ArrayList<class_1735>();
        int activeSlotCount = TravelersBackpackConfig.getConfig().backpackUpgrades.pickupUpgradeSettings.filterSlotCount;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                slots.add(new FilterSlotItemHandler(this, this.filter, j + i * 3, x + 7 + j * 18, y + 44 + i * 18, activeSlotCount){

                    @Override
                    public boolean method_7682() {
                        return super.method_7682() && AutoPickupUpgrade.this.getFilter().get(0) != 2;
                    }

                    @Override
                    public boolean method_7680(class_1799 pStack) {
                        return menu.getWrapper().isOwner(menu.player) && super.method_7680(pStack);
                    }
                });
            }
        }
        return slots;
    }

    private ItemStackHandler createFilter(class_2371<class_1799> stacks) {
        return new ItemStackHandler(stacks){

            @Override
            protected void onContentsChanged(int slot) {
                AutoPickupUpgrade.this.updateDataHolderUnchecked(ModDataComponents.BACKPACK_CONTAINER, InventoryHelper.itemsToList(9, AutoPickupUpgrade.this.filter));
                AutoPickupUpgrade.this.getFilterSettings().updateFilter((List<class_1799>)((BackpackContainerContents)AutoPickupUpgrade.this.getDataHolderStack().method_58694(ModDataComponents.BACKPACK_CONTAINER)).getItems());
            }

            @Override
            public boolean isItemValid(int slot, class_1799 stack) {
                return true;
            }

            @Override
            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }
}

