/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.feeding;

import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.FilterSettingsBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.feeding.FeedingUpgrade;
import java.util.List;
import net.minecraft.class_10124;
import net.minecraft.class_10132;
import net.minecraft.class_10134;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1799;
import net.minecraft.class_4081;
import net.minecraft.class_4174;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class FeedingFilterSettings
extends FilterSettingsBase<FeedingUpgrade> {
    public static final int ALLOW_MODE = 0;
    public static final int HUNGER_MODE = 1;
    public static final int IGNORE_EFFECT_MODE = 2;
    public static final int ALLOW = 0;
    public static final int BLOCK = 1;
    public static final int ALWAYS_EAT = 0;
    public static final int HALF_NUTRITION = 1;
    public static final int FULL_NUTRITION = 2;
    public static final int BLOCK_BAD_EFFECTS = 0;
    public static final int ALLOW_BAD_EFFECTS = 1;

    public FeedingFilterSettings(ItemStackHandler storage, List<class_1799> items, List<Integer> filterSettings) {
        super(storage, items, filterSettings, TravelersBackpackConfig.getConfig().backpackUpgrades.feedingUpgradeSettings.filterSlotCount);
    }

    @Override
    public boolean matchesFilter(@Nullable class_1657 player, class_1799 stack) {
        class_1702 foodData = player.method_7344();
        if ((Integer)this.filterSettings.get(0) == 0) {
            return this.filterItems.stream().anyMatch(food -> class_1799.method_31577((class_1799)food.method_46651(1), (class_1799)stack)) && this.compareHungerLevel(foodData, stack) && this.checkHarmfulEffects(stack);
        }
        if ((Integer)this.filterSettings.get(0) == 1) {
            return this.filterItems.stream().noneMatch(food -> class_1799.method_31577((class_1799)food.method_46651(1), (class_1799)stack)) && this.compareHungerLevel(foodData, stack) && this.checkHarmfulEffects(stack);
        }
        return false;
    }

    public boolean compareHungerLevel(class_1702 foodData, class_1799 stack) {
        if ((Integer)this.filterSettings.get(1) == 0) {
            return foodData.method_7587();
        }
        if ((Integer)this.filterSettings.get(1) == 1) {
            return this.getNutritionDifference(foodData, stack) <= this.getHalfOfStackHunger(stack);
        }
        if ((Integer)this.filterSettings.get(1) == 2) {
            return this.getNutritionDifference(foodData, stack) <= 0;
        }
        return false;
    }

    public boolean checkHarmfulEffects(class_1799 stack) {
        if ((Integer)this.filterSettings.get(2) == 0) {
            return this.checkHarmfulEffect((class_10124)stack.method_58694(class_9334.field_53964));
        }
        return true;
    }

    public boolean checkHarmfulEffect(class_10124 consumable) {
        if (consumable != null) {
            for (class_10134 effect : consumable.comp_3089()) {
                if (effect.method_62864() != class_10134.class_10135.field_53810) continue;
                class_10132 applyStatusEffect = (class_10132)effect;
                for (class_1293 mobEffect : applyStatusEffect.comp_3094()) {
                    if (((class_1291)mobEffect.method_5579().comp_349()).method_18792() != class_4081.field_18272) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public int getNutritionDifference(class_1702 foodData, class_1799 stack) {
        if (foodData.method_7587()) {
            class_4174 foodProps = (class_4174)stack.method_58694(class_9334.field_50075);
            int foodNutrition = foodProps.comp_2491();
            int playerNutrition = foodData.method_7586();
            return playerNutrition + foodNutrition - 20;
        }
        return 0;
    }

    public int getHalfOfStackHunger(class_1799 stack) {
        return ((class_4174)stack.method_58694(class_9334.field_50075)).comp_2491() / 2;
    }
}

