/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.model;

import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.client.model.BackpackModelData;
import com.tiviacz.travelersbackpack.client.renderer.BackpackRenderInfo;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.item.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.RenderHelper;
import java.util.Locale;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_630;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import net.minecraft.class_9848;

public class BackpackBlockModel {
    public static final BackpackBlockModel BLOCK_MODEL = new BackpackBlockModel(BackpackModelData.createTravelersBackpack(false).method_32109());
    public class_630 mainBody;
    public class_630 tankLeftTop;
    public class_630 tankRightTop;
    public class_630 sleepingBag;
    public class_630 sleepingBagExtras;
    public class_630 villagerNose;
    public class_630 wolfNose;
    public class_630 foxNose;
    public class_630 ocelotNose;
    public class_630 pigNose;
    public class_630 leftHorn;
    public class_630 rightHorn;

    public BackpackBlockModel(class_630 rootPart) {
        this.mainBody = rootPart.method_32086("main_body");
        this.tankLeftTop = rootPart.method_32086("tankLeftTop");
        this.tankRightTop = rootPart.method_32086("tankRightTop");
        this.sleepingBag = rootPart.method_32086("sleepingBag");
        this.sleepingBagExtras = rootPart.method_32086("sleepingBagExtras");
        this.villagerNose = rootPart.method_32086("villagerNose");
        this.ocelotNose = rootPart.method_32086("ocelotNose");
        this.pigNose = rootPart.method_32086("pigNose");
        this.foxNose = rootPart.method_32086("foxNose");
        this.wolfNose = rootPart.method_32086("wolfNose");
        this.leftHorn = rootPart.method_32086("leftHorn");
        this.rightHorn = rootPart.method_32086("rightHorn");
    }

    public void render(BackpackBlockEntity blockEntity, class_4587 poseStack, class_4597 buffer, int combinedLightIn, int combinedOverlayIn) {
        BackpackWrapper wrapper = blockEntity.getWrapper();
        class_1792 class_17922 = wrapper.getBackpackStack().method_7909();
        if (!(class_17922 instanceof TravelersBackpackItem)) {
            return;
        }
        TravelersBackpackItem item = (TravelersBackpackItem)class_17922;
        class_2960 loc = item.getBackpackTexture();
        class_4588 vertexConsumer = buffer.getBuffer(class_1921.method_23580((class_2960)loc));
        boolean mainBodyRendered = false;
        if (item == ModItems.STANDARD_TRAVELERS_BACKPACK && wrapper.getBackpackStack().method_57826(class_9334.field_49644)) {
            loc = class_2960.method_60655((String)"travelersbackpack", (String)"textures/model/dyed.png");
            vertexConsumer = buffer.getBuffer(class_1921.method_23580((class_2960)loc));
            this.mainBody.method_22699(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn, class_9848.method_61334((int)((class_9282)wrapper.getBackpackStack().method_58694(class_9334.field_49644)).comp_2384()));
            loc = class_2960.method_60655((String)"travelersbackpack", (String)"textures/model/dyed_extras.png");
            vertexConsumer = buffer.getBuffer(class_1921.method_23580((class_2960)loc));
            this.mainBody.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            mainBodyRendered = true;
        }
        if (wrapper.tanksVisible()) {
            this.tankLeftTop.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            this.tankRightTop.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
        }
        if (!blockEntity.isSleepingBagDeployed()) {
            this.sleepingBagExtras.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            loc = BackpackBlockModel.getSleepingBagTexture(wrapper.getSleepingBagColor());
            vertexConsumer = buffer.getBuffer(class_1921.method_23580((class_2960)loc));
            this.sleepingBag.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            loc = item.getBackpackTexture();
            vertexConsumer = buffer.getBuffer(class_1921.method_23580((class_2960)loc));
        }
        if (item == ModItems.FOX_TRAVELERS_BACKPACK) {
            this.foxNose.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
        }
        if (item == ModItems.OCELOT_TRAVELERS_BACKPACK) {
            this.ocelotNose.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
        }
        if (item == ModItems.WOLF_TRAVELERS_BACKPACK) {
            this.wolfNose.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
        }
        if (item == ModItems.VILLAGER_TRAVELERS_BACKPACK || item == ModItems.IRON_GOLEM_TRAVELERS_BACKPACK) {
            this.villagerNose.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
        }
        if (item == ModItems.PIG_TRAVELERS_BACKPACK || item == ModItems.HORSE_TRAVELERS_BACKPACK) {
            this.pigNose.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
        }
        if (item == ModItems.WARDEN_TRAVELERS_BACKPACK) {
            vertexConsumer = buffer.getBuffer(class_1921.method_23576((class_2960)loc));
            this.leftHorn.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            this.rightHorn.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            vertexConsumer = buffer.getBuffer(class_1921.method_23580((class_2960)loc));
        }
        if (item == ModItems.QUARTZ_TRAVELERS_BACKPACK || item == ModItems.SNOW_TRAVELERS_BACKPACK) {
            vertexConsumer = buffer.getBuffer(class_1921.method_29379((class_2960)item.getBackpackTexture()));
        }
        if (!mainBodyRendered) {
            this.mainBody.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
        }
        wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).ifPresent(tanks -> {
            RenderHelper.renderFluidInTank(tanks.getLeftTank(), poseStack, buffer, combinedLightIn, -0.65f, -0.565f, -0.24f);
            RenderHelper.renderFluidInTank(tanks.getRightTank(), poseStack, buffer, combinedLightIn, 0.23f, -0.565f, -0.24f);
        });
    }

    public void renderByItem(class_1799 backpack, class_4587 poseStack, class_4597 buffer, int combinedLightIn, int combinedOverlayIn) {
        boolean renderDefault;
        TravelersBackpackItem item = (TravelersBackpackItem)backpack.method_7909();
        class_2960 loc = item.getBackpackTexture();
        class_4588 vertexConsumer = buffer.getBuffer(class_1921.method_23580((class_2960)loc));
        boolean bl = renderDefault = !backpack.method_57826(ModDataComponents.RENDER_INFO);
        if (renderDefault) {
            this.tankLeftTop.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            this.tankRightTop.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            this.sleepingBagExtras.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            loc = BackpackBlockModel.getSleepingBagTexture(class_1767.field_7964.method_7789());
            vertexConsumer = buffer.getBuffer(class_1921.method_23580((class_2960)loc));
            this.sleepingBag.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            loc = item.getBackpackTexture();
            vertexConsumer = buffer.getBuffer(class_1921.method_23580((class_2960)loc));
            if (item == ModItems.FOX_TRAVELERS_BACKPACK) {
                this.foxNose.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (item == ModItems.OCELOT_TRAVELERS_BACKPACK) {
                this.ocelotNose.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (item == ModItems.WOLF_TRAVELERS_BACKPACK) {
                this.wolfNose.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (item == ModItems.VILLAGER_TRAVELERS_BACKPACK || item == ModItems.IRON_GOLEM_TRAVELERS_BACKPACK) {
                this.villagerNose.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (item == ModItems.PIG_TRAVELERS_BACKPACK || item == ModItems.HORSE_TRAVELERS_BACKPACK) {
                this.pigNose.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (item == ModItems.WARDEN_TRAVELERS_BACKPACK) {
                vertexConsumer = buffer.getBuffer(class_1921.method_23576((class_2960)loc));
                this.leftHorn.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
                this.rightHorn.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
                vertexConsumer = buffer.getBuffer(class_1921.method_23580((class_2960)loc));
            }
            if (item == ModItems.QUARTZ_TRAVELERS_BACKPACK || item == ModItems.SNOW_TRAVELERS_BACKPACK) {
                vertexConsumer = buffer.getBuffer(class_1921.method_29379((class_2960)item.getBackpackTexture()));
            }
            this.mainBody.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
        } else {
            BackpackRenderInfo renderInfo = new BackpackRenderInfo(backpack, (RenderInfo)backpack.method_58694(ModDataComponents.RENDER_INFO));
            boolean backpackRendered = false;
            if (!renderInfo.isEmpty()) {
                this.tankLeftTop.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
                this.tankRightTop.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
                if (!renderInfo.getLeftTank().isEmpty()) {
                    RenderHelper.renderFluidInTank(renderInfo.getLeftTank(), poseStack, buffer, combinedLightIn, -0.65f, -0.565f, -0.24f);
                }
                if (!renderInfo.getRightTank().isEmpty()) {
                    RenderHelper.renderFluidInTank(renderInfo.getRightTank(), poseStack, buffer, combinedLightIn, 0.23f, -0.565f, -0.24f);
                }
            }
            if (renderInfo.hasSleepingBag()) {
                loc = item.getBackpackTexture();
                vertexConsumer = buffer.getBuffer(class_1921.method_23580((class_2960)loc));
                this.sleepingBagExtras.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
                loc = BackpackBlockModel.getSleepingBagTexture(renderInfo.getSleepingBagColor());
                vertexConsumer = buffer.getBuffer(class_1921.method_23580((class_2960)loc));
                this.sleepingBag.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (renderInfo.isDyed()) {
                loc = class_2960.method_60655((String)"travelersbackpack", (String)"textures/model/dyed.png");
                vertexConsumer = buffer.getBuffer(class_1921.method_23580((class_2960)loc));
                this.mainBody.method_22699(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn, class_9848.method_61334((int)((class_9282)renderInfo.getBackpack().method_58694(class_9334.field_49644)).comp_2384()));
                loc = class_2960.method_60655((String)"travelersbackpack", (String)"textures/model/dyed_extras.png");
                vertexConsumer = buffer.getBuffer(class_1921.method_23580((class_2960)loc));
                this.mainBody.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
                backpackRendered = true;
            }
            loc = item.getBackpackTexture();
            vertexConsumer = buffer.getBuffer(class_1921.method_23580((class_2960)loc));
            if (item == ModItems.FOX_TRAVELERS_BACKPACK) {
                this.foxNose.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (item == ModItems.OCELOT_TRAVELERS_BACKPACK) {
                this.ocelotNose.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (item == ModItems.WOLF_TRAVELERS_BACKPACK) {
                this.wolfNose.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (item == ModItems.VILLAGER_TRAVELERS_BACKPACK || item == ModItems.IRON_GOLEM_TRAVELERS_BACKPACK) {
                this.villagerNose.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (item == ModItems.PIG_TRAVELERS_BACKPACK || item == ModItems.HORSE_TRAVELERS_BACKPACK) {
                this.pigNose.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (item == ModItems.WARDEN_TRAVELERS_BACKPACK) {
                vertexConsumer = buffer.getBuffer(class_1921.method_23576((class_2960)loc));
                this.leftHorn.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
                this.rightHorn.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
                vertexConsumer = buffer.getBuffer(class_1921.method_23580((class_2960)loc));
            }
            if (item == ModItems.QUARTZ_TRAVELERS_BACKPACK || item == ModItems.SNOW_TRAVELERS_BACKPACK) {
                vertexConsumer = buffer.getBuffer(class_1921.method_29379((class_2960)item.getBackpackTexture()));
            }
            if (!backpackRendered) {
                this.mainBody.method_22698(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
        }
    }

    public static class_2960 getSleepingBagTexture(int color) {
        return class_2960.method_60655((String)"travelersbackpack", (String)("textures/model/bags/" + class_1767.method_7791((int)color).method_7792().toLowerCase(Locale.ENGLISH) + "_sleeping_bag.png"));
    }
}

