/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.monolib.core.sailing;

import com.cursee.monolib.Constants;
import com.cursee.monolib.core.CommonConfigValues;
import com.cursee.monolib.core.sailing.warden.SailingWarden;
import com.cursee.monolib.platform.Services;
import java.io.File;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import org.apache.commons.lang3.ArrayUtils;
import oshi.util.tuples.Pair;
import oshi.util.tuples.Triplet;

public class Sailing {
    private static final String CHECKED_TAG = "monolib.checked";
    private static final AtomicBoolean UNVERIFIED_INSTANCE = new AtomicBoolean(true);
    private static final Map<String, String> FILENAME_TO_MOD_NAME_MAP = new HashMap<String, String>();
    private static final Map<String, SailingEntry> MOD_NAME_TO_ENTRY_MAP = new HashMap<String, SailingEntry>();

    @Deprecated(since="2.0.0", forRemoval=true)
    public static void register(String modName, String modID, String modVersion, String minecraftVersion, Pair<String, String> publisherAuthorPair, Triplet<String, String, String> modURLTriplet) {
        Sailing.register(modID, modName, modVersion, (String)publisherAuthorPair.getA(), (String)modURLTriplet.getA());
    }

    @Deprecated(since="2.0.0", forRemoval=true)
    private static boolean shouldIgnore(String modID) {
        return switch (modID) {
            case "animal_armor_trims", "automessage", "more_beautiful_torches", "new_shield_variants", "time_on_display" -> true;
            default -> false;
        };
    }

    public static void register(String modID, String modName, String modVersion, String modPublisher, String modURL) {
        if (Sailing.shouldIgnore(modID)) {
            return;
        }
        String filename = modID + "-merged-1.21.5-" + modVersion + ".jar";
        FILENAME_TO_MOD_NAME_MAP.put(filename, modName);
        SailingEntry sailingEntry = new SailingEntry(modID, modName, modVersion, modPublisher, modURL);
        MOD_NAME_TO_ENTRY_MAP.put(modName, sailingEntry);
    }

    public static void onEntityJoinLevel(class_1297 entity, class_1937 level) {
        boolean ENTITY_IS_PLAYER = entity instanceof class_1657;
        boolean VERIFY_JAR_CONFIG_VALUE = CommonConfigValues.enable_jar_verification;
        boolean INSTANCE_UNVERIFIED = UNVERIFIED_INSTANCE.get();
        boolean ENTITY_CHECKED = entity.method_5752().contains(CHECKED_TAG);
        if (!ENTITY_IS_PLAYER || !VERIFY_JAR_CONFIG_VALUE || !INSTANCE_UNVERIFIED || ENTITY_CHECKED) {
            return;
        }
        class_1657 player = (class_1657)entity;
        if (!SailingWarden.UNSAFE_PATH_TO_UNSAFE_HOST_MAP.isEmpty()) {
            Sailing.sendMessage(player, "Unsafe download(s):", class_124.field_1068);
            Constants.LOG.info("Unsafe download(s):");
            for (String key : SailingWarden.UNSAFE_PATH_TO_UNSAFE_HOST_MAP.keySet()) {
                Sailing.sendMessage(player, "- " + key + " from " + SailingWarden.UNSAFE_PATH_TO_UNSAFE_HOST_MAP.get(key), class_124.field_1068);
                Constants.LOG.info("- {} from {}", (Object)key, (Object)SailingWarden.UNSAFE_PATH_TO_UNSAFE_HOST_MAP.get(key));
            }
        }
        Sailing.verifyJarFiles(player, level);
        entity.method_5780(CHECKED_TAG);
    }

    private static void verifyJarFiles(class_1657 player, class_1937 level) {
        if (!(level instanceof class_3218)) {
            return;
        }
        List<String> MOD_NAMES_MISSING_JAR_FILE = Sailing.getModNamesMissingJarFile();
        if (!MOD_NAMES_MISSING_JAR_FILE.isEmpty() && Sailing.preVerificationProcess(level)) {
            Sailing.sendMessage(player, "Mod(s) from incorrect sources:", class_124.field_1061);
            for (String modName : MOD_NAMES_MISSING_JAR_FILE) {
                SailingEntry entry = MOD_NAME_TO_ENTRY_MAP.get(modName);
                Sailing.sendMessage(player, modName + " by " + entry.modPublisher() + " (Click Here)", class_124.field_1054, entry.modURL());
            }
            Sailing.sendMessage(player, "You a receiving this message because one or more of your mod files has been altered and possibly not downloaded from an original and safe source. Unofficial sources can contain malicious software or host outdated versions of mods, as well as removing ad revenue from mod authors.", class_124.field_1061);
            Sailing.sendMessage(player, "Click on the name of the mod above to find it's original posting.", class_124.field_1077);
            Sailing.sendMessage(player, "You won't see this message again in this instance. Thank you for reading.", class_124.field_1077);
            Constants.LOG.info("You a receiving this message because one or more of your mod files has been altered and possibly not downloaded from an original and safe source. Unofficial sources can contain malicious software or host outdated versions of mods, as well as removing ad revenue from mod authors.");
            Constants.LOG.info("Click on the name of the mod above to find it's original posting.");
            Constants.LOG.info("You won't see this message again in this instance. Thank you for reading.");
            Sailing.postVerificationProcess(level);
        }
        UNVERIFIED_INSTANCE.set(false);
    }

    private static boolean preVerificationProcess(class_1937 level) {
        Object path = ((class_3218)level).method_8503().method_27050(class_5218.field_24188).toString();
        path = ((String)path).substring(0, ((String)path).length() - 2) + File.separator + "config" + File.separator + "monolib" + File.separator + "checked.txt";
        File checkFile = new File((String)path);
        String alternativePath = Services.PLATFORM.getGameDirectory() + File.separator + "config" + File.separator + "monolib" + File.separator + "checked.txt";
        File alternativeFile = new File(alternativePath);
        if (checkFile.exists()) {
            UNVERIFIED_INSTANCE.set(false);
        } else if (alternativeFile.exists()) {
            UNVERIFIED_INSTANCE.set(false);
        }
        return UNVERIFIED_INSTANCE.get();
    }

    private static void postVerificationProcess(class_1937 level) {
        UNVERIFIED_INSTANCE.set(false);
        Object path = ((class_3218)level).method_8503().method_27050(class_5218.field_24188).toString();
        path = ((String)path).substring(0, ((String)path).length() - 2) + File.separator + "config" + File.separator + "monolib";
        File directory = new File((String)path);
        if (!directory.mkdirs()) {
            return;
        }
        try (PrintWriter writer2 = new PrintWriter((String)path + File.separator + "checked.txt", StandardCharsets.UTF_8);){
            writer2.println("# Please check out https://stopmodreposts.org/ for more information on why this feature exists.");
            writer2.println("checked=true");
        }
        catch (Exception writer2) {
            // empty catch block
        }
        Object alternativePath = Services.PLATFORM.getGameDirectory();
        alternativePath = (String)alternativePath + File.separator + "config" + File.separator + "monolib";
        if (new File((String)alternativePath + File.separator + "checked.txt").isFile()) {
            return;
        }
        File alternativeDirectory = new File((String)alternativePath);
        if (!alternativeDirectory.mkdirs()) {
            return;
        }
        try (PrintWriter writer = new PrintWriter((String)alternativePath + File.separator + "checked.txt", StandardCharsets.UTF_8);){
            writer.println("# Please check out https://stopmodreposts.org/ for more information on why this feature exists.");
            writer.println("checked=true");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static List<String> getInstalledModFilenames() {
        ArrayList<String> INSTALLED_MOD_FILENAMES = new ArrayList<String>();
        File MOD_DIRECTORY = new File(Services.PLATFORM.getGameDirectory() + File.separator + "mods");
        Object[] DISCOVERED_FILES = MOD_DIRECTORY.listFiles();
        File VERSIONED_MOD_DIRECTORY = new File(Services.PLATFORM.getGameDirectory() + File.separator + "mods" + File.separator + "1.21.5");
        Object[] DISCOVERED_VERSIONED_FILES = VERSIONED_MOD_DIRECTORY.listFiles();
        if (DISCOVERED_FILES == null && DISCOVERED_VERSIONED_FILES == null) {
            return new ArrayList<String>();
        }
        for (File file : (File[])ArrayUtils.addAll((Object[])DISCOVERED_FILES, (Object[])DISCOVERED_VERSIONED_FILES)) {
            if (!file.isFile()) continue;
            String filename = file.getName().replaceAll(" +\\([0-9]+\\)", "");
            INSTALLED_MOD_FILENAMES.add(filename);
        }
        return INSTALLED_MOD_FILENAMES;
    }

    private static List<String> getModNamesMissingJarFile() {
        List<String> INSTALLED_MOD_FILENAMES = Sailing.getInstalledModFilenames();
        ArrayList<String> MOD_NAMES_MISSING_JAR_FILE = new ArrayList<String>();
        for (String filename : FILENAME_TO_MOD_NAME_MAP.keySet()) {
            boolean CONTAINS_MERGED = INSTALLED_MOD_FILENAMES.contains(filename);
            boolean CONTAINS_FABRIC = INSTALLED_MOD_FILENAMES.contains(filename.replace("-merged-", "-fabric-"));
            boolean CONTAINS_FORGE = INSTALLED_MOD_FILENAMES.contains(filename.replace("-merged-", "-forge-"));
            boolean CONTAINS_NEOFORGE = INSTALLED_MOD_FILENAMES.contains(filename.replace("-merged-", "-neoforge-"));
            if (INSTALLED_MOD_FILENAMES.isEmpty() || CONTAINS_MERGED || CONTAINS_FABRIC || CONTAINS_FORGE || CONTAINS_NEOFORGE || !FILENAME_TO_MOD_NAME_MAP.containsKey(filename)) continue;
            MOD_NAMES_MISSING_JAR_FILE.add(FILENAME_TO_MOD_NAME_MAP.get(filename));
        }
        if (!MOD_NAMES_MISSING_JAR_FILE.isEmpty()) {
            Collections.sort(MOD_NAMES_MISSING_JAR_FILE);
        }
        return MOD_NAMES_MISSING_JAR_FILE;
    }

    public static void sendMessage(class_1657 player, String message, class_124 colour, boolean insertNewLineBeforeMessage, String url) {
        if (message.isEmpty()) {
            return;
        }
        if (insertNewLineBeforeMessage) {
            player.method_7353((class_2561)class_2561.method_43470((String)""), false);
        }
        class_5250 mutableMessage = class_2561.method_43470((String)message);
        mutableMessage.method_27692(colour);
        if (message.contains("http") || url != null && !url.isEmpty()) {
            if (url != null && url.isEmpty()) {
                for (String word : message.split(" ")) {
                    if (!word.contains("http")) continue;
                    url = word;
                    break;
                }
            }
            if (url != null && !url.isEmpty()) {
                try {
                    class_2583 clickstyle = mutableMessage.method_10866().method_10958((class_2558)new class_2558.class_10608(new URI(url)));
                    mutableMessage.method_27696(clickstyle);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        player.method_7353((class_2561)mutableMessage, false);
    }

    public static void sendMessage(class_1657 player, String message, class_124 color, String url) {
        Sailing.sendMessage(player, message, color, false, url);
    }

    public static void sendMessage(class_1657 player, String message, class_124 color) {
        Sailing.sendMessage(player, message, color, null);
    }

    public record SailingEntry(String modID, String modName, String modVersion, String modPublisher, String modURL) {
    }
}

