/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic;

import fuzs.easymagic.config.ClientConfig;
import fuzs.easymagic.config.CommonConfig;
import fuzs.easymagic.config.ServerConfig;
import fuzs.easymagic.handler.BlockConversionHandler;
import fuzs.easymagic.init.ModRegistry;
import fuzs.easymagic.network.ClientboundCluesMessage;
import fuzs.easymagic.world.level.block.EnchantmentTableWithInventoryBlock;
import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.context.PayloadTypesContext;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.event.v1.AddBlockEntityTypeBlocksCallback;
import fuzs.puzzleslib.api.event.v1.RegistryEntryAddedCallback;
import fuzs.puzzleslib.api.event.v1.core.EventPhase;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerInteractEvents;
import fuzs.puzzleslib.api.event.v1.server.TagsUpdatedCallback;
import java.util.function.Predicate;
import net.minecraft.class_2248;
import net.minecraft.class_2331;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyMagic
implements ModConstructor {
    public static final String MOD_ID = "easymagic";
    public static final String MOD_NAME = "Easy Magic";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Easy Magic");
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"easymagic").client(ClientConfig.class).common(CommonConfig.class).server(ServerConfig.class);
    public static final Predicate<class_2248> BLOCK_PREDICATE = block -> block instanceof class_2331 && !(block instanceof EnchantmentTableWithInventoryBlock);

    public void onConstructMod() {
        ModRegistry.bootstrap();
        EasyMagic.registerLoadingHandlers();
    }

    private static void registerLoadingHandlers() {
        RegistryEntryAddedCallback.registryEntryAdded((class_5321)class_7924.field_41254).register(BlockConversionHandler.onRegistryEntryAdded(BLOCK_PREDICATE, EnchantmentTableWithInventoryBlock::new, MOD_ID));
        AddBlockEntityTypeBlocksCallback.EVENT.register((Object)BlockConversionHandler.onAddBlockEntityTypeBlocks(ModRegistry.ENCHANTING_TABLE_BLOCK_ENTITY_TYPE));
    }

    public void onCommonSetup() {
        EasyMagic.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        PlayerInteractEvents.USE_BLOCK.register((Object)BlockConversionHandler.onUseBlock(ModRegistry.UNALTERED_ENCHANTING_TABLES_BLOCK_TAG, () -> ((CommonConfig)EasyMagic.CONFIG.get(CommonConfig.class)).disableVanillaEnchantingTable));
        TagsUpdatedCallback.EVENT.register(EventPhase.FIRST, (Object)BlockConversionHandler.onTagsUpdated(ModRegistry.UNALTERED_ENCHANTING_TABLES_BLOCK_TAG, BLOCK_PREDICATE));
    }

    public void onRegisterPayloadTypes(PayloadTypesContext context) {
        context.playToClient(ClientboundCluesMessage.class, ClientboundCluesMessage.STREAM_CODEC);
    }

    public static class_2960 id(String path) {
        return ResourceLocationHelper.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

