/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.season;

import com.google.common.collect.Lists;
import glitchcore.event.TickEvent;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2386;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_3193;
import net.minecraft.class_3204;
import net.minecraft.class_3218;
import net.minecraft.class_3898;
import net.minecraft.class_5268;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.SeasonsConfig;
import sereneseasons.init.ModConfig;
import sereneseasons.init.ModTags;
import sereneseasons.season.SeasonHooks;

public class RandomUpdateHandler {
    private static void adjustWeatherFrequency(class_1937 world, Season.SubSeason subSeason) {
        if (!ModConfig.seasons.changeWeatherFrequency) {
            return;
        }
        class_5268 serverLevelData = (class_5268)world.method_8401();
        SeasonsConfig.SeasonProperties seasonProperties = ModConfig.seasons.getSeasonProperties(subSeason);
        if (seasonProperties.canRain()) {
            if (!world.method_8401().method_156() && serverLevelData.method_190() > seasonProperties.maxRainTime()) {
                serverLevelData.method_164(world.field_9229.method_43048(seasonProperties.maxRainTime() - seasonProperties.minRainTime()) + seasonProperties.minRainTime());
            }
        } else if (serverLevelData.method_156()) {
            serverLevelData.method_157(false);
        }
        if (seasonProperties.canThunder()) {
            if (!world.method_8401().method_203() && serverLevelData.method_145() > seasonProperties.maxThunderTime()) {
                serverLevelData.method_173(world.field_9229.method_43048(seasonProperties.maxThunderTime() - seasonProperties.minThunderTime()) + seasonProperties.minThunderTime());
            }
        } else if (serverLevelData.method_203()) {
            serverLevelData.method_147(false);
        }
    }

    private static void meltInChunk(class_3898 chunkMap, class_2818 chunkIn, float meltChance) {
        class_3218 world = chunkMap.field_17214;
        class_1923 chunkpos = chunkIn.method_12004();
        int i = chunkpos.method_8326();
        int j = chunkpos.method_8328();
        if (meltChance > 0.0f && world.field_9229.method_43057() < meltChance) {
            class_2338 topAirPos = world.method_8598(class_2902.class_2903.field_13197, world.method_8536(i, 0, j, 15));
            class_2338 topGroundPos = topAirPos.method_10074();
            class_2680 aboveGroundState = world.method_8320(topAirPos);
            class_2680 groundState = world.method_8320(topGroundPos);
            class_6880 biome = world.method_23753(topAirPos);
            class_6880 groundBiome = world.method_23753(topGroundPos);
            if (!biome.method_40220(ModTags.Biomes.BLACKLISTED_BIOMES) && SeasonHooks.getBiomeTemperature((class_1937)world, (class_6880<class_1959>)biome, topGroundPos, world.method_8615()) >= 0.15f && aboveGroundState.method_26204() == class_2246.field_10477) {
                world.method_8501(topAirPos, class_2246.field_10124.method_9564());
            }
            if (!groundBiome.method_40220(ModTags.Biomes.BLACKLISTED_BIOMES) && SeasonHooks.getBiomeTemperature((class_1937)world, (class_6880<class_1959>)groundBiome, topGroundPos, world.method_8615()) >= 0.15f && groundState.method_26204() == class_2246.field_10295) {
                ((class_2386)class_2246.field_10295).method_10275(groundState, (class_1937)world, topGroundPos);
            }
        }
    }

    public static void onWorldTick(TickEvent.Level event) {
        if (event.getPhase() != TickEvent.Phase.END || event.getLevel().method_8608()) {
            return;
        }
        class_3218 level = (class_3218)event.getLevel();
        Season.SubSeason subSeason = SeasonHelper.getSeasonState((class_1937)level).getSubSeason();
        Season season = subSeason.getSeason();
        SeasonsConfig.SeasonProperties seasonProperties = ModConfig.seasons.getSeasonProperties(subSeason);
        float meltRand = seasonProperties.meltChance() / 100.0f;
        int rolls = seasonProperties.meltRolls();
        RandomUpdateHandler.adjustWeatherFrequency((class_1937)level, subSeason);
        if (rolls > 0 && meltRand > 0.0f && ModConfig.seasons.generateSnowAndIce && ModConfig.seasons.isDimensionWhitelisted((class_5321<class_1937>)level.method_27983())) {
            class_3898 chunkMap = level.method_14178().field_17254;
            class_3204 distanceManager = chunkMap.method_17263();
            int l = distanceManager.method_14052();
            ArrayList list = Lists.newArrayListWithCapacity((int)l);
            for (class_3193 chunkholder : chunkMap.method_17264()) {
                class_2818 levelchunk = chunkholder.method_16144();
                if (levelchunk == null) continue;
                list.add(new ChunkAndHolder(levelchunk, chunkholder));
            }
            Collections.shuffle(list);
            for (ChunkAndHolder serverchunkcache$chunkandholder : list) {
                class_2818 levelChunk = serverchunkcache$chunkandholder.chunk;
                class_1923 chunkpos = levelChunk.method_12004();
                if (!chunkMap.method_38783(chunkpos) || !level.method_39425(chunkpos.method_8324())) continue;
                for (int i = 0; i < rolls; ++i) {
                    RandomUpdateHandler.meltInChunk(chunkMap, levelChunk, meltRand);
                }
            }
        }
    }

    record ChunkAndHolder(class_2818 chunk, class_3193 holder) {
    }
}

