/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.reeses_sodium_options.client.gui.frame.components;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import me.flashyreese.mods.reeses_sodium_options.client.gui.OptionExtended;
import me.flashyreese.mods.reeses_sodium_options.client.gui.SodiumVideoOptionsScreen;
import me.flashyreese.mods.reeses_sodium_options.util.StringUtils;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.widgets.AbstractWidget;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;

public class SearchTextFieldComponent
extends AbstractWidget {
    protected final Dim2i dim;
    protected final List<OptionPage> pages;
    private final FontRenderer textRenderer;
    private final Predicate<String> textPredicate;
    private final BiFunction<String, Integer, IReorderingProcessor> renderTextProvider;
    private final AtomicReference<String> tabFrameSelectedTab;
    private final AtomicReference<Integer> tabFrameScrollBarOffset;
    private final AtomicReference<Integer> optionPageScrollBarOffset;
    private final int tabDimHeight;
    private final SodiumVideoOptionsScreen sodiumVideoOptionsScreen;
    private final AtomicReference<String> lastSearch;
    private final AtomicReference<Integer> lastSearchIndex;
    protected boolean selecting;
    protected String text;
    protected int maxLength;
    protected boolean visible;
    protected boolean editable;
    private int firstCharacterIndex;
    private int selectionStart;
    private int selectionEnd;
    private boolean focused;
    private int lastCursorPosition;

    public SearchTextFieldComponent(Dim2i dim, List<OptionPage> pages, AtomicReference<String> tabFrameSelectedTab, AtomicReference<Integer> tabFrameScrollBarOffset, AtomicReference<Integer> optionPageScrollBarOffset, int tabDimHeight, SodiumVideoOptionsScreen sodiumVideoOptionsScreen, AtomicReference<String> lastSearch, AtomicReference<Integer> lastSearchIndex) {
        this.textRenderer = Minecraft.func_71410_x().field_71466_p;
        this.textPredicate = Objects::nonNull;
        this.renderTextProvider = (string, firstCharacterIndex) -> IReorderingProcessor.func_242239_a((String)string, (Style)Style.field_240709_b_);
        this.text = "";
        this.maxLength = 100;
        this.visible = true;
        this.editable = true;
        this.lastCursorPosition = this.getCursor();
        this.dim = dim;
        this.pages = pages;
        this.tabFrameSelectedTab = tabFrameSelectedTab;
        this.tabFrameScrollBarOffset = tabFrameScrollBarOffset;
        this.optionPageScrollBarOffset = optionPageScrollBarOffset;
        this.tabDimHeight = tabDimHeight;
        this.sodiumVideoOptionsScreen = sodiumVideoOptionsScreen;
        this.lastSearch = lastSearch;
        this.lastSearchIndex = lastSearchIndex;
        if (!lastSearch.get().trim().isEmpty()) {
            this.write(lastSearch.get());
        }
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float delta) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isFocused() && this.text.isEmpty()) {
            String key = "rso.search_bar_empty";
            TranslationTextComponent text = new TranslationTextComponent(key);
            if (text.getString().equals(key)) {
                text = new StringTextComponent("Search options...");
            }
            this.textRenderer.func_243248_b(matrixStack, (ITextComponent)text, (float)(this.dim.getOriginX() + 6), (float)(this.dim.getOriginY() + 6), -5592406);
        }
        this.drawRect(this.dim.getOriginX(), this.dim.getOriginY(), this.dim.getLimitX(), this.dim.getLimitY(), this.isFocused() ? -536870912 : -1879048192);
        int j = this.selectionStart - this.firstCharacterIndex;
        int k = this.selectionEnd - this.firstCharacterIndex;
        String string = this.textRenderer.func_238412_a_(this.text.substring(this.firstCharacterIndex), this.getInnerWidth());
        boolean bl = j >= 0 && j <= string.length();
        int l = this.dim.getOriginX() + 6;
        int m = this.dim.getOriginY() + 6;
        int n = l;
        if (k > string.length()) {
            k = string.length();
        }
        if (!string.isEmpty()) {
            String string2 = bl ? string.substring(0, j) : string;
            n = this.textRenderer.func_238407_a_(matrixStack, this.renderTextProvider.apply(string2, this.firstCharacterIndex), (float)n, (float)m, -1);
        }
        boolean bl3 = this.selectionStart < this.text.length() || this.text.length() >= this.getMaxLength();
        int o = n;
        if (!bl) {
            o = j > 0 ? l + this.dim.getWidth() - 12 : l;
        } else if (bl3) {
            --o;
            --n;
        }
        if (!string.isEmpty() && bl && j < string.length()) {
            this.textRenderer.func_238407_a_(matrixStack, this.renderTextProvider.apply(string.substring(j), this.selectionStart), (float)n, (float)m, -1);
        }
        if (this.isFocused()) {
            Objects.requireNonNull(this.textRenderer);
            AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)o, (int)(m - 1), (int)(o + 1), (int)(m + 1 + 9), (int)-3092272);
        }
        if (k != j) {
            int p = l + this.textRenderer.func_78256_a(string.substring(0, k));
            Objects.requireNonNull(this.textRenderer);
            this.drawSelectionHighlight(matrixStack, o, m - 1, p - 1, m + 1 + 9);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        int i = MathHelper.func_76128_c((double)mouseX) - this.dim.getOriginX() - 6;
        String string = this.textRenderer.func_238412_a_(this.text.substring(this.firstCharacterIndex), this.getInnerWidth());
        this.setCursor(this.textRenderer.func_238412_a_(string, i).length() + this.firstCharacterIndex);
        this.setFocused(this.dim.containsCursor(mouseX, mouseY));
        this.pages.forEach(page -> page.getOptions().stream().filter(OptionExtended.class::isInstance).map(OptionExtended.class::cast).forEach(optionExtended -> optionExtended.setSelected(false)));
        return this.isFocused();
    }

    private void drawSelectionHighlight(MatrixStack matrixStack, int x1, int y1, int x2, int y2) {
        int i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        if (x2 > this.dim.getOriginX() + this.dim.getWidth()) {
            x2 = this.dim.getOriginX() + this.dim.getWidth();
        }
        if (x1 > this.dim.getOriginX() + this.dim.getWidth()) {
            x1 = this.dim.getOriginX() + this.dim.getWidth();
        }
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)x1, (int)y1, (int)x2, (int)y2, (int)-16776961);
    }

    private int getMaxLength() {
        return this.maxLength;
    }

    public String getSelectedText() {
        int i = Math.min(this.selectionStart, this.selectionEnd);
        int j = Math.max(this.selectionStart, this.selectionEnd);
        return this.text.substring(i, j);
    }

    public void write(String text) {
        String string2;
        String string;
        int l;
        int i = Math.min(this.selectionStart, this.selectionEnd);
        int j = Math.max(this.selectionStart, this.selectionEnd);
        int k = this.maxLength - this.text.length() - (i - j);
        if (k < (l = (string = SharedConstants.func_71565_a((String)text)).length())) {
            string = string.substring(0, k);
            l = k;
        }
        if (this.textPredicate.test(string2 = new StringBuilder(this.text).replace(i, j, string).toString())) {
            this.text = string2;
            this.setSelectionStart(i + l);
            this.setSelectionEnd(this.selectionStart);
            this.onChanged(this.text);
        }
    }

    private void onChanged(String newText) {
        this.pages.forEach(page -> page.getOptions().stream().filter(OptionExtended.class::isInstance).map(OptionExtended.class::cast).forEach(optionExtended -> optionExtended.setHighlight(false)));
        this.lastSearch.set(newText.trim());
        if (this.editable && !newText.trim().isEmpty()) {
            List<Option<?>> fuzzy = StringUtils.fuzzySearch(this.pages, newText, 2);
            fuzzy.stream().filter(OptionExtended.class::isInstance).map(OptionExtended.class::cast).forEach(optionExtended -> optionExtended.setHighlight(true));
        }
    }

    private void erase(int offset) {
        if (Screen.func_231172_r_()) {
            this.eraseWords(offset);
        } else {
            this.eraseCharacters(offset);
        }
    }

    public void eraseWords(int wordOffset) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.selectionStart) {
                this.write("");
            } else {
                this.eraseCharacters(this.getWordSkipPosition(wordOffset) - this.selectionStart);
            }
        }
    }

    public void eraseCharacters(int characterOffset) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.selectionStart) {
                this.write("");
            } else {
                String string;
                int k;
                int i = this.getCursorPosWithOffset(characterOffset);
                int j = Math.min(i, this.selectionStart);
                if (j != (k = Math.max(i, this.selectionStart)) && this.textPredicate.test(string = new StringBuilder(this.text).delete(j, k).toString())) {
                    this.text = string;
                    this.setCursor(j);
                    this.onChanged(this.text);
                }
            }
        }
    }

    public int getWordSkipPosition(int wordOffset) {
        return this.getWordSkipPosition(wordOffset, this.getCursor());
    }

    private int getWordSkipPosition(int wordOffset, int cursorPosition) {
        return this.getWordSkipPosition(wordOffset, cursorPosition, true);
    }

    private int getWordSkipPosition(int wordOffset, int cursorPosition, boolean skipOverSpaces) {
        int i = cursorPosition;
        boolean bl = wordOffset < 0;
        int j = Math.abs(wordOffset);
        for (int k = 0; k < j; ++k) {
            if (!bl) {
                int l = this.text.length();
                if ((i = this.text.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (skipOverSpaces && i < l && this.text.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (skipOverSpaces && i > 0 && this.text.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.text.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public int getCursor() {
        return this.selectionStart;
    }

    public void setCursor(int cursor) {
        this.setSelectionStart(cursor);
        if (!this.selecting) {
            this.setSelectionEnd(this.selectionStart);
        }
        this.onChanged(this.text);
    }

    public void moveCursor(int offset) {
        this.setCursor(this.getCursorPosWithOffset(offset));
    }

    private int getCursorPosWithOffset(int offset) {
        return Util.func_240980_a_((String)this.text, (int)this.selectionStart, (int)offset);
    }

    public void setSelectionStart(int cursor) {
        this.selectionStart = MathHelper.func_76125_a((int)cursor, (int)0, (int)this.text.length());
    }

    public void setCursorToStart() {
        this.setCursor(0);
    }

    public void setCursorToEnd() {
        this.setCursor(this.text.length());
    }

    public void setSelectionEnd(int index) {
        int i = this.text.length();
        this.selectionEnd = MathHelper.func_76125_a((int)index, (int)0, (int)i);
        if (this.textRenderer != null) {
            if (this.firstCharacterIndex > i) {
                this.firstCharacterIndex = i;
            }
            int j = this.getInnerWidth();
            String string = this.textRenderer.func_238412_a_(this.text.substring(this.firstCharacterIndex), j);
            int k = string.length() + this.firstCharacterIndex;
            if (this.selectionEnd == this.firstCharacterIndex) {
                this.firstCharacterIndex -= this.textRenderer.func_238413_a_(this.text, j, true).length();
            }
            if (this.selectionEnd > k) {
                this.firstCharacterIndex += this.selectionEnd - k;
            } else if (this.selectionEnd <= this.firstCharacterIndex) {
                this.firstCharacterIndex -= this.firstCharacterIndex - this.selectionEnd;
            }
            this.firstCharacterIndex = MathHelper.func_76125_a((int)this.firstCharacterIndex, (int)0, (int)i);
        }
    }

    public boolean isActive() {
        return this.isVisible() && this.isFocused() && this.isEditable();
    }

    public boolean func_231042_a_(char chr, int modifiers) {
        if (!this.isActive()) {
            return false;
        }
        if (SharedConstants.func_71566_a((char)chr)) {
            if (this.editable) {
                this.lastSearch.set(this.text.trim());
                this.write(Character.toString(chr));
                this.lastSearchIndex.set(0);
            }
            return true;
        }
        return false;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        this.pages.forEach(page2 -> page2.getOptions().stream().filter(OptionExtended.class::isInstance).map(OptionExtended.class::cast).forEach(optionExtended2 -> optionExtended2.setSelected(false)));
        if (!this.isActive()) {
            return false;
        }
        this.selecting = Screen.func_231173_s_();
        if (Screen.func_231170_j_((int)keyCode)) {
            this.setCursorToEnd();
            this.setSelectionEnd(0);
            return true;
        }
        if (Screen.func_231169_i_((int)keyCode)) {
            Minecraft.func_71410_x().field_195559_v.func_197960_a(this.getSelectedText());
            return true;
        }
        if (Screen.func_231168_h_((int)keyCode)) {
            if (this.editable) {
                this.write(Minecraft.func_71410_x().field_195559_v.func_197965_a());
            }
            return true;
        }
        if (Screen.func_231166_g_((int)keyCode)) {
            Minecraft.func_71410_x().field_195559_v.func_197960_a(this.getSelectedText());
            if (this.editable) {
                this.write("");
            }
            return true;
        }
        switch (keyCode) {
            case 257: {
                if (this.editable) {
                    int count = 0;
                    for (OptionPage page : this.pages) {
                        for (Option option : page.getOptions()) {
                            OptionExtended optionExtended;
                            if (!(option instanceof OptionExtended) || !(optionExtended = (OptionExtended)option).isHighlight() || optionExtended.getParentDimension() == null) continue;
                            if (count == this.lastSearchIndex.get()) {
                                Dim2i optionDim = optionExtended.getDim2i();
                                Dim2i parentDim = optionExtended.getParentDimension();
                                int maxOffset = parentDim.getHeight() - this.tabDimHeight;
                                int input = optionDim.getOriginY() - parentDim.getOriginY();
                                int inputOffset = input + optionDim.getHeight() == parentDim.getHeight() ? parentDim.getHeight() : input;
                                int offset = inputOffset * maxOffset / parentDim.getHeight();
                                int total = this.pages.stream().mapToInt(page2 -> Math.toIntExact(page2.getOptions().stream().filter(OptionExtended.class::isInstance).map(OptionExtended.class::cast).filter(OptionExtended::isHighlight).count())).sum();
                                int value = total == this.lastSearchIndex.get() + 1 ? 0 : this.lastSearchIndex.get() + 1;
                                optionExtended.setSelected(true);
                                this.lastSearchIndex.set(value);
                                this.tabFrameSelectedTab.set(page.getName());
                                this.tabFrameScrollBarOffset.set(0);
                                this.optionPageScrollBarOffset.set(offset);
                                this.setFocused(false);
                                this.sodiumVideoOptionsScreen.rebuildUI();
                                return true;
                            }
                            ++count;
                        }
                    }
                }
                return true;
            }
            case 259: {
                if (this.editable) {
                    this.selecting = false;
                    this.erase(-1);
                    this.selecting = Screen.func_231173_s_();
                }
                return true;
            }
            case 261: {
                if (this.editable) {
                    this.selecting = false;
                    this.erase(1);
                    this.selecting = Screen.func_231173_s_();
                }
                return true;
            }
            case 262: {
                if (Screen.func_231172_r_()) {
                    this.setCursor(this.getWordSkipPosition(1));
                } else {
                    this.moveCursor(1);
                }
                boolean state = this.getCursor() != this.lastCursorPosition && this.getCursor() != this.text.length() + 1;
                this.lastCursorPosition = this.getCursor();
                return state;
            }
            case 263: {
                if (Screen.func_231172_r_()) {
                    this.setCursor(this.getWordSkipPosition(-1));
                } else {
                    this.moveCursor(-1);
                }
                boolean state2 = this.getCursor() != this.lastCursorPosition && this.getCursor() != 0;
                this.lastCursorPosition = this.getCursor();
                return state2;
            }
            case 268: {
                this.setCursorToStart();
                return true;
            }
            case 269: {
                this.setCursorToEnd();
                return true;
            }
        }
        return false;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public int getInnerWidth() {
        return this.dim.getWidth() - 12;
    }
}

