/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.reeses_sodium_options.client.gui.frame;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.List;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlElement;
import me.jellysquid.mods.sodium.client.gui.widgets.AbstractWidget;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.INestedGuiEventHandler;
import net.minecraft.client.gui.IRenderable;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFrame
extends AbstractWidget
implements INestedGuiEventHandler {
    protected final Dim2i dim;
    protected final List<AbstractWidget> children = new ArrayList<AbstractWidget>();
    protected final List<IRenderable> drawable = new ArrayList<IRenderable>();
    protected final List<ControlElement<?>> controlElements = new ArrayList();
    protected boolean renderOutline;
    private IGuiEventListener focused;
    private boolean dragging;

    public AbstractFrame(Dim2i dim, boolean renderOutline) {
        this.dim = dim;
        this.renderOutline = renderOutline;
    }

    public void buildFrame() {
        for (IGuiEventListener iGuiEventListener : this.children) {
            if (iGuiEventListener instanceof AbstractFrame) {
                this.controlElements.addAll(((AbstractFrame)iGuiEventListener).controlElements);
            }
            if (iGuiEventListener instanceof ControlElement) {
                this.controlElements.add((ControlElement)iGuiEventListener);
            }
            if (!(iGuiEventListener instanceof IRenderable)) continue;
            this.drawable.add((IRenderable)iGuiEventListener);
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float delta) {
        if (this.renderOutline) {
            this.drawRectOutline(this.dim.getOriginX(), this.dim.getOriginY(), this.dim.getLimitX(), this.dim.getLimitY(), -5592406);
        }
        for (IRenderable drawable : this.drawable) {
            drawable.func_230430_a_(matrixStack, mouseX, mouseY, delta);
        }
    }

    public void applyScissor(int x, int y, int width, int height, Runnable action) {
        double scale = Minecraft.func_71410_x().func_228018_at_().func_198100_s();
        RenderSystem.enableScissor((int)((int)((double)x * scale)), (int)((int)((double)Minecraft.func_71410_x().func_228018_at_().func_198091_l() - (double)(y + height) * scale)), (int)((int)((double)width * scale)), (int)((int)((double)height * scale)));
        action.run();
        RenderSystem.disableScissor();
    }

    protected void drawRectOutline(double x, double y, double w, double h, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        this.drawQuads(vertices -> {
            AbstractFrame.addQuad((IVertexBuilder)vertices, (double)x, (double)y, (double)w, (double)(y + 1.0), (float)a, (float)r, (float)g, (float)b);
            AbstractFrame.addQuad((IVertexBuilder)vertices, (double)x, (double)(h - 1.0), (double)w, (double)h, (float)a, (float)r, (float)g, (float)b);
            AbstractFrame.addQuad((IVertexBuilder)vertices, (double)x, (double)y, (double)(x + 1.0), (double)h, (float)a, (float)r, (float)g, (float)b);
            AbstractFrame.addQuad((IVertexBuilder)vertices, (double)(w - 1.0), (double)y, (double)w, (double)h, (float)a, (float)r, (float)g, (float)b);
        });
    }

    public boolean func_231041_ay__() {
        return this.dragging;
    }

    public void func_231037_b__(boolean dragging) {
        this.dragging = dragging;
    }

    @Nullable
    public IGuiEventListener func_241217_q_() {
        return this.focused;
    }

    public void func_231035_a_(@Nullable IGuiEventListener focused) {
        this.focused = focused;
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        return this.children;
    }

    public boolean func_231047_b_(double mouseX, double mouseY) {
        return this.dim.containsCursor(mouseX, mouseY);
    }
}

