/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.reeses_sodium_options.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.AbstractFrame;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.BasicFrame;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.components.SearchTextFieldComponent;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.tab.Tab;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.tab.TabFrame;
import me.flashyreese.mods.reeses_sodium_options.compat.IrisCompat;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionFlag;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.storage.OptionStorage;
import me.jellysquid.mods.sodium.client.gui.widgets.FlatButtonWidget;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.VideoSettingsScreen;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class SodiumVideoOptionsScreen
extends Screen {
    private static final AtomicReference<String> tabFrameSelectedTab = new AtomicReference<Object>(null);
    private static final AtomicReference<Integer> tabFrameScrollBarOffset = new AtomicReference<Integer>(0);
    private static final AtomicReference<Integer> optionPageScrollBarOffset = new AtomicReference<Integer>(0);
    private static final AtomicReference<String> lastSearch = new AtomicReference<String>("");
    private static final AtomicReference<Integer> lastSearchIndex = new AtomicReference<Integer>(0);
    private final Screen prevScreen;
    private final List<OptionPage> pages = new ArrayList<OptionPage>();
    private AbstractFrame frame;
    private FlatButtonWidget applyButton;
    private FlatButtonWidget closeButton;
    private FlatButtonWidget undoButton;
    private FlatButtonWidget donateButton;
    private FlatButtonWidget hideDonateButton;
    private boolean hasPendingChanges;
    private SearchTextFieldComponent searchTextField;

    public SodiumVideoOptionsScreen(Screen prev, List<OptionPage> pages) {
        super((ITextComponent)new StringTextComponent("Reese's Sodium Menu"));
        this.prevScreen = prev;
        this.pages.addAll(pages);
    }

    public void rebuildUI() {
        this.field_230705_e_.clear();
        this.func_231160_c_();
    }

    protected void func_231160_c_() {
        this.frame = this.parentFrameBuilder().build();
        this.field_230705_e_.add(this.frame);
        this.searchTextField.setFocused(!lastSearch.get().trim().isEmpty());
        if (this.searchTextField.isFocused()) {
            this.func_231035_a_((IGuiEventListener)this.searchTextField);
        } else {
            this.func_231035_a_((IGuiEventListener)this.frame);
        }
    }

    protected BasicFrame.Builder parentFrameBuilder() {
        int newWidth = this.field_230708_k_;
        if ((double)((float)this.field_230708_k_ / (float)this.field_230709_l_) > 1.77777777778) {
            newWidth = (int)((double)this.field_230709_l_ * 1.77777777778);
        }
        Dim2i basicFrameDim = new Dim2i((this.field_230708_k_ - newWidth) / 2, 0, newWidth, this.field_230709_l_);
        Dim2i tabFrameDim = new Dim2i(basicFrameDim.getOriginX() + basicFrameDim.getWidth() / 20 / 2, basicFrameDim.getOriginY() + basicFrameDim.getHeight() / 4 / 2, basicFrameDim.getWidth() - basicFrameDim.getWidth() / 20, basicFrameDim.getHeight() / 4 * 3);
        Dim2i undoButtonDim = new Dim2i(tabFrameDim.getLimitX() - 203, tabFrameDim.getLimitY() + 5, 65, 20);
        Dim2i applyButtonDim = new Dim2i(tabFrameDim.getLimitX() - 134, tabFrameDim.getLimitY() + 5, 65, 20);
        Dim2i closeButtonDim = new Dim2i(tabFrameDim.getLimitX() - 65, tabFrameDim.getLimitY() + 5, 65, 20);
        String donationText = "Buy us a coffee!";
        int donationTextWidth = this.field_230706_i_.field_71466_p.func_78256_a(donationText);
        Dim2i donateButtonDim = new Dim2i(tabFrameDim.getLimitX() - 32 - donationTextWidth, tabFrameDim.getOriginY() - 26, 10 + donationTextWidth, 20);
        Dim2i hideDonateButtonDim = new Dim2i(tabFrameDim.getLimitX() - 20, tabFrameDim.getOriginY() - 26, 20, 20);
        this.undoButton = new FlatButtonWidget(undoButtonDim, "Undo", this::undoChanges);
        this.applyButton = new FlatButtonWidget(applyButtonDim, "Apply", this::applyChanges);
        this.closeButton = new FlatButtonWidget(closeButtonDim, "Close", this::func_231175_as__);
        this.donateButton = new FlatButtonWidget(donateButtonDim, donationText, this::openDonationPage);
        this.hideDonateButton = new FlatButtonWidget(hideDonateButtonDim, "x", this::hideDonationButton);
        if (SodiumClientMod.options().notifications.hideDonationButton) {
            this.setDonationButtonVisibility(false);
        }
        Dim2i searchTextFieldDim = SodiumClientMod.options().notifications.hideDonationButton ? new Dim2i(tabFrameDim.getOriginX(), tabFrameDim.getOriginY() - 26, tabFrameDim.getWidth(), 20) : new Dim2i(tabFrameDim.getOriginX(), tabFrameDim.getOriginY() - 26, tabFrameDim.getWidth() - (tabFrameDim.getLimitX() - donateButtonDim.getOriginX()) - 2, 20);
        BasicFrame.Builder basicFrameBuilder = this.parentBasicFrameBuilder(basicFrameDim, tabFrameDim);
        if (IrisCompat.isIrisPresent()) {
            int size = this.field_230706_i_.field_71466_p.func_238414_a_((ITextProperties)new TranslationTextComponent(IrisCompat.getIrisShaderPacksScreenLanguageKey()));
            Dim2i shaderPackButtonDim = !SodiumClientMod.options().notifications.hideDonationButton ? new Dim2i(donateButtonDim.getOriginX() - 12 - size, tabFrameDim.getOriginY() - 26, 10 + size, 20) : new Dim2i(tabFrameDim.getLimitX() - size - 10, tabFrameDim.getOriginY() - 26, 10 + size, 20);
            searchTextFieldDim = new Dim2i(tabFrameDim.getOriginX(), tabFrameDim.getOriginY() - 26, tabFrameDim.getWidth() - (tabFrameDim.getLimitX() - shaderPackButtonDim.getOriginX()) - 2, 20);
            FlatButtonWidget shaderPackButton = new FlatButtonWidget(shaderPackButtonDim, new TranslationTextComponent(IrisCompat.getIrisShaderPacksScreenLanguageKey()).getString(), () -> this.field_230706_i_.func_147108_a(IrisCompat.getIrisShaderPacksScreen(this)));
            basicFrameBuilder.addChild(dim -> shaderPackButton);
        }
        this.searchTextField = new SearchTextFieldComponent(searchTextFieldDim, this.pages, tabFrameSelectedTab, tabFrameScrollBarOffset, optionPageScrollBarOffset, tabFrameDim.getHeight(), this, lastSearch, lastSearchIndex);
        basicFrameBuilder.addChild(dim -> this.searchTextField);
        return basicFrameBuilder;
    }

    public BasicFrame.Builder parentBasicFrameBuilder(Dim2i parentBasicFrameDim, Dim2i tabFrameDim) {
        return BasicFrame.createBuilder().setDimension(parentBasicFrameDim).shouldRenderOutline(false).addChild(dim -> this.donateButton).addChild(dim -> this.hideDonateButton).addChild(parentDim -> TabFrame.createBuilder().setDimension(tabFrameDim).shouldRenderOutline(false).setTabSectionScrollBarOffset(tabFrameScrollBarOffset).setTabSectionSelectedTab(tabFrameSelectedTab).addTabs(tabs -> this.pages.stream().filter(page -> !page.getGroups().isEmpty()).forEach(page -> tabs.add(Tab.createBuilder().from((OptionPage)page, optionPageScrollBarOffset)))).onSetTab(() -> optionPageScrollBarOffset.set(0)).build()).addChild(dim -> this.undoButton).addChild(dim -> this.applyButton).addChild(dim -> this.closeButton);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float delta) {
        super.func_230446_a_(matrixStack);
        this.updateControls();
        this.frame.func_230430_a_(matrixStack, mouseX, mouseY, delta);
    }

    private void updateControls() {
        boolean hasChanges = this.getAllOptions().anyMatch(Option::hasChanged);
        for (OptionPage page : this.pages) {
            for (Option option : page.getOptions()) {
                if (!option.hasChanged()) continue;
                hasChanges = true;
            }
        }
        this.applyButton.setEnabled(hasChanges);
        this.undoButton.setVisible(hasChanges);
        this.closeButton.setEnabled(!hasChanges);
        this.hasPendingChanges = hasChanges;
    }

    private void setDonationButtonVisibility(boolean value) {
        this.donateButton.setVisible(value);
        this.hideDonateButton.setVisible(value);
    }

    private void hideDonationButton() {
        SodiumGameOptions options = SodiumClientMod.options();
        options.notifications.hideDonationButton = true;
        try {
            options.writeChanges();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save configuration", e);
        }
        this.setDonationButtonVisibility(false);
        this.rebuildUI();
    }

    private void openDonationPage() {
        Util.func_110647_a().func_195640_a("https://caffeinemc.net/donate");
    }

    private Stream<Option<?>> getAllOptions() {
        return this.pages.stream().flatMap(s -> s.getOptions().stream());
    }

    private void applyChanges() {
        HashSet dirtyStorages = new HashSet();
        EnumSet<OptionFlag> flags = EnumSet.noneOf(OptionFlag.class);
        this.getAllOptions().forEach(option -> {
            if (!option.hasChanged()) {
                return;
            }
            option.applyChanges();
            flags.addAll(option.getFlags());
            dirtyStorages.add(option.getStorage());
        });
        Minecraft client = Minecraft.func_71410_x();
        if (flags.contains(OptionFlag.REQUIRES_RENDERER_RELOAD)) {
            client.field_71438_f.func_72712_a();
        }
        if (flags.contains(OptionFlag.REQUIRES_ASSET_RELOAD)) {
            client.func_228020_b_(client.field_71474_y.field_151442_I);
            client.func_213245_w();
        }
        for (OptionStorage storage : dirtyStorages) {
            storage.save();
        }
    }

    private void undoChanges() {
        this.getAllOptions().forEach(Option::reset);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (!(keyCode != 80 || (modifiers & 1) == 0 || this.searchTextField != null && this.searchTextField.isFocused())) {
            Minecraft.func_71410_x().func_147108_a((Screen)new VideoSettingsScreen(this.prevScreen, Minecraft.func_71410_x().field_71474_y));
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231178_ax__() {
        return !this.hasPendingChanges;
    }

    public void func_231175_as__() {
        lastSearch.set("");
        lastSearchIndex.set(0);
        this.field_230706_i_.func_147108_a(this.prevScreen);
    }
}

