/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.gui.content;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.keksuccino.konkrete.gui.content.handling.AdvancedWidgetsHandler;
import de.keksuccino.konkrete.gui.content.handling.IAdvancedWidgetBase;
import de.keksuccino.konkrete.input.CharData;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.KeyboardData;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.mixin.client.IMixinEditBox;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class AdvancedTextField
extends TextFieldWidget
implements IAdvancedWidgetBase {
    private final boolean handleSelf;
    private final CharacterFilter characterFilter;

    public AdvancedTextField(FontRenderer font, int x, int y, int width, int height, boolean handleSelf, @Nullable CharacterFilter characterFilter) {
        super(font, x, y, width, height, (ITextComponent)new StringTextComponent(""));
        this.handleSelf = handleSelf;
        this.characterFilter = characterFilter;
    }

    public boolean func_231042_a_(char character, int modifiers) {
        if (this.characterFilter == null || this.characterFilter.isAllowed(character)) {
            return super.func_231042_a_(character, modifiers);
        }
        return false;
    }

    public void func_146191_b(String textToWrite) {
        if (this.characterFilter != null) {
            textToWrite = this.characterFilter.filterForAllowedChars(textToWrite);
        }
        super.func_146191_b(textToWrite);
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partial) {
        if (this.handleSelf) {
            AdvancedWidgetsHandler.handleWidget(this);
        }
        super.func_230431_b_(matrixStack, mouseX, mouseY, partial);
    }

    @Override
    public void onTick() {
        if (this.handleSelf) {
            this.func_146178_a();
        }
    }

    @Override
    public void onKeyPress(KeyboardData d) {
        if (this.handleSelf) {
            this.func_231046_a_(d.keycode, d.scancode, d.modfiers);
        }
    }

    @Override
    public void onKeyReleased(KeyboardData d) {
        if (this.handleSelf) {
            this.func_223281_a_(d.keycode, d.scancode, d.modfiers);
        }
    }

    @Override
    public void onCharTyped(CharData d) {
        if (this.handleSelf) {
            this.func_231042_a_(d.typedChar, d.modfiers);
        }
    }

    @Override
    public void onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.handleSelf) {
            this.func_231044_a_(mouseX, mouseY, mouseButton);
        }
    }

    public boolean func_230449_g_() {
        int mouseX = MouseInput.getMouseX();
        int mouseY = MouseInput.getMouseY();
        return mouseX >= this.getX() && mouseX <= this.getX() + this.func_230998_h_() && mouseY >= this.getY() && mouseY <= this.getY() + this.func_238483_d_();
    }

    public boolean func_212953_l() {
        return this.getAccessor().getIsEditableKonkrete();
    }

    public boolean isLeftClicked() {
        return this.func_230449_g_() && MouseInput.isLeftMouseDown();
    }

    public int func_230998_h_() {
        return this.field_230688_j_;
    }

    public void func_230991_b_(int width) {
        this.field_230688_j_ = width;
    }

    public int getX() {
        return this.field_230690_l_;
    }

    public void func_212952_l(int x) {
        this.field_230690_l_ = x;
    }

    public int getY() {
        return this.field_230691_m_;
    }

    public void setY(int y) {
        this.field_230691_m_ = y;
    }

    public IMixinEditBox getAccessor() {
        return (IMixinEditBox)((Object)this);
    }

    @Deprecated
    protected void setResponderEntryValue(String text) {
        this.getAccessor().onValueChangeKonkrete(text);
    }

    @Deprecated
    public int getMaxStringLength() {
        return this.getAccessor().getMaxLengthKonkrete();
    }

    @Deprecated
    public int getSelectionEnd() {
        return this.getAccessor().getHightlightPosKonkrete();
    }

    @Deprecated
    public boolean isEnabled() {
        return this.func_212953_l();
    }
}

