/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.gui.content;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IngameGui;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class AdvancedButtonHandler {
    private static AdvancedButton activeDescBtn;
    private static int garbageCheck;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new AdvancedButtonHandler());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post e) {
        if (activeDescBtn != null) {
            if (activeDescBtn.func_230449_g_() && Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71462_r != null) {
                AdvancedButtonHandler.renderDescription(e.getMatrixStack(), e.getMouseX(), e.getMouseY());
            }
            if (garbageCheck == 0) {
                activeDescBtn = null;
            }
            garbageCheck = 0;
        }
    }

    public static void setActiveDescriptionButton(AdvancedButton btn) {
        activeDescBtn = btn;
        garbageCheck = 1;
    }

    private static void renderDescriptionBackground(MatrixStack matrix, int x, int y, int width, int height) {
        IngameGui.func_238467_a_((MatrixStack)matrix, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)new Color(26, 26, 26, 250).getRGB());
    }

    private static void renderDescription(MatrixStack matrix, int mouseX, int mouseY) {
        if (activeDescBtn != null && activeDescBtn.getDescription() != null) {
            int width = 10;
            int height = 10;
            for (String s : activeDescBtn.getDescription()) {
                int i = Minecraft.func_71410_x().field_71466_p.func_78256_a(s) + 10;
                if (i > width) {
                    width = i;
                }
                height += 10;
            }
            mouseY += 5;
            if (Minecraft.func_71410_x().field_71462_r.field_230708_k_ < (mouseX += 5) + width) {
                mouseX -= width + 10;
            }
            if (Minecraft.func_71410_x().field_71462_r.field_230709_l_ < mouseY + height) {
                mouseY -= height + 10;
            }
            RenderUtils.setZLevelPre(matrix, 600);
            AdvancedButtonHandler.renderDescriptionBackground(matrix, mouseX, mouseY, width, height);
            RenderSystem.enableBlend();
            int i2 = 5;
            for (String s : activeDescBtn.getDescription()) {
                AbstractGui.func_238476_c_((MatrixStack)matrix, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)s, (int)(mouseX + 5), (int)(mouseY + i2), (int)Color.WHITE.getRGB());
                i2 += 10;
            }
            RenderUtils.setZLevelPost(matrix);
            RenderSystem.disableBlend();
        }
    }

    static {
        garbageCheck = 0;
    }
}

