/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost.cityassets;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Predicate;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

public abstract class ConditionContext {
    private final int level;
    private final int floor;
    private final int floorsBelowGround;
    private final int floorsAboveGround;
    private final String part;
    private final String building;
    private final int chunkX;
    private final int chunkZ;

    public ConditionContext(int level, int floor, int floorsBelowGround, int floorsAboveGround, String part, String building, int chunkX, int chunkZ) {
        this.level = level;
        this.floor = floor;
        this.floorsBelowGround = floorsBelowGround;
        this.floorsAboveGround = floorsAboveGround;
        this.part = part;
        this.building = building;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
    }

    private static Predicate<ConditionContext> combine(Predicate<ConditionContext> orig, Predicate<ConditionContext> newTest) {
        if (orig == null) {
            return newTest;
        }
        return levelInfo -> orig.test((ConditionContext)levelInfo) && newTest.test((ConditionContext)levelInfo);
    }

    public static Predicate<ConditionContext> parseTest(JsonElement element) {
        boolean ground;
        Predicate<ConditionContext> test = null;
        JsonObject obj = element.getAsJsonObject();
        if (obj.has("top")) {
            boolean top = obj.get("top").getAsBoolean();
            test = top ? ConditionContext.combine(test, ConditionContext::isTopOfBuilding) : ConditionContext.combine(test, levelInfo -> !levelInfo.isTopOfBuilding());
        }
        if (obj.has("ground")) {
            ground = obj.get("ground").getAsBoolean();
            test = ground ? ConditionContext.combine(test, ConditionContext::isGroundFloor) : ConditionContext.combine(test, levelInfo -> !levelInfo.isGroundFloor());
        }
        if (obj.has("isbuilding")) {
            ground = obj.get("isbuilding").getAsBoolean();
            test = ground ? ConditionContext.combine(test, ConditionContext::isBuilding) : ConditionContext.combine(test, levelInfo -> !levelInfo.isBuilding());
        }
        if (obj.has("issphere")) {
            ground = obj.get("issphere").getAsBoolean();
            test = ground ? ConditionContext.combine(test, ConditionContext::isSphere) : ConditionContext.combine(test, levelInfo -> !levelInfo.isSphere());
        }
        if (obj.has("chunkx")) {
            int chunkX = obj.get("chunkx").getAsInt();
            test = ConditionContext.combine(test, context -> chunkX == context.getChunkX());
        }
        if (obj.has("chunkz")) {
            int chunkZ = obj.get("chunkz").getAsInt();
            test = ConditionContext.combine(test, context -> chunkZ == context.getChunkZ());
        }
        if (obj.has("inpart")) {
            String part = obj.get("inpart").getAsString();
            test = ConditionContext.combine(test, context -> part.equals(context.getPart()));
        }
        if (obj.has("inbuilding")) {
            String building = obj.get("inbuilding").getAsString();
            test = ConditionContext.combine(test, context -> building.equals(context.getBuilding()));
        }
        if (obj.has("inbiome")) {
            String biome = obj.get("inbiome").getAsString();
            test = ConditionContext.combine(test, context -> biome.equals(context.getBiome()));
        }
        if (obj.has("cellar")) {
            boolean cellar = obj.get("cellar").getAsBoolean();
            test = cellar ? ConditionContext.combine(test, ConditionContext::isCellar) : ConditionContext.combine(test, levelInfo -> !levelInfo.isCellar());
        }
        if (obj.has("floor")) {
            int level = obj.get("floor").getAsInt();
            test = ConditionContext.combine(test, levelInfo -> levelInfo.isFloor(level));
        }
        if (obj.has("range")) {
            String range = obj.get("range").getAsString();
            String[] split = StringUtils.split((String)range, (char)',');
            try {
                int l1 = Integer.parseInt(split[0]);
                int l2 = Integer.parseInt(split[1]);
                test = ConditionContext.combine(test, levelInfo -> levelInfo.isRange(l1, l2));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Bad range specification: <l1>,<l2>!");
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new RuntimeException("Bad range specification: <l1>,<l2>!");
            }
        }
        if (test == null) {
            test = conditionContext -> true;
        }
        return test;
    }

    public int getLevel() {
        return this.level;
    }

    public int getFloor() {
        return this.floor;
    }

    public int getFloorsBelowGround() {
        return this.floorsBelowGround;
    }

    public int getFloorsAboveGround() {
        return this.floorsAboveGround;
    }

    public boolean isGroundFloor() {
        return this.floor == 0;
    }

    public boolean isBuilding() {
        return !"<none>".equals(this.building);
    }

    public abstract boolean isSphere();

    public abstract ResourceLocation getBiome();

    public boolean isTopOfBuilding() {
        return this.floor >= this.floorsAboveGround;
    }

    public boolean isCellar() {
        return this.floor < 0;
    }

    public boolean isFloor(int l) {
        return this.floor == l;
    }

    public boolean isRange(int l1, int l2) {
        return this.floor >= l1 && this.floor <= l2;
    }

    public String getPart() {
        return this.part;
    }

    public String getBuilding() {
        return this.building;
    }

    public int getChunkX() {
        return this.chunkX;
    }

    public int getChunkZ() {
        return this.chunkZ;
    }
}

