/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen;

import java.util.Random;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.ChunkStatus;

public class ChunkFixer {
    private static void generateTrees(Random random, int chunkX, int chunkZ, IWorld world, IDimensionInfo provider) {
        BuildingInfo info = BuildingInfo.getBuildingInfo(chunkX, chunkZ, provider);
        for (BlockPos pos : info.getSaplingTodo()) {
            BlockState state = world.func_180495_p(pos);
            if (!(state.func_177230_c() instanceof SaplingBlock)) continue;
        }
        info.clearSaplingTodo();
    }

    private static void generateVines(Random random, int chunkX, int chunkZ, IWorld world, IDimensionInfo provider) {
        int x;
        int y;
        int z;
        int bottom;
        BuildingInfo adjacent;
        float vineChance = provider.getProfile().VINE_CHANCE;
        if ((double)vineChance < 1.0E-6) {
            return;
        }
        int cx = chunkX * 16;
        int cz = chunkZ * 16;
        BuildingInfo info = BuildingInfo.getBuildingInfo(chunkX, chunkZ, provider);
        int maxHeight = info.getMaxHeight();
        if (info.hasBuilding && world.func_212866_a_(chunkX + 1, chunkZ).func_201589_g().func_209003_a(ChunkStatus.field_222613_i)) {
            adjacent = info.getXmax();
            bottom = Math.max(adjacent.getCityGroundLevel() + 3, adjacent.hasBuilding ? adjacent.getMaxHeight() : adjacent.getCityGroundLevel() + 3);
            for (z = 0; z < 15; ++z) {
                for (y = bottom; y < maxHeight; ++y) {
                    if (!(world.func_201674_k().nextFloat() < vineChance)) continue;
                    ChunkFixer.createVineStrip(world, bottom, VineBlock.field_176280_O, new BlockPos(cx + 16, y, cz + z), new BlockPos(cx + 15, y, cz + z));
                }
            }
        }
        if (info.getXmax().hasBuilding && world.func_212866_a_(chunkX + 1, chunkZ).func_201589_g().func_209003_a(ChunkStatus.field_222613_i)) {
            adjacent = info.getXmax();
            bottom = Math.max(info.getCityGroundLevel() + 3, info.hasBuilding ? maxHeight : info.getCityGroundLevel() + 3);
            for (z = 0; z < 15; ++z) {
                for (y = bottom; y < adjacent.getMaxHeight(); ++y) {
                    if (!(world.func_201674_k().nextFloat() < vineChance)) continue;
                    ChunkFixer.createVineStrip(world, bottom, VineBlock.field_176278_M, new BlockPos(cx + 15, y, cz + z), new BlockPos(cx + 16, y, cz + z));
                }
            }
        }
        if (info.hasBuilding && world.func_212866_a_(chunkX, chunkZ + 1).func_201589_g().func_209003_a(ChunkStatus.field_222613_i)) {
            adjacent = info.getZmax();
            bottom = Math.max(adjacent.getCityGroundLevel() + 3, adjacent.hasBuilding ? adjacent.getMaxHeight() : adjacent.getCityGroundLevel() + 3);
            for (x = 0; x < 15; ++x) {
                for (y = bottom; y < maxHeight; ++y) {
                    if (!(world.func_201674_k().nextFloat() < vineChance)) continue;
                    ChunkFixer.createVineStrip(world, bottom, VineBlock.field_176273_b, new BlockPos(cx + x, y, cz + 16), new BlockPos(cx + x, y, cz + 15));
                }
            }
        }
        if (info.getZmax().hasBuilding && world.func_212866_a_(chunkX, chunkZ + 1).func_201589_g().func_209003_a(ChunkStatus.field_222613_i)) {
            adjacent = info.getZmax();
            bottom = Math.max(info.getCityGroundLevel() + 3, info.hasBuilding ? maxHeight : info.getCityGroundLevel() + 3);
            for (x = 0; x < 15; ++x) {
                for (y = bottom; y < adjacent.getMaxHeight(); ++y) {
                    if (!(world.func_201674_k().nextFloat() < vineChance)) continue;
                    ChunkFixer.createVineStrip(world, bottom, VineBlock.field_176279_N, new BlockPos(cx + x, y, cz + 15), new BlockPos(cx + x, y, cz + 16));
                }
            }
        }
    }

    private static void createVineStrip(IWorld world, int bottom, BooleanProperty direction, BlockPos pos, BlockPos vineHolderPos) {
        if (world.func_175623_d(vineHolderPos)) {
            return;
        }
        if (!world.func_175623_d(pos)) {
            return;
        }
        BlockState state = (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((Property)direction, (Comparable)Boolean.valueOf(true));
        world.func_180501_a(pos, state, 0);
        pos = pos.func_177977_b();
        while (pos.func_177956_o() >= bottom && world.func_201674_k().nextFloat() < 0.8f) {
            if (!world.func_175623_d(pos)) {
                return;
            }
            world.func_180501_a(pos, state, 0);
            pos = pos.func_177977_b();
        }
    }

    public static void fix(IDimensionInfo info, int chunkX, int chunkZ) {
        ChunkFixer.generateTrees(info.getRandom(), chunkX, chunkZ, (IWorld)info.getWorld(), info);
        ChunkFixer.generateVines(info.getRandom(), chunkX, chunkZ, (IWorld)info.getWorld(), info);
    }
}

