/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.setup;

import com.mojang.brigadier.CommandDispatcher;
import mcjty.lostcities.commands.ModCommands;
import mcjty.lostcities.config.LostCityConfiguration;
import mcjty.lostcities.setup.Registration;
import mcjty.lostcities.varia.CustomTeleporter;
import mcjty.lostcities.varia.WorldTools;
import mcjty.lostcities.worldgen.LostCityFeature;
import mcjty.lostcities.worldgen.lost.BiomeInfo;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.City;
import mcjty.lostcities.worldgen.lost.CitySphere;
import mcjty.lostcities.worldgen.lost.Highway;
import mcjty.lostcities.worldgen.lost.Railway;
import net.minecraft.block.AbstractSkullBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ForgeEventHandlers {
    @SubscribeEvent
    public void commandRegister(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        BuildingInfo.cleanCache();
        Highway.cleanCache();
        Railway.cleanCache();
        BiomeInfo.cleanCache();
        City.cleanCache();
        CitySphere.cleanCache();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBiomeLoad(BiomeLoadingEvent event) {
        RegistryKey biomeKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)event.getName());
        if (!BiomeDictionary.hasType((RegistryKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.VOID)) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.RAW_GENERATION).add(() -> LostCityFeature.LOSTCITY_CONFIGURED_FEATURE);
        }
    }

    private boolean isValidStandingPosition(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return state.func_200132_m();
    }

    private boolean isValidSpawnBed(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (!(state.func_177230_c() instanceof BedBlock)) {
            return false;
        }
        Direction direction = Blocks.field_196551_aB.getBedDirection(state, (IWorldReader)world, pos);
        Block b1 = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        Block b2 = world.func_180495_p(pos.func_177972_a(direction.func_176734_d()).func_177977_b()).func_177230_c();
        Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation((String)LostCityConfiguration.SPECIAL_BED_BLOCK.get()));
        if (b1 != b || b2 != b) {
            return false;
        }
        if (!(world.func_180495_p(pos.func_177972_a(direction)).func_177230_c() instanceof AbstractSkullBlock)) {
            return false;
        }
        if (!(world.func_180495_p(pos.func_177972_a(direction.func_176746_e())).func_177230_c() instanceof AbstractSkullBlock)) {
            return false;
        }
        if (!(world.func_180495_p(pos.func_177972_a(direction.func_176735_f())).func_177230_c() instanceof AbstractSkullBlock)) {
            return false;
        }
        if (!(world.func_180495_p(pos.func_177967_a(direction.func_176734_d(), 2)).func_177230_c() instanceof AbstractSkullBlock)) {
            return false;
        }
        if (!(world.func_180495_p(pos.func_177972_a(direction.func_176734_d()).func_177972_a(direction.func_176734_d().func_176746_e())).func_177230_c() instanceof AbstractSkullBlock)) {
            return false;
        }
        return world.func_180495_p(pos.func_177972_a(direction.func_176734_d()).func_177972_a(direction.func_176734_d().func_176735_f())).func_177230_c() instanceof AbstractSkullBlock;
    }

    private BlockPos findValidTeleportLocation(World world, BlockPos start) {
        int y;
        int chunkZ;
        int chunkX = start.func_177958_n() >> 4;
        BlockPos pos = this.findValidTeleportLocation(world, chunkX, chunkZ = start.func_177952_p() >> 4, y = start.func_177956_o());
        if (pos != null) {
            return pos;
        }
        for (int r = 1; r < 50; ++r) {
            for (int i = -r; i < r; ++i) {
                pos = this.findValidTeleportLocation(world, chunkX + i, chunkZ - r, y);
                if (pos != null) {
                    return pos;
                }
                pos = this.findValidTeleportLocation(world, chunkX + r, chunkZ + i, y);
                if (pos != null) {
                    return pos;
                }
                pos = this.findValidTeleportLocation(world, chunkX + r - i, chunkZ + r, y);
                if (pos != null) {
                    return pos;
                }
                pos = this.findValidTeleportLocation(world, chunkX - r, chunkZ + r - i, y);
                if (pos == null) continue;
                return pos;
            }
        }
        return null;
    }

    private BlockPos findValidTeleportLocation(World world, int chunkX, int chunkZ, int y) {
        BlockPos bestSpot = null;
        for (int dy = 0; dy < 255; ++dy) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    BlockPos p;
                    if (y + dy < 250) {
                        p = new BlockPos(chunkX * 16 + x, y + dy, chunkZ * 16 + z);
                        if (this.isValidSpawnBed(world, p)) {
                            return p.func_177984_a();
                        }
                        if (bestSpot == null && this.isValidStandingPosition(world, p)) {
                            bestSpot = p.func_177984_a();
                        }
                    }
                    if (y - dy <= 1) continue;
                    p = new BlockPos(chunkX * 16 + x, y - dy, chunkZ * 16 + z);
                    if (this.isValidSpawnBed(world, p)) {
                        return p.func_177984_a();
                    }
                    if (bestSpot != null || !this.isValidStandingPosition(world, p)) continue;
                    bestSpot = p.func_177984_a();
                }
            }
        }
        return bestSpot;
    }

    @SubscribeEvent
    public void onPlayerSleepInBedEvent(PlayerSleepInBedEvent event) {
        World world = event.getPlayer().func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        BlockPos bedLocation = event.getPos();
        if (bedLocation == null || !this.isValidSpawnBed(world, bedLocation)) {
            return;
        }
        if (world.func_234923_W_() == Registration.DIMENSION) {
            event.setResult(PlayerEntity.SleepResult.OTHER_PROBLEM);
            ServerWorld destWorld = WorldTools.getOverworld(world);
            BlockPos location = this.findLocation(bedLocation, destWorld);
            CustomTeleporter.teleportToDimension(event.getPlayer(), destWorld, location);
        } else {
            event.setResult(PlayerEntity.SleepResult.OTHER_PROBLEM);
            ServerWorld destWorld = event.getEntity().func_130014_f_().func_73046_m().func_71218_a(Registration.DIMENSION);
            BlockPos location = this.findLocation(bedLocation, destWorld);
            CustomTeleporter.teleportToDimension(event.getPlayer(), destWorld, location);
        }
    }

    private BlockPos findLocation(BlockPos bedLocation, ServerWorld destWorld) {
        BlockPos top;
        BlockPos location = top = bedLocation.func_177981_b(5);
        while (top.func_177956_o() > 1 && destWorld.func_180495_p(location).isAir((IBlockReader)destWorld, location)) {
            location = location.func_177977_b();
        }
        if (destWorld.func_175623_d(location.func_177977_b())) {
            destWorld.func_175656_a(bedLocation, Blocks.field_150347_e.func_176223_P());
        }
        return location.func_177981_b(1);
    }
}

