/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import mcjty.lostcities.api.LostChunkCharacteristics;
import mcjty.lostcities.api.RailChunkType;
import mcjty.lostcities.config.LostCityConfiguration;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.gui.LostCitySetup;
import mcjty.lostcities.gui.NullDimensionInfo;
import mcjty.lostcities.gui.elements.BooleanElement;
import mcjty.lostcities.gui.elements.ButtonExt;
import mcjty.lostcities.gui.elements.FloatElement;
import mcjty.lostcities.gui.elements.GuiElement;
import mcjty.lostcities.gui.elements.IntElement;
import mcjty.lostcities.setup.Config;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.Highway;
import mcjty.lostcities.worldgen.lost.Railway;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class GuiLCConfig
extends Screen {
    private final Screen parent;
    private Button profileButton;
    private Button customizeButton;
    private Button modeButton;
    private static final int YOFFSET = 21;
    private String curpage;
    private int y;
    private static final List<String> MODES = Arrays.asList("Cities", "Buildings", "Damage", "Transport", "Various");
    private String mode = MODES.get(0);
    private long seed = 3439249320423L;
    private Random random = new Random();
    private List<GuiElement> elements = new ArrayList<GuiElement>();
    private LostCitySetup localSetup = new LostCitySetup(this::refreshPreview);

    public GuiLCConfig(Screen parent) {
        super((ITextComponent)new StringTextComponent("Lost City Configuration"));
        this.parent = parent;
        this.localSetup.copyFrom(LostCitySetup.CLIENT_SETUP);
    }

    private static void selectProfile(String profileName, @Nullable LostCityProfile profile) {
        Config.profileFromClient = profileName;
        if (profile != null) {
            LostCityConfiguration.standardProfiles.get("customized").copyFrom(profile);
            Config.jsonFromClient = profile.toJson(false).toString();
        }
    }

    public LostCitySetup getLocalSetup() {
        return this.localSetup;
    }

    public FontRenderer getFont() {
        return this.field_230712_o_;
    }

    public void func_231023_e_() {
        this.elements.stream().forEach(GuiElement::tick);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.profileButton = (Button)this.func_230480_a_((Widget)new ButtonExt(this, 70, 10, 100, 20, (ITextComponent)new StringTextComponent(this.localSetup.getProfileLabel()), p -> {
            this.localSetup.toggleProfile();
            this.updateValues();
        }).tooltip((ITextComponent)new StringTextComponent("Select a standard profile for your Lost City worldgen")));
        this.customizeButton = (Button)this.func_230480_a_((Widget)new ButtonExt(this, 180, 10, 100, 20, (ITextComponent)new StringTextComponent("Customize"), p -> {
            this.localSetup.customize();
            this.updateValues();
        }).tooltip((ITextComponent)new StringTextComponent("Create a customized version of the currently selected profile")));
        this.modeButton = (Button)this.func_230480_a_((Widget)new ButtonExt(this, 290, 10, 100, 20, (ITextComponent)new StringTextComponent(this.mode), p -> this.toggleMode()).tooltip((ITextComponent)new StringTextComponent("Switch between different configuration pages")));
        Button doneButton = (Button)this.func_230480_a_((Widget)new Button(10, this.field_230709_l_ - 30, 120, 20, (ITextComponent)new StringTextComponent("Done"), p -> this.done()));
        Button cancelButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ - 130, this.field_230709_l_ - 30, 120, 20, (ITextComponent)new StringTextComponent("Cancel"), p -> this.cancel()));
        Button randomizeButton = (Button)this.func_230480_a_((Widget)new ButtonExt(this, this.field_230708_k_ - 35, 35, 30, 20, (ITextComponent)new StringTextComponent("Rnd"), p -> this.randomizePreview()).tooltip((ITextComponent)new StringTextComponent("Randomize the seed for the preview (does not affect the generated world)")));
        this.initCities(110);
        this.initBuildings(110);
        this.initDamage(70);
        this.initTransport(110);
        this.initVarious(110);
        this.updateValues();
    }

    private BooleanElement addBool(int left, String attribute) {
        BooleanElement el = new BooleanElement(this, this.curpage, left, this.y, attribute);
        this.add(el);
        return el;
    }

    private FloatElement addFloat(int left, String attribute) {
        FloatElement el = new FloatElement(this, this.curpage, left, this.y, attribute);
        this.add(el);
        return el;
    }

    private IntElement addInt(int left, String attribute) {
        IntElement el = new IntElement(this, this.curpage, left, this.y, attribute);
        this.add(el);
        return el;
    }

    private void start(String name) {
        this.curpage = name;
        this.y = 40;
    }

    private void nl() {
        this.y += 21;
    }

    private void initVarious(int left) {
        this.start("Various");
        this.addBool(left, "lostcity.generateSpawners").label("Spawners:");
        this.nl();
        this.addBool(left, "lostcity.generateLighting").label("Lighting:");
        this.nl();
        this.addBool(left, "lostcity.generateLoot").label("Loot:");
        this.nl();
        this.addFloat(left, "lostcity.vineChance").label("Vines:");
        this.nl();
        this.addFloat(left, "lostcity.randomLeafBlockChance").label("Leafs:");
        this.nl();
        this.nl();
        this.addBool(left, "lostcity.generateNether").label("Nether:");
    }

    private void initDamage(int left) {
        this.start("Damage");
        this.addBool(left, "lostcity.rubbleLayer").label("Rubble:");
        this.nl();
        this.addFloat(left, "lostcity.ruinChance").label("Ruins:").prefix("%");
        this.addFloat(left + 80, "lostcity.ruinMinlevelPercent").prefix("-");
        this.addFloat(left + 140, "lostcity.ruinMaxlevelPercent").prefix("+");
        this.nl();
        this.addFloat(left, "explosions.explosionChance").label("Explosion:").prefix("%");
        this.addInt(left + 80, "explosions.explosionMinRadius").prefix("-");
        this.addInt(left + 140, "explosions.explosionMaxRadius").prefix("+");
        this.nl();
        this.addInt(left + 80, "explosions.explosionMinHeight").label("Height:");
        this.addInt(left + 140, "explosions.explosionMaxHeight");
        this.nl();
        this.addFloat(left, "explosions.miniExplosionChance").label("Min/exp:").prefix("%");
        this.addInt(left + 80, "explosions.miniExplosionMinRadius").prefix("-");
        this.addInt(left + 140, "explosions.miniExplosionMaxRadius").prefix("+");
        this.nl();
        this.addInt(left + 80, "explosions.miniExplosionMinHeight").label("Height:");
        this.addInt(left + 140, "explosions.miniExplosionMaxHeight");
        this.nl();
    }

    private void initBuildings(int left) {
        this.start("Buildings");
        this.addInt(left, "lostcity.buildingMinFloors").label("Floors:");
        this.addInt(left + 55, "lostcity.buildingMaxFloors");
        this.nl();
        this.addInt(left, "lostcity.buildingMinFloorsChance").label("Floor Chance:");
        this.addInt(left + 55, "lostcity.buildingMaxFloorsChance");
        this.nl();
        this.addInt(left, "lostcity.buildingMinCellars").label("Cellars:");
        this.addInt(left + 55, "lostcity.buildingMaxCellars");
    }

    private void initTransport(int left) {
        this.start("Transport");
        this.addFloat(left, "lostcity.highwayMainPerlinScale").label("1st perlin:");
        this.nl();
        this.addFloat(left, "lostcity.highwaySecondaryPerlinScale").label("2nd perlin:");
        this.nl();
        this.addFloat(left, "lostcity.highwayPerlinFactor").label("Perlin:");
        this.nl();
        this.addInt(left, "lostcity.highwayDistanceMask").label("Distance mask:");
        this.nl();
        this.addBool(left, "lostcity.railwaysEnabled").label("Railways:");
        this.nl();
    }

    private void initCities(int left) {
        this.start("Cities");
        this.addFloat(left, "cities.cityChance").label("Rarity:");
        this.nl();
        this.addFloat(left, "cities.cityThreshold").label("Threshold:");
        this.nl();
        this.addInt(left, "cities.cityMinRadius").label("Radius:");
        this.addInt(left + 55, "cities.cityMaxRadius");
        this.nl();
        this.addFloat(left, "lostcity.buildingChance").label("Buildings:");
        this.nl();
        this.addFloat(left, "lostcity.building2x2Chance").label("Buildings 2x2:");
        this.nl();
        this.addFloat(left, "lostcity.parkChance").label("Parks:");
        this.nl();
        this.addFloat(left, "lostcity.fountainChance").label("Fountains:");
        this.nl();
    }

    private void toggleMode() {
        int idx = MODES.indexOf(this.mode);
        if (++idx >= MODES.size()) {
            idx = 0;
        }
        this.mode = MODES.get(idx);
        this.modeButton.func_238482_a_((ITextComponent)new StringTextComponent(this.mode));
    }

    private GuiElement add(GuiElement el) {
        this.elements.add(el);
        return el;
    }

    public <T extends Widget> T addWidget(T widget) {
        this.field_230710_m_.add(widget);
        this.field_230705_e_.add(widget);
        return widget;
    }

    private void randomizePreview() {
        this.seed = this.random.nextLong();
        this.refreshPreview();
    }

    public void refreshPreview() {
        BuildingInfo.cleanCache();
        Highway.cleanCache();
        Railway.cleanCache();
    }

    private void renderExtra(MatrixStack stack) {
        GuiLCConfig.func_238476_c_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)"Profile:", (int)10, (int)16, (int)-1);
        this.elements.stream().forEach(el -> el.render(stack));
        this.localSetup.get().ifPresent(profile -> {
            if ("Cities".equals(this.mode)) {
                this.renderPreviewMap(stack, (LostCityProfile)profile, false);
            } else if ("Buildings".equals(this.mode)) {
                this.renderPreviewCity(stack, (LostCityProfile)profile, false);
            } else if ("Damage".equals(this.mode)) {
                this.renderPreviewCity(stack, (LostCityProfile)profile, true);
            } else if ("Transport".equals(this.mode)) {
                this.renderPreviewTransports(stack, (LostCityProfile)profile);
            }
        });
    }

    private void renderPreviewTransports(MatrixStack stack, LostCityProfile profile) {
        this.renderPreviewMap(stack, profile, true);
        Random rand = new Random(this.seed);
        NullDimensionInfo diminfo = new NullDimensionInfo(profile, this.seed);
        for (int z = 0; z < 50; ++z) {
            for (int x = 0; x < 50; ++x) {
                int sx = x * 3 + this.field_230708_k_ - 160;
                int sz = z * 3 + 50;
                int color = 0;
                Railway.RailChunkInfo type = Railway.getRailChunkType(x, z, diminfo, profile);
                if (type.getType() != RailChunkType.NONE) {
                    color = -1718017502;
                }
                int levelX = Highway.getXHighwayLevel(x, z, diminfo, profile);
                int levelZ = Highway.getZHighwayLevel(x, z, diminfo, profile);
                if (levelX >= 0 || levelZ >= 0) {
                    color = color == 0 ? -1711276033 : -1720223881;
                }
                if (color == 0) continue;
                GuiLCConfig.func_238467_a_((MatrixStack)stack, (int)sx, (int)sz, (int)(sx + 3), (int)(sz + 3), (int)color);
            }
        }
    }

    private void renderPreviewCity(MatrixStack stack, LostCityProfile profile, boolean showDamage) {
        int base = 170;
        int leftRender = this.field_230708_k_ - 157;
        GuiLCConfig.func_238467_a_((MatrixStack)stack, (int)leftRender, (int)50, (int)(leftRender + 150), (int)base, (int)-16737861);
        GuiLCConfig.func_238467_a_((MatrixStack)stack, (int)leftRender, (int)base, (int)(leftRender + 150), (int)200, (int)-6724045);
        float radius = 190.0f;
        int dimHor = 10;
        int dimVer = 4;
        Random rand = new Random(this.seed);
        for (int x = 0; x < 14; ++x) {
            int minfloors;
            float factor = 0.0f;
            float sqdist = (x * 16 - 112) * (x * 16 - 112);
            if (sqdist < radius * radius) {
                float dist = (float)Math.sqrt(sqdist);
                factor = (radius - dist) / radius;
            }
            if (!(factor > 0.0f) || x <= 0) continue;
            int maxfloors = profile.BUILDING_MAXFLOORS;
            int randdist = (int)((float)profile.BUILDING_MINFLOORS_CHANCE + (factor + 0.1f) * (float)(profile.BUILDING_MAXFLOORS_CHANCE - profile.BUILDING_MINFLOORS_CHANCE));
            if (randdist < 1) {
                randdist = 1;
            }
            int f = profile.BUILDING_MINFLOORS + rand.nextInt(randdist);
            if (++f > maxfloors + 1) {
                f = maxfloors + 1;
            }
            if (f < (minfloors = profile.BUILDING_MINFLOORS + 1)) {
                f = minfloors;
            }
            for (int i = 0; i < f; ++i) {
                GuiLCConfig.func_238467_a_((MatrixStack)stack, (int)(leftRender + dimHor * x), (int)(base - i * dimVer - dimVer), (int)(leftRender + dimHor * x + dimHor - 1), (int)(base - i * dimVer + dimVer - 1 - dimVer), (int)-1);
            }
            int maxcellars = profile.BUILDING_MAXCELLARS;
            int fb = profile.BUILDING_MINCELLARS + (maxcellars <= 0 ? 0 : rand.nextInt(maxcellars + 1));
            for (int i = 0; i < fb; ++i) {
                GuiLCConfig.func_238467_a_((MatrixStack)stack, (int)(leftRender + dimHor * x), (int)(base + i * dimVer), (int)(leftRender + dimHor * x + dimHor - 1), (int)(base + i * dimVer + dimVer - 1), (int)-13421773);
            }
        }
        if (showDamage) {
            double damage;
            double dist;
            int z;
            float horFactor = 1.0f * (float)dimHor / 16.0f;
            float verFactor = 1.0f * (float)dimVer / 6.0f;
            int cx = leftRender + 75;
            int cz = (int)((float)base - (float)(profile.EXPLOSION_MINHEIGHT - 65) * verFactor);
            Random rnd = new Random(333L);
            int explosionRadius = profile.EXPLOSION_MAXRADIUS;
            int x = (int)((float)cx - (float)explosionRadius * horFactor);
            while ((float)x <= (float)cx + (float)explosionRadius * horFactor) {
                z = (int)((float)cz - (float)explosionRadius * verFactor);
                while ((float)z <= (float)cz + (float)explosionRadius * verFactor) {
                    double sqdist = (float)((cx - x) * (cx - x)) / horFactor / horFactor + (float)((cz - z) * (cz - z)) / verFactor / verFactor;
                    dist = Math.sqrt(sqdist);
                    if (dist < (double)(explosionRadius - 3)) {
                        damage = 3.0 * ((double)explosionRadius - dist) / (double)explosionRadius;
                        if ((double)rnd.nextFloat() < damage) {
                            GuiLCConfig.func_238467_a_((MatrixStack)stack, (int)x, (int)z, (int)(x + 1), (int)(z + 1), (int)0x66FF0000);
                        }
                    }
                    ++z;
                }
                ++x;
            }
            cx = leftRender + 35;
            cz = (int)((float)base - (float)(profile.MINI_EXPLOSION_MINHEIGHT - 65) * verFactor);
            explosionRadius = profile.MINI_EXPLOSION_MAXRADIUS;
            x = (int)((float)cx - (float)explosionRadius * horFactor);
            while ((float)x <= (float)cx + (float)explosionRadius * horFactor) {
                z = (int)((float)cz - (float)explosionRadius * verFactor);
                while ((float)z <= (float)cz + (float)explosionRadius * verFactor) {
                    double sqdist = (float)((cx - x) * (cx - x)) / horFactor / horFactor + (float)((cz - z) * (cz - z)) / verFactor / verFactor;
                    dist = Math.sqrt(sqdist);
                    if (dist < (double)(explosionRadius - 3)) {
                        damage = 3.0 * ((double)explosionRadius - dist) / (double)explosionRadius;
                        if ((double)rnd.nextFloat() < damage) {
                            GuiLCConfig.func_238467_a_((MatrixStack)stack, (int)x, (int)z, (int)(x + 1), (int)(z + 1), (int)0x66FF0000);
                        }
                    }
                    ++z;
                }
                ++x;
            }
        }
    }

    private static int soften(int color, boolean soft) {
        if (soft) {
            int r = (color & 0xFF0000) >> 16;
            int g = (color & 0xFF00) >> 8;
            int b = color & 0xFF;
            return r / 3 << 16 | g / 3 << 8 | b / 3;
        }
        return color;
    }

    private void renderPreviewMap(MatrixStack stack, LostCityProfile profile, boolean soft) {
        NullDimensionInfo diminfo = new NullDimensionInfo(profile, this.seed);
        for (int z = 0; z < 50; ++z) {
            for (int x = 0; x < 50; ++x) {
                int sx = x * 3 + this.field_230708_k_ - 160;
                int sz = z * 3 + 50;
                int color = 21760;
                char b = diminfo.getBiomeChar(x, z);
                switch (b) {
                    case 'p': {
                        color = 21760;
                        break;
                    }
                    case '-': {
                        color = 102;
                        break;
                    }
                    case '=': {
                        color = 102;
                        break;
                    }
                    case '#': {
                        color = 0x447744;
                        break;
                    }
                    case '+': {
                        color = 0x335533;
                        break;
                    }
                    case '*': {
                        color = 0xCCCC55;
                        break;
                    }
                    case 'd': {
                        color = 0xCCCC55;
                    }
                }
                GuiLCConfig.func_238467_a_((MatrixStack)stack, (int)sx, (int)sz, (int)(sx + 3), (int)(sz + 3), (int)(-16777216 + GuiLCConfig.soften(color, soft)));
                LostChunkCharacteristics characteristics = BuildingInfo.getChunkCharacteristics(x, z, diminfo);
                if (!characteristics.isCity) continue;
                color = 0x995555;
                if (BuildingInfo.hasBuildingGui(x, z, diminfo, characteristics)) {
                    color = 0xFFFFFF;
                }
                GuiLCConfig.func_238467_a_((MatrixStack)stack, (int)sx, (int)sz, (int)(sx + 2), (int)(sz + 2), (int)(-16777216 + GuiLCConfig.soften(color, soft)));
            }
        }
    }

    private void updateValues() {
        this.elements.stream().forEach(GuiElement::update);
        this.refreshPreview();
    }

    private void refreshButtons() {
        this.profileButton.func_238482_a_((ITextComponent)new StringTextComponent(this.localSetup.getProfileLabel()));
        this.customizeButton.field_230693_o_ = this.localSetup.isCustomizable();
        boolean isCustomized = "customized".equals(this.localSetup.getProfileLabel());
        this.modeButton.field_230693_o_ = this.localSetup.isCustomizable() || isCustomized;
        this.elements.stream().forEach(s -> {
            s.setEnabled(isCustomized);
            s.setBasedOnMode(this.mode);
        });
    }

    private void cancel() {
        this.refreshPreview();
        Minecraft.func_71410_x().func_147108_a(this.parent);
    }

    private void done() {
        this.refreshPreview();
        LostCitySetup.CLIENT_SETUP.copyFrom(this.localSetup);
        LostCityProfile customizedProfile = this.localSetup.getCustomizedProfile();
        if ("customized".equals(this.localSetup.getProfile()) && customizedProfile != null) {
            LostCityConfiguration.standardProfiles.get("customized").copyFrom(customizedProfile);
            GuiLCConfig.selectProfile(this.localSetup.getProfile(), customizedProfile);
        } else {
            GuiLCConfig.selectProfile(this.localSetup.getProfile(), null);
        }
        Minecraft.func_71410_x().func_147108_a(this.parent);
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(stack);
        this.refreshButtons();
        this.renderExtra(stack);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        for (Widget widget : this.field_230710_m_) {
            if (!widget.func_231047_b_((double)mouseX, (double)mouseY) || !widget.field_230694_p_) continue;
            widget.func_230443_a_(stack, mouseX - 0, mouseY - 0);
            break;
        }
    }
}

