/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import mcjty.lostcities.setup.Registration;
import mcjty.lostcities.worldgen.ChunkHeightmap;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.CitySphere;
import mcjty.lostcities.worldgen.lost.Railway;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;

public class CommandDebug
implements Command<CommandSource> {
    private static final CommandDebug CMD = new CommandDebug();

    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"debug").requires(cs -> cs.func_197034_c(0))).executes((Command)CMD);
    }

    public int run(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        if (player != null) {
            BlockPos position = player.func_233580_cy_();
            IDimensionInfo dimInfo = Registration.LOSTCITY_FEATURE.getDimensionInfo((ISeedReader)player.func_71121_q());
            if (dimInfo != null) {
                BuildingInfo info = BuildingInfo.getBuildingInfo(position.func_177958_n() >> 4, position.func_177952_p() >> 4, dimInfo);
                System.out.println("profile = " + info.profile.getName());
                System.out.println("buildingType = " + info.buildingType.getName());
                System.out.println("floors = " + info.getNumFloors());
                System.out.println("floorsBelowGround = " + info.floorsBelowGround);
                System.out.println("cityLevel = " + info.cityLevel);
                System.out.println("cityGroundLevel = " + info.getCityGroundLevel());
                System.out.println("isCity = " + info.isCity);
                System.out.println("chunkX = " + info.chunkX);
                System.out.println("chunkZ = " + info.chunkZ);
                System.out.println("getCityStyle() = " + BuildingInfo.getChunkCharacteristics((int)info.chunkX, (int)info.chunkZ, (IDimensionInfo)info.provider).cityStyle.getName());
                System.out.println("streetType = " + (Object)((Object)info.streetType));
                System.out.println("ruinHeight = " + info.ruinHeight);
                System.out.println("tunnel0 = " + info.isTunnel(0));
                System.out.println("tunnel1 = " + info.isTunnel(1));
                System.out.println("getHighwayXLevel() = " + info.getHighwayXLevel());
                System.out.println("getHighwayZLevel() = " + info.getHighwayZLevel());
                float reldist = CitySphere.getRelativeDistanceToCityCenter(info.chunkX, info.chunkZ, dimInfo);
                System.out.println("reldist = " + reldist);
                Railway.RailChunkInfo railInfo = Railway.getRailChunkType(info.chunkX, info.chunkZ, info.provider, info.profile);
                System.out.println("railInfo.getType() = " + (Object)((Object)railInfo.getType()));
                System.out.println("railInfo.getLevel() = " + railInfo.getLevel());
                System.out.println("railInfo.getDirection() = " + (Object)((Object)railInfo.getDirection()));
                System.out.println("railInfo.getRails() = " + railInfo.getRails());
                CitySphere sphere = CitySphere.getCitySphere(info.chunkX, info.chunkZ, dimInfo);
                System.out.println("sphere.cityCenter = " + sphere.getCenter());
                System.out.println("sphere.isEnabled() = " + sphere.isEnabled());
                System.out.println("sphere.radius = " + sphere.getRadius());
                ChunkHeightmap heightmap = dimInfo.getFeature().getHeightmap(info.chunkX, info.chunkZ, (ISeedReader)player.func_71121_q());
                int avg = 0;
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        avg += heightmap.getHeight(x, z);
                    }
                }
                System.out.println("Average chunk height (heightmap): " + (avg /= 256));
                System.out.println("dimInfo.getProfile().BUILDING_MINFLOORS = " + dimInfo.getProfile().BUILDING_MINFLOORS);
                System.out.println("dimInfo.getProfile().BUILDING_MAXFLOORS = " + dimInfo.getProfile().BUILDING_MAXFLOORS);
                System.out.println("dimInfo.getProfile().CITY_CHANCE = " + dimInfo.getProfile().CITY_CHANCE);
            }
        }
        return 0;
    }
}

