/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.item;

import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.entity.mutant.MutantEndermanEntity;
import chumbanotz.mutantbeasts.entity.projectile.ThrowableBlockEntity;
import chumbanotz.mutantbeasts.particles.MBParticleTypes;
import chumbanotz.mutantbeasts.util.EntityUtil;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.enchantment.IVanishable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class EndersoulHandItem
extends Item
implements IVanishable {
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public EndersoulHandItem(Item.Properties properties) {
        super(properties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 5.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)-2.4f, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return !player.func_184812_l_();
    }

    public EquipmentSlotType getEquipmentSlot(ItemStack stack) {
        return EquipmentSlotType.MAINHAND;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(1, attacker, livingEntity -> livingEntity.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public int func_77619_b() {
        return 20;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || enchantment.field_77351_y == EnchantmentType.WEAPON && enchantment != Enchantments.field_191530_r;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState blockState = world.func_180495_p(pos);
        ItemStack itemStack = context.func_195996_i();
        PlayerEntity player = context.func_195999_j();
        if (context.func_225518_g_()) {
            return ActionResultType.PASS;
        }
        if (!blockState.func_235714_a_(MutantBeasts.ENDERSOUL_HAND_HOLDABLE)) {
            return ActionResultType.PASS;
        }
        if (!world.func_175660_a(player, pos)) {
            return ActionResultType.PASS;
        }
        if (!player.func_175151_a(pos, context.func_196000_l(), itemStack)) {
            return ActionResultType.PASS;
        }
        if (!world.field_72995_K) {
            world.func_217376_c((Entity)new ThrowableBlockEntity(player, blockState, pos));
            world.func_217377_a(pos, false);
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!playerIn.func_226563_dT_()) {
            return ActionResult.func_226250_c_((Object)stack);
        }
        RayTraceResult result = playerIn.func_213324_a(128.0, 1.0f, false);
        if (result.func_216346_c() != RayTraceResult.Type.BLOCK) {
            playerIn.func_146105_b((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".teleport_failed"), true);
            return ActionResult.func_226251_d_((Object)stack);
        }
        if (!worldIn.field_72995_K) {
            BlockPos startPos = ((BlockRayTraceResult)result).func_216350_a();
            BlockPos endPos = startPos.func_177972_a(((BlockRayTraceResult)result).func_216354_b());
            BlockPos posDown = startPos.func_177977_b();
            if (!worldIn.func_175623_d(posDown) || !worldIn.func_180495_p(posDown).func_185904_a().func_76230_c()) {
                for (int tries = 0; tries < 3; ++tries) {
                    BlockPos checkPos = startPos.func_177981_b(tries + 1);
                    if (!worldIn.func_175623_d(checkPos)) continue;
                    endPos = checkPos;
                    break;
                }
            }
            worldIn.func_184148_a(null, playerIn.field_70169_q, playerIn.field_70167_r, playerIn.field_70166_s, SoundEvents.field_187544_ad, playerIn.func_184176_by(), 1.0f, 1.0f);
            playerIn.func_70634_a((double)endPos.func_177958_n() + 0.5, (double)endPos.func_177956_o(), (double)endPos.func_177952_p() + 0.5);
            worldIn.func_184133_a(null, endPos, SoundEvents.field_187544_ad, playerIn.func_184176_by(), 1.0f, 1.0f);
            MutantEndermanEntity.teleportAttack((LivingEntity)playerIn);
            EntityUtil.sendParticlePacket((Entity)playerIn, (IParticleData)MBParticleTypes.ENDERSOUL, 256);
            playerIn.func_184811_cZ().func_185145_a((Item)this, 40);
            stack.func_222118_a(4, (LivingEntity)playerIn, e -> e.func_213334_d(handIn));
        }
        playerIn.field_70143_R = 0.0f;
        playerIn.func_184609_a(handIn);
        playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        return ActionResult.func_233538_a_((Object)stack, (boolean)worldIn.field_72995_K);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        return slot == EquipmentSlotType.MAINHAND ? this.attributeModifiers : super.getAttributeModifiers(slot, stack);
    }
}

